/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic2;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.LookupTableImageN;
import org.eclipse.imagen.media.lookup.LookupTable;
import org.eclipse.imagen.media.lookup.LookupTableFactory;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.WMSServiceExceptionHandler;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.DirectRasterRenderer;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.KMLStyleFilteringVisitor;
import org.geoserver.wms.map.MarkFactoryHintsInjector;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.PaletteExtractor;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geoserver.wms.map.RenderingTimeoutEnforcer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.image.ImageWorker;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.StyleLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;

public class RenderedImageMapOutputFormat
extends AbstractMapOutputFormat {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List<String> AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    public static final String MAP_WRAPPING_FORMAT_OPTION = "mapWrapping";
    public static final String ADV_PROJECTION_HANDLING_FORMAT_OPTION = "advancedProjectionHandling";
    private static final String ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION = "advancedProjectionHandlingDensification";
    private static final String DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION = "disableDatelineWrappingHeuristic";
    public static final String DECORATIONS_ONLY_FORMAT_OPTION = "decorationsOnly";
    private static final int KB = 1024;
    private static LookupTableImageN IDENTITY_TABLE = new LookupTableImageN(RenderedImageMapOutputFormat.getTable());
    private Function<WMSMapContent, LabelCache> labelCache = null;
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private boolean palleteSupported = true;
    private boolean transparencySupported = true;
    private String extension = null;
    private final Map<String, MapProducerCapabilities> capabilities = new HashMap<String, MapProducerCapabilities>();
    private final MarkFactoryHintsInjector markFactoryHintsInjector;

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public RenderedImageMapOutputFormat(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapOutputFormat(String mime, WMS wms) {
        this(mime, new String[]{mime}, wms);
    }

    public RenderedImageMapOutputFormat(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
        this.markFactoryHintsInjector = new MarkFactoryHintsInjector(wms.getGeoServer());
        Collection<RenderedImageMapResponse> responses = this.wms.getAvailableMapResponses();
        for (RenderedImageMapResponse response : responses) {
            for (String outFormat : outputFormats) {
                MapProducerCapabilities cap;
                if (!response.getOutputFormats().contains(outFormat) || (cap = response.getCapabilities(outFormat)) == null) continue;
                this.capabilities.put(outFormat, cap);
            }
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return this.capabilities.get(format);
    }

    public void setLabelCache(Function<WMSMapContent, LabelCache> labelCache) {
        this.labelCache = labelCache;
    }

    @Override
    public final RenderedImageMap produceMap(WMSMapContent mapContent) throws ServiceException {
        return this.produceMap(mapContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImageMap produceMap(final WMSMapContent mapContent, boolean tiled) throws ServiceException {
        String antialias;
        Rectangle paintArea = new Rectangle(0, 0, mapContent.getMapWidth(), mapContent.getMapHeight());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + paintArea.width + "x" + paintArea.height + " image");
        }
        GetMapRequest request = mapContent.getRequest();
        String decorationsOnly = (String)request.getFormatOptions().get(DECORATIONS_ONLY_FORMAT_OPTION);
        boolean emptyMap = false;
        if (decorationsOnly != null && decorationsOnly.toLowerCase().equals("true")) {
            emptyMap = true;
        }
        if ((antialias = (String)request.getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel potentialPalette = null;
        boolean transparent = mapContent.isTransparent() && this.isTransparencySupported();
        Color bgColor = mapContent.getBgColor();
        if (AA_NONE.equals(antialias)) {
            potentialPalette = mapContent.getPalette();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
            List layers = mapContent.layers();
            for (Layer layer : layers) {
                pe.visit(layer.getStyle());
                if (pe.canComputePalette()) continue;
                break;
            }
            if (pe.canComputePalette()) {
                potentialPalette = pe.getPalette();
            }
        }
        final IndexColorModel palette = potentialPalette;
        long maxMemory = this.wms.getMaxRequestMemory() * 1024;
        long memory = this.getDrawingSurfaceMemoryUse(paintArea.width, paintArea.height, palette, transparent);
        StreamingRenderer testRenderer = this.buildRenderer();
        testRenderer.setMapContent((MapContent)mapContent);
        if (maxMemory > 0L && (memory += (long)testRenderer.getMaxBackBufferMemory(paintArea.width, paintArea.height)) > maxMemory) {
            long kbUsed = memory / 1024L;
            long kbMax = maxMemory / 1024L;
            throw new ServiceException("Rendering request would use " + kbUsed + "KB, whilst the maximum memory allowed is " + kbMax + "KB", "MaxMemoryExceeded");
        }
        MapDecorationLayout layout = this.findDecorationLayout(request, tiled);
        RenderedImage image = null;
        if (DefaultWebMapService.isDirectRasterPathEnabled() && mapContent.layers().size() == 1 && mapContent.getAngle() == 0.0 && (layout == null || layout.isEmpty())) {
            try {
                Interpolation interpolation = null;
                if (request.getInterpolations() != null && !request.getInterpolations().isEmpty()) {
                    interpolation = request.getInterpolations().get(0);
                }
                image = new DirectRasterRenderer(this.wms, mapContent, 0, interpolation, this.transparencySupported).render();
            }
            catch (Exception e) {
                throw new ServiceException("Error rendering coverage on the fast path", (Throwable)e);
            }
            if (image != null) {
                image = new RenderedImageTimeDecorator(image);
                ((RenderedImageTimeDecorator)image).setLayer((Layer)mapContent.layers().get(0));
                return this.buildMap(mapContent, image);
            }
        }
        boolean useAlpha = transparent || MetatileMapOutputFormat.isRequestTiled(request, this);
        final RenderedImage preparedImage = this.prepareImage(paintArea.width, paintArea.height, palette, useAlpha);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphic = this.getGraphics(transparent, bgColor, preparedImage, hintsMap);
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + String.valueOf(AA_SETTINGS));
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.wms != null) {
            if (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(ImageN.KEY_INTERPOLATION, NN_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else if (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(ImageN.KEY_INTERPOLATION, BIL_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(ImageN.KEY_INTERPOLATION, BIC_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        graphic.setRenderingHints(hintsMap);
        RenderingHints hints = new RenderingHints(hintsMap);
        StreamingRenderer renderer = this.buildRenderer();
        renderer.setThreadPool(DefaultWebMapService.getRenderingPool());
        renderer.setMapContent((MapContent)mapContent);
        this.markFactoryHintsInjector.addMarkFactoryHints(hints);
        renderer.setJava2DHints(hints);
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        rendererParams.put("renderingBuffer", mapContent.getBuffer());
        rendererParams.put("maxFiltersToSendToDatastore", DefaultWebMapService.getMaxFilterRules());
        rendererParams.put("scaleComputationMethod", mapContent.getRendererScaleMethod());
        if (AA_NONE.equals(antialias)) {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_STRING);
        } else {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_OUTLINE);
        }
        if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", true);
        }
        if (this.wms.isAdvancedProjectionHandlingEnabled()) {
            rendererParams.put(ADV_PROJECTION_HANDLING_FORMAT_OPTION, true);
            if (request.getFormatOptions().get(ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION) != null) {
                rendererParams.put("advancedProjectionDensificationEnabled", RenderedImageMapOutputFormat.getFormatOptionAsBoolean(request, ADV_PROJECTION_DENSIFICATION_FORMAT_OPTION));
            } else if (this.wms.isAdvancedProjectionDensificationEnabled()) {
                rendererParams.put("advancedProjectionDensificationEnabled", true);
            }
            if (this.wms.isContinuousMapWrappingEnabled()) {
                rendererParams.put("continuousMapWrapping", true);
            }
            if (request.getFormatOptions().get(DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION) != null) {
                rendererParams.put("datelineWrappingCheckEnabled", !RenderedImageMapOutputFormat.getFormatOptionAsBoolean(request, DISABLE_DATELINE_WRAPPING_HEURISTIC_FORMAT_OPTION));
            } else if (this.wms.isDateLineWrappingHeuristicDisabled()) {
                rendererParams.put("datelineWrappingCheckEnabled", false);
            }
        }
        if (!RenderedImageMapOutputFormat.getFormatOptionAsBoolean(request, ADV_PROJECTION_HANDLING_FORMAT_OPTION)) {
            rendererParams.put(ADV_PROJECTION_HANDLING_FORMAT_OPTION, false);
            rendererParams.put("continuousMapWrapping", false);
        }
        if (!RenderedImageMapOutputFormat.getFormatOptionAsBoolean(request, MAP_WRAPPING_FORMAT_OPTION)) {
            rendererParams.put("continuousMapWrapping", false);
        }
        if (request.getFormatOptions().get("dpi") != null) {
            rendererParams.put("dpi", request.getFormatOptions().get("dpi"));
        }
        if (this.labelCache != null) {
            try {
                rendererParams.put("labelCache", this.labelCache.apply(mapContent));
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        boolean kmplacemark = false;
        if (request.getFormatOptions().get("kmplacemark") != null) {
            kmplacemark = (Boolean)request.getFormatOptions().get("kmplacemark");
        }
        if (kmplacemark) {
            KMLStyleFilteringVisitor dupVisitor = new KMLStyleFilteringVisitor();
            List layers = mapContent.layers();
            for (Layer value : layers) {
                if (!(value instanceof StyleLayer)) continue;
                StyleLayer layer = (StyleLayer)value;
                Style style = layer.getStyle();
                style.accept((StyleVisitor)dupVisitor);
                Style copy = (Style)dupVisitor.getCopy();
                layer.setStyle(copy);
            }
        }
        for (int i = 0; i < request.getLayers().size(); ++i) {
            LayerInfo layerInfo;
            LayerInfo.WMSInterpolation byLayerInterpolation;
            Interpolation interpolationToSet = null;
            if (request.getInterpolations() != null && request.getInterpolations().size() > i) {
                interpolationToSet = request.getInterpolations().get(i);
            }
            if (interpolationToSet == null && (byLayerInterpolation = RenderedImageMapOutputFormat.getConfiguredLayerInterpolation(layerInfo = request.getLayers().get(i).getLayerInfo())) != null) {
                interpolationToSet = RenderedImageMapOutputFormat.toInterpolationObject(byLayerInterpolation);
            }
            if (interpolationToSet == null) continue;
            Layer layer = (Layer)mapContent.layers().get(i);
            layer.getUserData().put("byLayerInterpolation", interpolationToSet);
        }
        renderer.setRendererHints(rendererParams);
        int maxErrors = this.wms.getMaxRenderingErrors();
        MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
        RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
        renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
        RenderTimeStatistics statistics = null;
        if (!request.getRequest().equalsIgnoreCase("GETFEATUREINFO")) {
            statistics = new RenderTimeStatistics();
            renderer.addRenderListener((RenderListener)statistics);
        }
        this.onBeforeRender(renderer);
        int maxRenderingTime = this.wms.getMaxRenderingTime(request);
        ServiceException serviceException = null;
        boolean saveMap = request.getRawKvp() != null && WMSServiceExceptionHandler.isPartialMapExceptionType(request.getRawKvp().get("EXCEPTIONS"));
        RenderingTimeoutEnforcer timeout = new RenderingTimeoutEnforcer(maxRenderingTime, (GTRenderer)renderer, graphic, saveMap){

            @Override
            public void saveMap() {
                this.map = RenderedImageMapOutputFormat.this.optimizeAndBuildMap(palette, preparedImage, mapContent);
            }
        };
        timeout.start();
        try {
            Object renderError;
            if (!emptyMap) {
                renderer.paint(graphic, paintArea, mapContent.getRenderingArea(), mapContent.getRenderingTransform());
            } else {
                LOGGER.fine("we only want to get the layout, if it's not null");
            }
            if (layout != null) {
                try {
                    layout.paint(graphic, paintArea, mapContent);
                }
                catch (Exception e) {
                    throw new ServiceException("Problem occurred while trying to watermark data", (Throwable)e);
                }
            }
            timeout.stop();
            if (errorChecker.exceedsMaxErrors()) {
                serviceException = new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out. Layers: " + this.buildMapLayerNameList(mapContent), (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (timeout.isTimedOut()) {
                serviceException = new ServiceException("This request used more time than allowed and has been forcefully stopped. Max rendering time is " + (double)maxRenderingTime / 1000.0 + "s. Layers: " + this.buildMapLayerNameList(mapContent));
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                renderError = nonIgnorableExceptionListener.getException();
                serviceException = new ServiceException("Rendering process failed. Layers: " + this.buildMapLayerNameList(mapContent), (Throwable)renderError, "internalError");
            }
            if (serviceException == null) {
                renderError = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                return renderError;
            }
            if (saveMap) {
                RenderedImageMap map = (RenderedImageMap)timeout.getMap();
                if (map == null) {
                    map = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                }
                serviceException = new WMSPartialMapException(serviceException, (WebMap)map);
            }
        }
        finally {
            timeout.stop();
            graphic.dispose();
            if (statistics != null) {
                statistics.renderingComplete();
            }
        }
        throw serviceException;
    }

    private String buildMapLayerNameList(WMSMapContent mapContent) {
        List<MapLayerInfo> layers = mapContent.getRequest().getLayers();
        return layers == null ? "" : layers.stream().map(MapLayerInfo::getName).collect(Collectors.joining(", "));
    }

    protected StreamingRenderer buildRenderer() {
        return new StreamingRenderer();
    }

    public static boolean getFormatOptionAsBoolean(GetMapRequest request, String formatOptionKey) {
        if (request.getFormatOptions().get(formatOptionKey) != null) {
            String formatOptionValue = (String)request.getFormatOptions().get(formatOptionKey);
            return !"false".equalsIgnoreCase(formatOptionValue);
        }
        return true;
    }

    private RenderedImageMap optimizeAndBuildMap(IndexColorModel palette, RenderedImage preparedImage, WMSMapContent mapContent) {
        RenderedImage image = palette != null && palette.getMapSize() < 256 ? RenderedImageMapOutputFormat.optimizeSampleModel(preparedImage) : preparedImage;
        return this.buildMap(mapContent, image);
    }

    protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
        return ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
    }

    protected void onBeforeRender(StreamingRenderer renderer) {
    }

    protected RenderedImageMap buildMap(WMSMapContent mapContent, RenderedImage image) {
        RenderedImageMap map = new RenderedImageMap(mapContent, image, this.getMimeType());
        if (this.extension != null) {
            map.setContentDispositionHeader(mapContent, "." + this.extension, false);
        }
        return map;
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public void setTransparencySupported(boolean supportsTransparency) {
        this.transparencySupported = supportsTransparency;
    }

    public boolean isPaletteSupported() {
        return this.palleteSupported;
    }

    public void setPaletteSupported(boolean supportsPalette) {
        this.palleteSupported = supportsPalette;
    }

    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.getDrawingSurfaceMemoryUse(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    private static RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, layout);
        LookupTable table = LookupTableFactory.create((LookupTableImageN)IDENTITY_TABLE);
        ImageWorker worker = new ImageWorker(source);
        worker.setRenderingHints(hints);
        worker.lookup(table);
        return worker.getRenderedImage();
    }

    static LayerInfo.WMSInterpolation getConfiguredLayerInterpolation(LayerInfo layer) {
        LayerInfo.WMSInterpolation configuredInterpolation = null;
        if (layer != null && layer.getDefaultWMSInterpolationMethod() != null) {
            try {
                configuredInterpolation = layer.getDefaultWMSInterpolationMethod();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return configuredInterpolation;
    }

    static Interpolation toInterpolationObject(LayerInfo.WMSInterpolation interpolationMethod) {
        if (interpolationMethod == null) {
            return null;
        }
        switch (interpolationMethod) {
            case Bilinear: {
                return Interpolation.getInstance((int)1);
            }
            case Bicubic: {
                return Interpolation.getInstance((int)2);
            }
        }
        return Interpolation.getInstance((int)0);
    }

    static Interpolation toInterpolationObject(WMSInfo.WMSInterpolation interpolationMethod) {
        if (interpolationMethod == null) {
            return null;
        }
        switch (interpolationMethod) {
            case Bilinear: {
                return Interpolation.getInstance((int)1);
            }
            case Bicubic: {
                return Interpolation.getInstance((int)2);
            }
        }
        return Interpolation.getInstance((int)0);
    }
}

