/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geotools.map.Layer;

public class RenderedImageTimeDecorator
implements RenderedImage {
    private RenderedImage delegate;
    private RenderTimeStatistics statistics;
    private Layer layer;

    public RenderedImageTimeDecorator(RenderedImage delegate) {
        this.delegate = delegate;
        this.statistics = new RenderTimeStatistics();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.delegate.getSources();
    }

    @Override
    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.delegate.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.delegate.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.delegate.getWidth();
    }

    @Override
    public int getHeight() {
        return this.delegate.getHeight();
    }

    @Override
    public int getMinX() {
        return this.delegate.getMinX();
    }

    @Override
    public int getMinY() {
        return this.delegate.getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.delegate.getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.delegate.getNumYTiles();
    }

    @Override
    public int getMinTileX() {
        return this.delegate.getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.delegate.getMinTileY();
    }

    @Override
    public int getTileWidth() {
        return this.delegate.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.delegate.getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.delegate.getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.delegate.getTileGridYOffset();
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        this.updateRenderingTime();
        return this.delegate.getTile(tileX, tileY);
    }

    @Override
    public Raster getData() {
        this.updateRenderingTime();
        return this.delegate.getData();
    }

    @Override
    public Raster getData(Rectangle rect) {
        return this.delegate.getData(rect);
    }

    @Override
    public WritableRaster copyData(WritableRaster raster) {
        return this.delegate.copyData(raster);
    }

    public void updateRenderingTime() {
        this.statistics.layerEnd(this.layer);
    }

    public RenderTimeStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RenderTimeStatistics statistics) {
        this.statistics = statistics;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        this.onSettingLayer(this.layer);
    }

    public void onSettingLayer(Layer layer) {
        this.statistics.layerStart(layer);
    }

    public RenderedImage getDelegate() {
        return this.delegate;
    }
}

