/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.map.LiteFeatureTypeStyle;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.filter.visitor.SpatialFilterVisitor;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class StyleQueryUtil {
    public static final Logger LOGGER = Logging.getLogger(StyleQueryUtil.class);

    private StyleQueryUtil() {
    }

    public static List<Query> getStyleQuery(List<Layer> layers, WMSMapContent mapContent) {
        return layers.stream().map(layer -> {
            try {
                return StyleQueryUtil.getStyleQuery(layer, mapContent);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static Query getStyleQuery(Layer layer, WMSMapContent mapContent) throws IOException {
        Query styleQuery;
        ReferencedEnvelope renderingArea = mapContent.getRenderingArea();
        Rectangle screenSize = new Rectangle(mapContent.getMapWidth(), mapContent.getMapHeight());
        double mapScale = StyleQueryUtil.getMapScale(mapContent, renderingArea);
        int requestBufferScreen = mapContent.getBuffer();
        double[] pixelSize = StyleQueryUtil.getPixelSize(renderingArea, screenSize);
        FeatureSource featureSource = layer.getFeatureSource();
        FeatureType schema = featureSource.getSchema();
        List<LiteFeatureTypeStyle> styleList = StyleQueryUtil.getFeatureStyles(layer, mapScale, schema);
        if (styleList.isEmpty()) {
            Query query = new Query(schema.getName().getLocalPart());
            query.setFilter((Filter)Filter.EXCLUDE);
            return query;
        }
        int bufferScreen = StyleQueryUtil.getComputedBuffer(requestBufferScreen, styleList);
        ReferencedEnvelope queryArea = new ReferencedEnvelope(renderingArea);
        queryArea.expandBy((double)bufferScreen * Math.max(pixelSize[0], pixelSize[1]));
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        try {
            styleQuery = StyleQueryUtil.getStyleQuery(featureSource, styleList, queryArea, geometryDescriptor);
        }
        catch (FactoryException | IllegalFilterException e) {
            throw new RuntimeException(e);
        }
        Query query = DataUtilities.mixQueries((Query)styleQuery, (Query)layer.getQuery(), null);
        query.setProperties(Query.ALL_PROPERTIES);
        Hints hints = query.getHints();
        hints.put((Object)Hints.FEATURE_2D, (Object)Boolean.TRUE);
        return query;
    }

    public static List<LiteFeatureTypeStyle> getLiteFeatureStyles(Layer layer, WMSMapContent mapContent) {
        ReferencedEnvelope renderingArea = mapContent.getRenderingArea();
        double mapScale = StyleQueryUtil.getMapScale(mapContent, renderingArea);
        FeatureSource featureSource = layer.getFeatureSource();
        FeatureType schema = featureSource.getSchema();
        return StyleQueryUtil.getFeatureStyles(layer, mapScale, schema);
    }

    public static double getMapScale(WMSMapContent mapContent, ReferencedEnvelope renderingArea) {
        return RendererUtilities.calculateOGCScale((ReferencedEnvelope)renderingArea, (int)mapContent.getMapWidth(), null);
    }

    public static int getComputedBuffer(int requestBufferScreen, List<LiteFeatureTypeStyle> styleList) {
        int bufferScreen;
        if (requestBufferScreen <= 0) {
            MetaBufferEstimator bufferEstimator = new MetaBufferEstimator();
            styleList.stream().flatMap(fts -> Stream.concat(Arrays.stream(fts.elseRules), Arrays.stream(fts.ruleList))).forEach(arg_0 -> ((MetaBufferEstimator)bufferEstimator).visit(arg_0));
            bufferScreen = bufferEstimator.getBuffer();
        } else {
            bufferScreen = requestBufferScreen;
        }
        return bufferScreen;
    }

    public static List<LiteFeatureTypeStyle> getFeatureStyles(Layer layer, double mapScale, FeatureType schema) {
        Style style = layer.getStyle();
        List featureStyles = style.featureTypeStyles();
        return StyleQueryUtil.createLiteFeatureTypeStyles(layer, featureStyles, schema, mapScale);
    }

    private static double[] getPixelSize(ReferencedEnvelope renderingArea, Rectangle screenSize) {
        double[] pixelSize;
        try {
            pixelSize = Decimator.computeGeneralizationDistances((MathTransform)ProjectiveTransform.create((AffineTransform)RendererUtilities.worldToScreenTransform((ReferencedEnvelope)renderingArea, (Rectangle)screenSize)).inverse(), (Rectangle)screenSize, (double)1.0);
        }
        catch (TransformException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error while computing pixel size", ex);
            }
            pixelSize = new double[]{renderingArea.getWidth() / screenSize.getWidth(), renderingArea.getHeight() / screenSize.getHeight()};
        }
        return pixelSize;
    }

    private static Query getStyleQuery(FeatureSource<?, ?> source, List<LiteFeatureTypeStyle> styleList, ReferencedEnvelope queryArea, GeometryDescriptor geometryAttribute) throws IllegalFilterException, FactoryException {
        FeatureType schema = source.getSchema();
        Query query = new Query(schema.getName().getLocalPart());
        query.setProperties(Query.ALL_PROPERTIES);
        String geomName = geometryAttribute.getLocalName();
        Filter filter = StyleQueryUtil.reprojectSpatialFilter(queryArea.getCoordinateReferenceSystem(), schema, (Filter)MapDecorationLayout.FF.bbox((Expression)MapDecorationLayout.FF.property(geomName), (BoundingBox)queryArea));
        query.setFilter(filter);
        LiteFeatureTypeStyle[] styles = styleList.toArray(new LiteFeatureTypeStyle[styleList.size()]);
        try {
            StyleQueryUtil.processRuleForQuery(styles, query);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        simplifier.setFeatureType(source.getSchema());
        Filter simplifiedFilter = (Filter)query.getFilter().accept((FilterVisitor)simplifier, null);
        query.setFilter(simplifiedFilter);
        return query;
    }

    private static Filter reprojectSpatialFilter(CoordinateReferenceSystem declaredCRS, FeatureType schema, Filter filter) {
        if (filter == null) {
            return null;
        }
        SpatialFilterVisitor sfv = new SpatialFilterVisitor();
        filter.accept((FilterVisitor)sfv, null);
        if (!sfv.hasSpatialFilter()) {
            return filter;
        }
        DefaultCRSFilterVisitor defaulter = new DefaultCRSFilterVisitor(MapDecorationLayout.FF, declaredCRS);
        Filter defaulted = (Filter)filter.accept((FilterVisitor)defaulter, null);
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(MapDecorationLayout.FF, schema);
        return (Filter)defaulted.accept((FilterVisitor)reprojector, null);
    }

    private static ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(Layer layer, List<FeatureTypeStyle> featureStyles, FeatureType ftype, double scaleDenominator) {
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureStyles) {
            if (!StyleQueryUtil.isFeatureTypeStyleActive(ftype, fts)) continue;
            List<Rule>[] splittedRules = StyleQueryUtil.splitRules(fts, scaleDenominator);
            List<Rule> ruleList = splittedRules[0];
            List<Rule> elseRuleList = splittedRules[1];
            if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
            Graphics2D graphics = null;
            LiteFeatureTypeStyle lfts = new LiteFeatureTypeStyle(layer, graphics, ruleList, elseRuleList, fts.getTransformation(), fts.getOptions());
            result.add(lfts);
        }
        return result;
    }

    private static List<Rule>[] splitRules(FeatureTypeStyle fts, double scaleDenominator) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        for (Rule r : fts.rules()) {
            if (!StyleQueryUtil.isWithInScale(r, scaleDenominator)) continue;
            if (r.isElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            ruleList.add(r);
        }
        List[] ret = new List[]{ruleList, elseRuleList};
        return ret;
    }

    private static boolean isWithInScale(Rule r, double scaleDenominator) {
        double TOLERANCE = 1.0E-6;
        return r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    private static boolean isFeatureTypeStyleActive(FeatureType ftype, FeatureTypeStyle fts) {
        return fts.featureTypeNames().isEmpty() || fts.featureTypeNames().stream().anyMatch(tn -> FeatureTypes.matches((FeatureType)ftype, (Name)tn));
    }

    private static void processRuleForQuery(LiteFeatureTypeStyle[] styles, Query query) {
        block7: {
            try {
                int maxFilters = 5;
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                for (LiteFeatureTypeStyle style : styles) {
                    if (style.elseRules.length > 0) {
                        return;
                    }
                    for (Rule r : style.ruleList) {
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (filtersToDS.size() > 5) {
                    return;
                }
                Object ruleFiltersCombined = filtersToDS.size() == 1 ? (Filter)filtersToDS.get(0) : MapDecorationLayout.FF.or(filtersToDS);
                ruleFiltersCombined = MapDecorationLayout.FF.and(query.getFilter(), (Filter)ruleFiltersCombined);
                query.setFilter((Filter)ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getMessage(), e);
            }
        }
    }

    public static MathTransform buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        Preconditions.checkNotNull((Object)sourceCRS, (Object)"sourceCRS");
        Preconditions.checkNotNull((Object)destCRS, (Object)"destCRS");
        MathTransform transform = null;
        if (sourceCRS.getCoordinateSystem().getDimension() >= 3) {
            MathTransform toWgs84_3d = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
            MathTransform toWgs84_2d = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            transform = ConcatenatedTransform.create((MathTransform)toWgs84_3d, (MathTransform)toWgs84_2d);
            sourceCRS = DefaultGeographicCRS.WGS84;
        }
        MathTransform2D sourceToTarget = (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        if (transform == null) {
            return sourceToTarget;
        }
        if (sourceToTarget.isIdentity()) {
            return transform;
        }
        return ConcatenatedTransform.create((MathTransform)transform, (MathTransform)sourceToTarget);
    }
}

