/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.geoserver.wms.utfgrid.UTFGridColorFunction;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.feature.FeatureCollection;
import org.geotools.renderer.composite.BlendComposite;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

class UTFGridStyleVisitor
extends DuplicatingStyleVisitor {
    private UTFGridColorFunction colorFunction;
    boolean vectorTransformations = false;
    boolean transformations = false;
    private final Literal LITERAL_ONE = this.ff.literal(1);
    SLDStyleFactory sldFactory = new SLDStyleFactory();

    public UTFGridStyleVisitor(UTFGridColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    public void visit(Style style) {
        super.visit(style);
        Style copy = (Style)this.pages.pop();
        ArrayList featureTypeStyles = new ArrayList(copy.featureTypeStyles());
        Iterator it = featureTypeStyles.iterator();
        while (it.hasNext()) {
            FeatureTypeStyle fts = (FeatureTypeStyle)it.next();
            if (!fts.rules().isEmpty()) continue;
            it.remove();
        }
        copy.featureTypeStyles().clear();
        copy.featureTypeStyles().addAll(featureTypeStyles);
        this.pages.push(copy);
    }

    public void visit(FeatureTypeStyle fts) {
        Map options;
        String composite;
        super.visit(fts);
        FeatureTypeStyle copy = (FeatureTypeStyle)this.pages.peek();
        ArrayList rules = new ArrayList(copy.rules());
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            if (!rule.symbolizers().isEmpty()) continue;
            it.remove();
        }
        copy.rules().clear();
        copy.rules().addAll(rules);
        if (copy.getTransformation() instanceof Function) {
            this.transformations = true;
            Function f = (Function)fts.getTransformation();
            Class<?> returnType = this.getFunctionReturnType(f);
            if (Object.class.equals(returnType) || FeatureCollection.class.isAssignableFrom(returnType)) {
                this.vectorTransformations = true;
                super.visit(fts);
            } else {
                copy.rules().clear();
            }
        }
        if ((composite = (String)(options = copy.getOptions()).get("composite")) != null && BlendComposite.BlendingMode.lookupByName((String)composite) != null) {
            options.remove("composite");
            options.remove("composite-base");
        }
    }

    public void visit(Rule rule) {
        super.visit(rule);
        Rule copy = (Rule)this.pages.pop();
        ArrayList symbolizers = new ArrayList(copy.symbolizers());
        Iterator it = symbolizers.iterator();
        while (it.hasNext()) {
            Symbolizer symbolizer = (Symbolizer)it.next();
            if (symbolizer != null) continue;
            it.remove();
        }
        copy.symbolizers().clear();
        copy.symbolizers().addAll(symbolizers);
        this.pages.push(copy);
    }

    Class<?> getFunctionReturnType(Function f) {
        FunctionName name = f.getFunctionName();
        if (name == null || name.getReturn() == null) {
            return Object.class;
        }
        return name.getReturn().getType();
    }

    public void visit(Graphic gr) {
        Displacement displacementCopy = this.copy(gr.getDisplacement());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.copy(gr.getSize());
        AnchorPoint anchorCopy = this.copy(gr.getAnchorPoint());
        ArrayList<Mark> symbolsCopy = new ArrayList<Mark>();
        for (GraphicalSymbol gs : gr.graphicalSymbols()) {
            if (gs instanceof Mark) {
                Mark mark1 = (Mark)gs;
                Mark markCopy = this.copy(mark1);
                symbolsCopy.add(markCopy);
                continue;
            }
            if (!(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic eg = (ExternalGraphic)gs;
            if (gr.getSize() != null && !Expression.NIL.equals(gr.getSize())) {
                Mark mark = this.sf.createMark((Expression)this.ff.literal((Object)"square"), null, this.sf.createFill((Expression)this.colorFunction), sizeCopy, Expression.NIL);
                symbolsCopy.add(mark);
                continue;
            }
            Literal sizeExpression = this.estimateGraphicSize(eg);
            Mark mark = this.sf.createMark((Expression)this.ff.literal((Object)"square"), null, this.sf.createFill((Expression)this.colorFunction), (Expression)sizeExpression, Expression.NIL);
            symbolsCopy.add(mark);
        }
        Graphic copy = this.sf.createDefaultGraphic();
        copy.setDisplacement(displacementCopy);
        copy.setAnchorPoint(anchorCopy);
        copy.setOpacity((Expression)this.LITERAL_ONE);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.graphicalSymbols().clear();
        copy.graphicalSymbols().addAll(symbolsCopy);
        if (this.STRICT && !copy.equals(gr)) {
            throw new IllegalStateException("Was unable to duplicate provided Graphic:" + String.valueOf(gr));
        }
        this.pages.push(copy);
    }

    private Literal estimateGraphicSize(ExternalGraphic eg) {
        Graphic testGraphic = this.sf.createGraphic(new ExternalGraphic[]{eg}, null, null, (Expression)this.LITERAL_ONE, Expression.NIL, (Expression)this.ff.literal(0));
        PointSymbolizer testSymbolizer = this.sf.createPointSymbolizer(testGraphic, null);
        Style2D style = this.sldFactory.createStyle(null, (Symbolizer)testSymbolizer);
        int size = 16;
        if (style instanceof GraphicStyle2D) {
            GraphicStyle2D gs2d = (GraphicStyle2D)style;
            size = gs2d.getImage().getWidth();
        } else if (style instanceof IconStyle2D) {
            IconStyle2D is2d = (IconStyle2D)style;
            size = is2d.getIcon().getIconWidth();
        }
        Literal sizeExpression = this.ff.literal(size);
        return sizeExpression;
    }

    public void visit(Fill fill) {
        super.visit(fill);
        Fill copy = (Fill)this.pages.peek();
        if (copy.getGraphicFill() != null) {
            copy.setGraphicFill(null);
        }
        copy.setColor((Expression)this.colorFunction);
        copy.setOpacity((Expression)this.LITERAL_ONE);
    }

    public void visit(Stroke stroke) {
        super.visit(stroke);
        Stroke copy = (Stroke)this.pages.peek();
        if (copy.getGraphicFill() != null) {
            copy.setGraphicFill(null);
        }
        if (copy.getGraphicStroke() != null) {
            copy.setWidth(this.getSymbolsSize(copy.getGraphicStroke()));
            copy.setGraphicStroke(null);
        }
        copy.setColor((Expression)this.colorFunction);
        copy.setOpacity((Expression)this.LITERAL_ONE);
        if (copy.dashArray() != null) {
            copy.dashArray().clear();
        }
        copy.setDashOffset(null);
    }

    private Expression getSymbolsSize(Graphic graphic) {
        Expression size = graphic.getSize();
        if (size != null && !Expression.NIL.equals(size)) {
            return size;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            if (gs instanceof Mark) {
                return this.ff.literal(16);
            }
            if (!(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic externalGraphic = (ExternalGraphic)gs;
            return this.estimateGraphicSize(externalGraphic);
        }
        return this.ff.literal(16);
    }

    public void visit(TextSymbolizer text) {
        this.pages.push(null);
    }

    public void visit(RasterSymbolizer raster) {
        this.pages.push(null);
    }

    public boolean hasVectorTransformations() {
        return this.vectorTransformations;
    }

    public boolean hasTransformations() {
        return this.transformations;
    }
}

