/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.security.DisabledServiceResourceFilter;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.wfs.xml.GML32OutputFormat;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.DefaultProgressListener;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_1.WFS;
import org.locationtech.jts.geom.Envelope;

public class PreviewLayer {
    static final Logger LOGGER = Logging.getLogger(PreviewLayer.class);
    LayerInfo layerInfo;
    LayerGroupInfo groupInfo;
    transient GetMapRequest request;

    public PreviewLayer(LayerInfo layerInfo) {
        this.layerInfo = layerInfo;
    }

    public PreviewLayer(LayerGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public String getName() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().prefixedName();
        }
        return this.groupInfo.prefixedName();
    }

    public String getWorkspace() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getStore().getWorkspace().getName();
        }
        if (this.groupInfo != null && this.groupInfo.getWorkspace() != null) {
            return this.groupInfo.getWorkspace().getName();
        }
        return null;
    }

    public PackageResourceReference getIcon() {
        if (this.layerInfo != null) {
            return CatalogIconFactory.get().getSpecificLayerIcon(this.layerInfo);
        }
        return CatalogIconFactory.GROUP_ICON;
    }

    public PackageResourceReference getTypeSpecificIcon() {
        if (this.layerInfo != null) {
            return CatalogIconFactory.get().getSpecificLayerIcon(this.layerInfo);
        }
        return CatalogIconFactory.GROUP_ICON;
    }

    public String getTitle() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getTitle();
        }
        if (this.groupInfo != null) {
            return this.groupInfo.getTitle();
        }
        return "";
    }

    public String getAbstract() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getAbstract();
        }
        if (this.groupInfo != null) {
            return this.groupInfo.getAbstract();
        }
        return "";
    }

    public String getKeywords() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getKeywords().toString();
        }
        return "";
    }

    public PreviewLayerType getType() {
        if (this.layerInfo != null) {
            if (this.layerInfo.getType() == PublishedType.RASTER) {
                return PreviewLayerType.Raster;
            }
            if (this.layerInfo.getType() == PublishedType.VECTOR) {
                return PreviewLayerType.Vector;
            }
            return PreviewLayerType.Remote;
        }
        return PreviewLayerType.Group;
    }

    public GetMapRequest getRequest() {
        if (this.request == null) {
            GeoServerApplication app = GeoServerApplication.get();
            this.request = new GetMapRequest();
            Catalog catalog = app.getCatalog();
            List<MapLayerInfo> layers = this.expandLayers(catalog);
            this.request.setLayers(layers);
            this.request.setFormat("application/openlayers");
            if (this.groupInfo != null) {
                ReferencedEnvelope bounds = this.groupInfo.getBounds();
                this.request.setBbox((Envelope)bounds);
                this.request.setCrs(bounds.getCoordinateReferenceSystem());
                this.request.setSRS(PreviewLayer.lookupSRSFromBounds(bounds));
            }
            try {
                DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)this.request);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not set figure out automatically a good preview link for " + this.getName(), e);
            }
        }
        return this.request;
    }

    private static String lookupSRSFromBounds(ReferencedEnvelope bounds) {
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        if (crs == null) {
            return null;
        }
        try {
            return ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false);
        }
        catch (FactoryException e) {
            return GML2EncodingUtils.toURI((CoordinateReferenceSystem)crs, (SrsSyntax)SrsSyntax.AUTH_CODE, (boolean)false);
        }
    }

    private List<MapLayerInfo> expandLayers(Catalog catalog) {
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        if (this.layerInfo != null) {
            layers.add(new MapLayerInfo(this.layerInfo));
        } else {
            for (LayerInfo l : Iterables.filter((Iterable)this.groupInfo.getLayers(), LayerInfo.class)) {
                layers.add(new MapLayerInfo(l));
            }
        }
        return layers;
    }

    String getBaseURL(String service) {
        return this.getBaseURL(service, false);
    }

    String getBaseURL(String service, boolean useGlobalRef) {
        String base = this.getBaseURL();
        String ws = this.getWorkspace();
        if (ws == null || useGlobalRef) {
            return ResponseUtils.buildURL((String)base, (String)service, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
        return ResponseUtils.buildURL((String)base, (String)(ws + "/" + service), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private String getBaseURL() {
        HttpServletRequest req = GeoServerApplication.get().servletRequest();
        return ResponseUtils.baseURL((HttpServletRequest)req);
    }

    String getPath(String service, boolean useGlobalRef) {
        String ws = this.getWorkspace();
        if (ws == null || useGlobalRef) {
            return service;
        }
        return ws + "/" + service;
    }

    public String getWmsLink() {
        return this.getWmsLink((r, m) -> {});
    }

    public String getWmsLink(BiConsumer<GetMapRequest, Map<String, String>> parameterCustomizer) {
        GetMapRequest request = this.getRequest();
        Envelope bbox = request.getBbox();
        if (bbox == null) {
            return null;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("service", "WMS");
        params.put("version", "1.1.0");
        params.put("request", "GetMap");
        params.put("layers", this.getName());
        String bboxValue = bbox.getMinX() + "," + bbox.getMinY() + "," + bbox.getMaxX() + "," + bbox.getMaxY();
        params.put("bbox", bboxValue);
        params.put("width", String.valueOf(request.getWidth()));
        params.put("height", String.valueOf(request.getHeight()));
        params.put("srs", String.valueOf(request.getSRS()));
        params.put("styles", !request.getStyles().isEmpty() ? ((Style)request.getStyles().get(0)).getName() : "");
        parameterCustomizer.accept(request, params);
        return ResponseUtils.buildURL((String)this.getBaseURL(), (String)this.getPath("wms", false), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public String getKmlLink() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("layers", this.getName());
        return ResponseUtils.buildURL((String)this.getBaseURL(), (String)this.getPath("wms/kml", false), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public String getGmlLink(Map<String, GMLOutputParams> gmlParamsCache) {
        String dbtype;
        Map connParams;
        FeatureTypeInfo ftInfo;
        GMLOutputParams gmlParams = new GMLOutputParams();
        if (this.layerInfo != null && this.layerInfo.getResource() instanceof FeatureTypeInfo && (ftInfo = (FeatureTypeInfo)this.layerInfo.getResource()).getStore() != null && (connParams = ftInfo.getStore().getConnectionParameters()) != null && "app-schema".equals(dbtype = (String)connParams.get("dbtype"))) {
            String mappingUrl = ((Serializable)connParams.get("url")).toString();
            if (gmlParamsCache != null && gmlParamsCache.containsKey(mappingUrl)) {
                gmlParams = gmlParamsCache.get(mappingUrl);
            } else {
                gmlParams.baseUrl = this.getBaseURL();
                gmlParams.wfsVersion = WFS.getInstance().getVersion();
                try {
                    gmlParams.gmlVersion = this.findGmlVersion(ftInfo);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Could not determine GML version, using default", e);
                    gmlParams.gmlVersion = null;
                }
                if (gmlParamsCache != null) {
                    gmlParamsCache.put(mappingUrl, gmlParams);
                }
            }
        }
        return this.buildWfsLink(gmlParams);
    }

    String findGmlVersion(FeatureTypeInfo ftInfo) throws IOException {
        DefaultProgressListener listener = new DefaultProgressListener();
        Name qName = ftInfo.getQualifiedName();
        FeatureType fType = ftInfo.getStore().getDataStore((ProgressListener)listener).getSchema(qName);
        return this.findFeatureTypeGmlVersion((AttributeType)fType);
    }

    private String findFeatureTypeGmlVersion(AttributeType featureType) {
        if (featureType == null) {
            return null;
        }
        if (this.isAbstractFeatureType(featureType)) {
            String gmlNamespace = featureType.getName().getNamespaceURI();
            if ("http://www.opengis.net/gml".equals(gmlNamespace)) {
                return "gml3";
            }
            if ("http://www.opengis.net/gml/3.2".equals(gmlNamespace)) {
                return (String)GML32OutputFormat.FORMATS.get(0);
            }
            LOGGER.log(Level.FINE, "Cannot determine GML version from AbstractFeatureType type");
            return null;
        }
        AttributeType parent = featureType.getSuper();
        return this.findFeatureTypeGmlVersion(parent);
    }

    public boolean hasServiceSupport(String serviceName) {
        if (this.layerInfo != null && this.layerInfo.getResource() != null && serviceName != null) {
            List disabledServices = DisabledServiceResourceFilter.disabledServices((ResourceInfo)this.layerInfo.getResource());
            return disabledServices.stream().noneMatch(d -> d.equalsIgnoreCase(serviceName));
        }
        return true;
    }

    private boolean isAbstractFeatureType(AttributeType type) {
        if (type == null) {
            return false;
        }
        Name qName = type.getName();
        String localPart = qName.getLocalPart();
        String ns = qName.getNamespaceURI();
        return "AbstractFeatureType".equals(localPart) && ("http://www.opengis.net/gml".equals(ns) || "http://www.opengis.net/gml/3.2".equals(ns));
    }

    String buildWfsLink() {
        return this.buildWfsLink(new GMLOutputParams());
    }

    String buildWfsLink(GMLOutputParams gmlParams) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("service", "WFS");
        params.put("version", gmlParams.wfsVersion);
        params.put("request", "GetFeature");
        params.put("typeName", this.getName());
        if (gmlParams.gmlVersion != null) {
            params.put("outputFormat", gmlParams.gmlVersion);
        }
        return ResponseUtils.buildURL((String)gmlParams.baseUrl, (String)this.getPath("ows", false), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static enum PreviewLayerType {
        Raster,
        Vector,
        Remote,
        Group;

    }

    class GMLOutputParams {
        String wfsVersion = org.geotools.wfs.v1_0.WFS.getInstance().getVersion();
        String gmlVersion = null;
        String baseUrl;

        public GMLOutputParams() {
            this.baseUrl = PreviewLayer.this.getBaseURL();
        }
    }
}

