/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.data.DataUtilities;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTWriter2;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class PropertyFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    PropertyDataStore store;
    ContentFeatureSource featureSource;
    File read;
    private PropertyFeatureReader delegate;
    File write;
    WKTWriter wktWriter = new WKTWriter2(3);
    BufferedWriter writer;
    SimpleFeatureType type;
    SimpleFeature origional = null;
    SimpleFeature live = null;
    private ContentState state;

    public PropertyFeatureWriter(ContentFeatureSource source, ContentState contentState, Query query, boolean append) throws IOException {
        this.state = contentState;
        this.featureSource = source;
        PropertyDataStore store = (PropertyDataStore)contentState.getEntry().getDataStore();
        String namespaceURI = store.getNamespaceURI();
        String typeName = query.getTypeName();
        File dir = store.dir;
        this.read = new File(store.dir, typeName + ".properties");
        this.write = File.createTempFile(typeName + System.currentTimeMillis(), null, dir);
        this.delegate = new PropertyFeatureReader(namespaceURI, this.read);
        this.type = this.delegate.getFeatureType();
        this.writer = new BufferedWriter(new FileWriter(this.write, StandardCharsets.UTF_8));
        this.writer.write("_=");
        this.writer.write(DataUtilities.encodeType(this.type));
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            return false;
        }
        if (this.live != null && this.origional != null) {
            this.writeImplementation(this.origional);
            this.origional = null;
            this.live = null;
        }
        return this.delegate.hasNext();
    }

    private void writeImplementation(SimpleFeature f) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.newLine();
        this.writer.flush();
        String fid = f.getID();
        if (Boolean.TRUE.equals(f.getUserData().get(Hints.USE_PROVIDED_FID)) && f.getUserData().containsKey(Hints.PROVIDED_FID)) {
            fid = (String)f.getUserData().get(Hints.PROVIDED_FID);
        }
        this.writeFeatureID(fid);
        for (int i = 0; i < f.getAttributeCount(); ++i) {
            Object value = f.getAttribute(i);
            this.write(i, value);
        }
    }

    public void writeFeatureID(String fid) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(fid);
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(position == 0 ? "=" : "|");
        if (attribute == null) {
            this.writer.write("<null>");
        } else if (attribute instanceof String) {
            String txt = (String)attribute;
            txt = txt.replace("\n", "\\n");
            txt = txt.replace("\r", "\\r");
            this.writer.write(txt);
        } else if (attribute instanceof Geometry) {
            Geometry geometry = (Geometry)attribute;
            this.wktWriter.write(geometry, (Writer)this.writer);
        } else {
            String txt = (String)Converters.convert((Object)attribute, String.class);
            if (txt == null) {
                txt = attribute.toString();
            }
            this.writer.write(txt);
        }
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        Object fid = null;
        try {
            if (this.hasNext()) {
                this.delegate.next();
                fid = this.delegate.fid;
                Object[] values = new Object[this.type.getAttributeCount()];
                for (int i = 0; i < this.type.getAttributeCount(); ++i) {
                    values[i] = this.delegate.read(i);
                }
                this.origional = SimpleFeatureBuilder.build(this.type, values, (String)fid);
                this.live = SimpleFeatureBuilder.copy(this.origional);
                return this.live;
            }
            fid = this.type.getTypeName() + "." + System.currentTimeMillis();
            Object[] values = DataUtilities.defaultValues(this.type);
            this.origional = null;
            this.live = SimpleFeatureBuilder.build(this.type, values, (String)fid);
            return this.live;
        }
        catch (IllegalAttributeException e) {
            String message = "Problem creating feature " + (String)(fid != null ? fid : "");
            throw new DataSourceException(message, e);
        }
    }

    @Override
    public void write() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to write");
        }
        if (this.live.equals(this.origional)) {
            this.writeImplementation(this.origional);
        } else {
            this.writeImplementation(this.live);
            if (this.origional != null) {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((Bounds)this.live.getBounds());
                bounds.include(this.origional.getBounds());
                this.state.fireFeatureUpdated(this.featureSource, (Feature)this.live, bounds);
            } else {
                this.state.fireFeatureAdded(this.featureSource, (Feature)this.live);
            }
        }
        this.origional = null;
        this.live = null;
    }

    @Override
    public void remove() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to remove");
        }
        if (this.origional != null) {
            this.state.fireFeatureRemoved(this.featureSource, (Feature)this.origional);
        }
        this.origional = null;
        this.live = null;
    }

    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("writer already closed");
        }
        while (this.delegate.hasNext()) {
            this.delegate.next();
            this.writer.newLine();
            this.writer.flush();
            this.echoLine(this.delegate.line);
        }
        this.writer.close();
        this.delegate.close();
        this.writer = null;
        this.delegate = null;
        this.read.delete();
        if (this.write.exists() && !this.write.renameTo(this.read)) {
            try (FileOutputStream outStream = new FileOutputStream(this.read);
                 FileInputStream inStream = new FileInputStream(this.write);
                 FileChannel out = outStream.getChannel();
                 FileChannel in = inStream.getChannel();){
                long len = in.size();
                long copied = out.transferFrom(in, 0L, in.size());
                if (len != copied) {
                    throw new IOException("unable to complete write");
                }
            }
        }
        this.read = null;
        this.write = null;
        this.store = null;
    }

    public void echoLine(String line) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        if (line == null) {
            return;
        }
        this.writer.write(line);
    }
}

