/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Vector;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.OpImage;
import org.eclipse.imagen.ROI;

public abstract class AttributeOpImage
extends OpImage {
    protected ROI roi;
    protected Rectangle srcBounds;

    public AttributeOpImage(RenderedImage source, ROI roi) {
        super(AttributeOpImage.wrapSource(source), new ImageLayout(source), null, false);
        this.roi = roi;
        this.srcBounds = this.getSourceImage(0).getBounds();
    }

    private static Vector wrapSource(RenderedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("Source image must not be null");
        }
        Vector<RenderedImage> v = new Vector<RenderedImage>();
        v.add(img);
        return v;
    }

    @Override
    public boolean computesUniqueTiles() {
        return false;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.getSourceImage(0).getTile(tileX, tileY);
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        return this.getTile(tileX, tileY);
    }

    @Override
    public Raster[] getTiles(Point[] tileIndices) {
        if (tileIndices == null) {
            throw new IllegalArgumentException("tileIndices must not be null");
        }
        return this.getSourceImage(0).getTiles(tileIndices);
    }

    @Override
    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        if (sourceRect == null) {
            throw new IllegalArgumentException("sourceRect must not be null");
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException("sourceIndex arg must be 0");
        }
        return new Rectangle(sourceRect);
    }

    @Override
    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException("destRect must not be null");
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException("sourceIndex arg must be 0");
        }
        return new Rectangle(destRect);
    }

    protected abstract Object getAttribute(String var1);

    protected Class<?> getAttributeClass(String name) {
        return Object.class;
    }

    protected abstract String[] getAttributeNames();

    private boolean isAttributeName(String name) {
        String[] attributeNames = this.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (!name.equalsIgnoreCase(attributeNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getProperty(String name) {
        if (this.isAttributeName(name)) {
            return this.getAttribute(name);
        }
        return super.getProperty(name);
    }

    @Override
    public Class getPropertyClass(String name) {
        if (this.isAttributeName(name)) {
            return this.getAttributeClass(name);
        }
        return super.getPropertyClass(name);
    }

    @Override
    public String[] getPropertyNames() {
        int i;
        String[] myNames;
        String[] superNames = super.getPropertyNames();
        if (superNames == null) {
            superNames = new String[]{};
        }
        if ((myNames = this.getAttributeNames()) == null) {
            myNames = new String[]{};
        }
        String[] names = new String[superNames.length + myNames.length];
        int k = 0;
        for (i = 0; i < superNames.length; ++i) {
            names[k++] = superNames[i];
        }
        for (i = 0; i < myNames.length; ++i) {
            names[k++] = myNames[i];
        }
        return names;
    }
}

