/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.ImageNI18N;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.util.ImageUtil;
import org.eclipse.imagen.util.ImagingListener;

public abstract class CRIFImpl
implements ContextualRenderedImageFactory {
    protected String operationName = null;

    public CRIFImpl() {
        this.operationName = null;
    }

    public CRIFImpl(String operationName) {
        this.operationName = operationName;
    }

    @Override
    public abstract RenderedImage create(ParameterBlock var1, RenderingHints var2);

    @Override
    public RenderedImage create(RenderContext renderContext, ParameterBlock paramBlock) {
        RenderingHints renderHints = renderContext.getRenderingHints();
        if (this.operationName != null) {
            PlanarImage rendering;
            OperationRegistry registry;
            OperationRegistry operationRegistry = registry = renderHints == null ? null : (OperationRegistry)renderHints.get(ImageN.KEY_OPERATION_REGISTRY);
            if (registry == null) {
                rendering = ImageN.create(this.operationName, paramBlock, renderHints);
            } else {
                OperationDescriptor odesc = (OperationDescriptor)registry.getDescriptor(OperationDescriptor.class, this.operationName);
                if (odesc == null) {
                    throw new IllegalArgumentException(this.operationName + ": " + ImageNI18N.getString("JAI0"));
                }
                if (!odesc.isModeSupported("rendered")) {
                    throw new IllegalArgumentException(this.operationName + ": " + ImageNI18N.getString("JAI1"));
                }
                if (!RenderedImage.class.isAssignableFrom(odesc.getDestClass("rendered"))) {
                    throw new IllegalArgumentException(this.operationName + ": " + ImageNI18N.getString("JAI2"));
                }
                StringBuffer msg = new StringBuffer();
                if (!odesc.validateArguments("rendered", paramBlock = (ParameterBlock)paramBlock.clone(), msg)) {
                    throw new IllegalArgumentException(msg.toString());
                }
                rendering = new RenderedOp(registry, this.operationName, paramBlock, renderHints);
            }
            if (rendering != null) {
                if (rendering instanceof RenderedOp) {
                    try {
                        rendering = rendering.getRendering();
                    }
                    catch (Exception e) {
                        ImagingListener listener = ImageUtil.getImagingListener(renderHints);
                        String message = ImageNI18N.getString("CRIFImpl0") + this.operationName;
                        listener.errorOccurred(message, e, this, false);
                    }
                }
                return rendering;
            }
        }
        return this.create(paramBlock, renderHints);
    }

    @Override
    public RenderContext mapRenderContext(int i, RenderContext renderContext, ParameterBlock paramBlock, RenderableImage image) {
        return renderContext;
    }

    @Override
    public Rectangle2D getBounds2D(ParameterBlock paramBlock) {
        Rectangle2D.Float box2;
        int numSources = paramBlock.getNumSources();
        if (numSources == 0) {
            return null;
        }
        RenderableImage src = paramBlock.getRenderableSource(0);
        Rectangle2D.Float box1 = new Rectangle2D.Float(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
        for (int i = 1; i < numSources && !(box1 = (Rectangle2D.Float)box1.createIntersection(box2 = new Rectangle2D.Float((src = paramBlock.getRenderableSource(i)).getMinX(), src.getMinY(), src.getWidth(), src.getHeight()))).isEmpty(); ++i) {
        }
        return box1;
    }

    @Override
    public Object getProperty(ParameterBlock paramBlock, String name) {
        return Image.UndefinedProperty;
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

