/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.imagen.DeferredData;
import org.eclipse.imagen.ImageNI18N;
import org.eclipse.imagen.PropertyChangeEmitter;
import org.eclipse.imagen.PropertySource;
import org.eclipse.imagen.PropertySourceChangeEvent;
import org.eclipse.imagen.RenderingChangeEvent;

public class DeferredProperty
extends DeferredData
implements PropertyChangeListener {
    protected transient PropertySource propertySource;
    protected String propertyName;

    public DeferredProperty(PropertySource propertySource, String propertyName, Class propertyClass) {
        super(propertyClass);
        if (propertySource == null || propertyName == null) {
            throw new IllegalArgumentException(ImageNI18N.getString("DeferredData0"));
        }
        String[] propertyNames = propertySource.getPropertyNames();
        boolean isPropertyEmitted = false;
        if (propertyNames != null) {
            int length = propertyNames.length;
            for (int i = 0; i < length; ++i) {
                if (!propertyName.equalsIgnoreCase(propertyNames[i])) continue;
                isPropertyEmitted = true;
                break;
            }
        }
        if (!isPropertyEmitted) {
            throw new IllegalArgumentException(ImageNI18N.getString("DeferredProperty0"));
        }
        if (propertySource instanceof PropertyChangeEmitter) {
            PropertyChangeEmitter pce = (PropertyChangeEmitter)((Object)propertySource);
            pce.addPropertyChangeListener(propertyName, this);
        }
        this.propertySource = propertySource;
        this.propertyName = propertyName;
    }

    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    protected Object computeData() {
        return this.propertySource.getProperty(this.propertyName);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DeferredProperty)) {
            return false;
        }
        DeferredProperty dp = (DeferredProperty)obj;
        return this.propertyName.equalsIgnoreCase(dp.getPropertyName()) && this.propertySource.equals(dp.getPropertySource()) && (!this.isValid() || !dp.isValid() || this.data.equals(dp.getData()));
    }

    public int hashCode() {
        return this.propertySource.hashCode() ^ this.propertyName.toLowerCase().hashCode();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.propertySource) {
            if (evt instanceof RenderingChangeEvent) {
                this.setData(null);
            } else if (evt instanceof PropertySourceChangeEvent && this.propertyName.equalsIgnoreCase(evt.getPropertyName())) {
                Object newValue = evt.getNewValue();
                this.setData(newValue == Image.UndefinedProperty ? null : newValue);
            }
        }
    }
}

