/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.color.ColorSpace;

public class NotAColorSpace
extends ColorSpace {
    public static final int UNKNOWN_TYPE = -1;

    private static int getType(int numComponents) {
        if (numComponents < 1) {
            throw new IllegalArgumentException("A color space must have at least one component.");
        }
        if (numComponents == 1) {
            return 6;
        }
        if (numComponents <= 15) {
            return numComponents + 10;
        }
        return -1;
    }

    public NotAColorSpace(int numComponents) {
        super(NotAColorSpace.getType(numComponents), numComponents);
    }

    private void validateArrayLength(float[] array, int requiredLength, String name) {
        if (array == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (array.length < requiredLength) {
            throw new ArrayIndexOutOfBoundsException(name + ".length < " + requiredLength);
        }
    }

    private float[] copyComponents(float[] src, float[] dst, int maxComponents) {
        int n = Math.min(maxComponents, Math.min(src.length, dst.length));
        for (int i = 0; i < n; ++i) {
            dst[i] = src[i];
        }
        return dst;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        this.validateArrayLength(colorvalue, this.getNumComponents(), "colorvalue");
        return this.copyComponents(colorvalue, new float[3], 3);
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        this.validateArrayLength(rgbvalue, 3, "rgbvalue");
        return this.copyComponents(rgbvalue, new float[this.getNumComponents()], 3);
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        this.validateArrayLength(colorvalue, this.getNumComponents(), "colorvalue");
        return this.copyComponents(colorvalue, new float[3], 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] xyzvalue) {
        this.validateArrayLength(xyzvalue, 3, "xyzvalue");
        return this.copyComponents(xyzvalue, new float[this.getNumComponents()], 3);
    }
}

