/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.imagen.ImageNI18N;
import org.eclipse.imagen.ParameterList;
import org.eclipse.imagen.ParameterListDescriptor;
import org.eclipse.imagen.media.util.CaselessStringArrayTable;

public class ParameterListImpl
implements ParameterList,
Serializable {
    private ParameterListDescriptor pld;
    private CaselessStringArrayTable paramIndices;
    private Object[] paramValues;
    private Class[] paramClasses;

    public ParameterListImpl(ParameterListDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(ImageNI18N.getString("Generic0"));
        }
        this.pld = descriptor;
        int numParams = this.pld.getNumParameters();
        if (numParams > 0) {
            Object[] paramDefaults = this.pld.getParamDefaults();
            this.paramClasses = this.pld.getParamClasses();
            this.paramIndices = new CaselessStringArrayTable(this.pld.getParamNames());
            this.paramValues = new Object[numParams];
            for (int i = 0; i < numParams; ++i) {
                this.paramValues[i] = paramDefaults[i];
            }
        } else {
            this.paramClasses = null;
            this.paramIndices = null;
            this.paramValues = null;
        }
    }

    @Override
    public ParameterListDescriptor getParameterListDescriptor() {
        return this.pld;
    }

    private ParameterList setParameter0(String paramName, Object obj) {
        int index = this.paramIndices.indexOf(paramName);
        if (obj != null && !this.paramClasses[index].isInstance(obj)) {
            throw new IllegalArgumentException(this.formatMsg(ImageNI18N.getString("ParameterListImpl0"), new Object[]{obj.getClass().getName(), this.paramClasses[index].getName(), paramName}));
        }
        if (!this.pld.isParameterValueValid(paramName, obj)) {
            throw new IllegalArgumentException(paramName + ":" + ImageNI18N.getString("ParameterListImpl1"));
        }
        this.paramValues[index] = obj;
        return this;
    }

    @Override
    public ParameterList setParameter(String paramName, byte b) {
        return this.setParameter0(paramName, new Byte(b));
    }

    @Override
    public ParameterList setParameter(String paramName, boolean b) {
        return this.setParameter0(paramName, new Boolean(b));
    }

    @Override
    public ParameterList setParameter(String paramName, char c) {
        return this.setParameter0(paramName, new Character(c));
    }

    @Override
    public ParameterList setParameter(String paramName, short s) {
        return this.setParameter0(paramName, new Short(s));
    }

    @Override
    public ParameterList setParameter(String paramName, int i) {
        return this.setParameter0(paramName, new Integer(i));
    }

    @Override
    public ParameterList setParameter(String paramName, long l) {
        return this.setParameter0(paramName, new Long(l));
    }

    @Override
    public ParameterList setParameter(String paramName, float f) {
        return this.setParameter0(paramName, new Float(f));
    }

    @Override
    public ParameterList setParameter(String paramName, double d) {
        return this.setParameter0(paramName, new Double(d));
    }

    @Override
    public ParameterList setParameter(String paramName, Object obj) {
        return this.setParameter0(paramName, obj);
    }

    private Object getObjectParameter0(String paramName) {
        Object obj = this.paramValues[this.paramIndices.indexOf(paramName)];
        if (obj == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
            throw new IllegalStateException(paramName + ":" + ImageNI18N.getString("ParameterListImpl2"));
        }
        return obj;
    }

    @Override
    public Object getObjectParameter(String paramName) {
        return this.getObjectParameter0(paramName);
    }

    @Override
    public byte getByteParameter(String paramName) {
        return (Byte)this.getObjectParameter0(paramName);
    }

    @Override
    public boolean getBooleanParameter(String paramName) {
        return (Boolean)this.getObjectParameter0(paramName);
    }

    @Override
    public char getCharParameter(String paramName) {
        return ((Character)this.getObjectParameter0(paramName)).charValue();
    }

    @Override
    public short getShortParameter(String paramName) {
        return (Short)this.getObjectParameter0(paramName);
    }

    @Override
    public int getIntParameter(String paramName) {
        return (Integer)this.getObjectParameter0(paramName);
    }

    @Override
    public long getLongParameter(String paramName) {
        return (Long)this.getObjectParameter0(paramName);
    }

    @Override
    public float getFloatParameter(String paramName) {
        return ((Float)this.getObjectParameter0(paramName)).floatValue();
    }

    @Override
    public double getDoubleParameter(String paramName) {
        return (Double)this.getObjectParameter0(paramName);
    }

    private String formatMsg(String key, Object[] args) {
        MessageFormat mf = new MessageFormat(key);
        mf.setLocale(Locale.getDefault());
        return mf.format(args);
    }
}

