/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.imagen.CollectionImage;
import org.eclipse.imagen.ImageNI18N;

public class RenderedImageList
extends CollectionImage
implements List,
RenderedImage,
Serializable {
    protected RenderedImageList() {
    }

    public RenderedImageList(List renderedImageList) {
        if (renderedImageList == null) {
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList0"));
        }
        if (renderedImageList.isEmpty()) {
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList1"));
        }
        Iterator iter = renderedImageList.iterator();
        this.imageCollection = new Vector();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof RenderedImage) {
                this.imageCollection.add(item);
                continue;
            }
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList2"));
        }
    }

    private List getList() {
        return (List)this.imageCollection;
    }

    public RenderedImage getPrimaryImage() {
        return (RenderedImage)this.getList().get(0);
    }

    @Override
    public int getMinX() {
        return ((RenderedImage)this.getList().get(0)).getMinX();
    }

    @Override
    public int getMinY() {
        return ((RenderedImage)this.getList().get(0)).getMinY();
    }

    @Override
    public int getWidth() {
        return ((RenderedImage)this.getList().get(0)).getWidth();
    }

    @Override
    public int getHeight() {
        return ((RenderedImage)this.getList().get(0)).getHeight();
    }

    @Override
    public int getTileWidth() {
        return ((RenderedImage)this.getList().get(0)).getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return ((RenderedImage)this.getList().get(0)).getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return ((RenderedImage)this.getList().get(0)).getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return ((RenderedImage)this.getList().get(0)).getTileGridYOffset();
    }

    @Override
    public int getMinTileX() {
        return ((RenderedImage)this.getList().get(0)).getMinTileX();
    }

    @Override
    public int getNumXTiles() {
        return ((RenderedImage)this.getList().get(0)).getNumXTiles();
    }

    @Override
    public int getMinTileY() {
        return ((RenderedImage)this.getList().get(0)).getMinTileY();
    }

    @Override
    public int getNumYTiles() {
        return ((RenderedImage)this.getList().get(0)).getNumYTiles();
    }

    @Override
    public SampleModel getSampleModel() {
        return ((RenderedImage)this.getList().get(0)).getSampleModel();
    }

    @Override
    public ColorModel getColorModel() {
        return ((RenderedImage)this.getList().get(0)).getColorModel();
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList0"));
        }
        return ((RenderedImage)this.getList().get(0)).getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return ((RenderedImage)this.getList().get(0)).getPropertyNames();
    }

    public Vector getSources() {
        return ((RenderedImage)this.getList().get(0)).getSources();
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return ((RenderedImage)this.getList().get(0)).getTile(tileX, tileY);
    }

    @Override
    public Raster getData() {
        return ((RenderedImage)this.getList().get(0)).getData();
    }

    @Override
    public Raster getData(Rectangle bounds) {
        return ((RenderedImage)this.getList().get(0)).getData(bounds);
    }

    @Override
    public WritableRaster copyData(WritableRaster dest) {
        return ((RenderedImage)this.getList().get(0)).copyData(dest);
    }

    public void add(int index, Object element) {
        if (element instanceof RenderedImage) {
            if (index < 0 || index > this.imageCollection.size()) {
                throw new IndexOutOfBoundsException(ImageNI18N.getString("RenderedImageList3"));
            }
        } else {
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList2"));
        }
        ((List)this.imageCollection).add(index, element);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.imageCollection.size()) {
            throw new IndexOutOfBoundsException(ImageNI18N.getString("RenderedImageList3"));
        }
        Vector temp = null;
        for (Object o : c) {
            if (!(o instanceof RenderedImage)) continue;
            if (temp == null) {
                temp = new Vector();
            }
            temp.add(o);
        }
        return ((List)this.imageCollection).addAll(index, temp);
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index >= this.imageCollection.size()) {
            throw new IndexOutOfBoundsException(ImageNI18N.getString("RenderedImageList3"));
        }
        return ((List)this.imageCollection).get(index);
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.imageCollection).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.imageCollection).lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return ((List)this.imageCollection).listIterator();
    }

    public ListIterator listIterator(int index) {
        return ((List)this.imageCollection).listIterator(index);
    }

    public Object remove(int index) {
        return ((List)this.imageCollection).remove(index);
    }

    public Object set(int index, Object element) {
        if (element instanceof RenderedImage) {
            return ((List)this.imageCollection).set(index, element);
        }
        throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList2"));
    }

    public List subList(int fromIndex, int toIndex) {
        return ((List)this.imageCollection).subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList0"));
        }
        if (o instanceof RenderedImage) {
            this.imageCollection.add(o);
            return true;
        }
        throw new IllegalArgumentException(ImageNI18N.getString("RenderedImageList2"));
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        boolean status = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof RenderedImage)) continue;
            this.imageCollection.add(o);
            status = true;
        }
        return status;
    }
}

