/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageNI18N;
import org.eclipse.imagen.OpImage;
import org.eclipse.imagen.PlanarImage;

public abstract class SourcelessOpImage
extends OpImage {
    private static ImageLayout layoutHelper(int minX, int minY, int width, int height, SampleModel sampleModel, ImageLayout il) {
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        layout.setMinX(minX);
        layout.setMinY(minY);
        layout.setWidth(width);
        layout.setHeight(height);
        layout.setSampleModel(sampleModel);
        if (!layout.isValid(16)) {
            layout.setTileGridXOffset(layout.getMinX(null));
        }
        if (!layout.isValid(32)) {
            layout.setTileGridYOffset(layout.getMinY(null));
        }
        return layout;
    }

    public SourcelessOpImage(ImageLayout layout, Map configuration, SampleModel sampleModel, int minX, int minY, int width, int height) {
        super(null, SourcelessOpImage.layoutHelper(minX, minY, width, height, sampleModel, layout), configuration, false);
    }

    @Override
    public boolean computesUniqueTiles() {
        return false;
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle destRect = rect.intersection(this.getBounds());
        this.computeRect((PlanarImage[])null, dest, destRect);
        return dest;
    }

    @Override
    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        throw new IllegalArgumentException(ImageNI18N.getString("SourcelessOpImage0"));
    }

    @Override
    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        throw new IllegalArgumentException(ImageNI18N.getString("SourcelessOpImage0"));
    }
}

