/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterator;

import java.awt.Rectangle;
import java.awt.image.DataBufferFloat;
import java.awt.image.RenderedImage;
import org.eclipse.imagen.media.iterator.RandomIterCSM;

public class RandomIterCSMFloat
extends RandomIterCSM {
    float[][] bankData;

    public RandomIterCSMFloat(RenderedImage im, Rectangle bounds) {
        super(im, bounds);
    }

    @Override
    protected final void dataBufferChanged() {
        this.bankData = ((DataBufferFloat)this.dataBuffer).getBankData();
    }

    @Override
    public final int getSample(int x, int y, int b) {
        this.makeCurrent(x - this.boundsX, y - this.boundsX);
        return (int)this.bankData[b][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b]];
    }

    @Override
    public final float getSampleFloat(int x, int y, int b) {
        this.makeCurrent(x - this.boundsX, y - this.boundsX);
        return this.bankData[b][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b]];
    }

    @Override
    public final double getSampleDouble(int x, int y, int b) {
        this.makeCurrent(x - this.boundsX, y - this.boundsX);
        return this.bankData[b][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b]];
    }

    @Override
    public float[] getPixel(int x, int y, float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int offset = (x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride;
        for (int b = 0; b < this.numBands; ++b) {
            fArray[b] = this.bankData[b][offset + this.bandOffsets[b]];
        }
        return fArray;
    }
}

