/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic;
import org.eclipse.imagen.InterpolationBicubic2;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.media.opimage.FilteredSubsampleOpImage;
import org.eclipse.imagen.media.opimage.JaiI18N;

public class FilteredSubsampleRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        boolean validInterp;
        RenderedImage source = paramBlock.getRenderedSource(0);
        BorderExtender extender = renderHints == null ? null : (BorderExtender)renderHints.get(ImageN.KEY_BORDER_EXTENDER);
        ImageLayout layout = renderHints == null ? null : (ImageLayout)renderHints.get(ImageN.KEY_IMAGE_LAYOUT);
        int scaleX = paramBlock.getIntParameter(0);
        int scaleY = paramBlock.getIntParameter(1);
        float[] qsFilter = (float[])paramBlock.getObjectParameter(2);
        Interpolation interp = (Interpolation)paramBlock.getObjectParameter(3);
        SampleModel sm = source.getSampleModel();
        int dataType = sm.getDataType();
        boolean bl = validInterp = interp instanceof InterpolationNearest || interp instanceof InterpolationBilinear || interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2;
        if (!validInterp) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample3"));
        }
        return new FilteredSubsampleOpImage(source, extender, renderHints, layout, scaleX, scaleY, qsFilter, interp);
    }
}

