/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.media.opimage.MaxFilterPlusOpImage;
import org.eclipse.imagen.media.opimage.MaxFilterSeparableOpImage;
import org.eclipse.imagen.media.opimage.MaxFilterSquareOpImage;
import org.eclipse.imagen.media.opimage.MaxFilterXOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.operator.MaxFilterDescriptor;
import org.eclipse.imagen.operator.MaxFilterShape;

public class MaxFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        MaxFilterShape maskType = (MaxFilterShape)paramBlock.getObjectParameter(0);
        int maskSize = paramBlock.getIntParameter(1);
        RenderedImage ri = paramBlock.getRenderedSource(0);
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_SQUARE)) {
            return new MaxFilterSquareOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_PLUS)) {
            return new MaxFilterPlusOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_X)) {
            return new MaxFilterXOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_SQUARE_SEPARABLE)) {
            return new MaxFilterSeparableOpImage(ri, extender, renderHints, layout, maskSize);
        }
        return null;
    }
}

