/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.media.opimage.MedianFilterPlusOpImage;
import org.eclipse.imagen.media.opimage.MedianFilterSeparableOpImage;
import org.eclipse.imagen.media.opimage.MedianFilterSquareOpImage;
import org.eclipse.imagen.media.opimage.MedianFilterXOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.operator.MedianFilterDescriptor;
import org.eclipse.imagen.operator.MedianFilterShape;

public class MedianFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        MedianFilterShape maskType = (MedianFilterShape)paramBlock.getObjectParameter(0);
        int maskSize = paramBlock.getIntParameter(1);
        RenderedImage ri = paramBlock.getRenderedSource(0);
        if (maskType.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE)) {
            return new MedianFilterSquareOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MedianFilterDescriptor.MEDIAN_MASK_PLUS)) {
            return new MedianFilterPlusOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MedianFilterDescriptor.MEDIAN_MASK_X)) {
            return new MedianFilterXOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE_SEPARABLE)) {
            return new MedianFilterSeparableOpImage(ri, extender, renderHints, layout, maskSize);
        }
        return null;
    }
}

