/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.media.opimage.MinFilterPlusOpImage;
import org.eclipse.imagen.media.opimage.MinFilterSeparableOpImage;
import org.eclipse.imagen.media.opimage.MinFilterSquareOpImage;
import org.eclipse.imagen.media.opimage.MinFilterXOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.operator.MinFilterDescriptor;
import org.eclipse.imagen.operator.MinFilterShape;

public class MinFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        MinFilterShape maskType = (MinFilterShape)paramBlock.getObjectParameter(0);
        int maskSize = paramBlock.getIntParameter(1);
        RenderedImage ri = paramBlock.getRenderedSource(0);
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_SQUARE)) {
            return new MinFilterSquareOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_PLUS)) {
            return new MinFilterPlusOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_X)) {
            return new MinFilterXOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_SQUARE_SEPARABLE)) {
            return new MinFilterSeparableOpImage(ri, extender, renderHints, layout, maskSize);
        }
        return null;
    }
}

