/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.serialize;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import org.eclipse.imagen.media.serialize.SerializableStateImpl;

public class HashSetState
extends SerializableStateImpl {
    public static Class[] getSupportedClasses() {
        return new Class[]{HashSet.class};
    }

    public HashSetState(Class c, Object o, RenderingHints h) {
        super(c, o, h);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashSet set = (HashSet)this.theObject;
        HashSet<Object> serializableSet = new HashSet<Object>();
        if (set != null && !set.isEmpty()) {
            for (Object object : set) {
                Object serializableObject = this.getSerializableForm(object);
                serializableSet.add(serializableObject);
            }
        }
        out.writeObject(serializableSet);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        HashSet serializableSet = (HashSet)in.readObject();
        HashSet<Object> set = new HashSet<Object>();
        if (serializableSet.isEmpty()) {
            this.theObject = set;
            return;
        }
        for (Object serializableObject : serializableSet) {
            Object object = this.getDeserializedFrom(serializableObject);
            set.add(object);
        }
        this.theObject = set;
    }
}

