/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.serialize;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.media.serialize.JaiI18N;
import org.eclipse.imagen.media.serialize.SerializableState;
import org.eclipse.imagen.media.serialize.Serializer;

public class InterfaceState
implements SerializableState {
    private transient Object theObject;
    private transient Serializer[] theSerializers;
    private transient RenderingHints hints;

    public InterfaceState(Object o, Serializer[] serializers, RenderingHints h) {
        if (o == null || serializers == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.theObject = o;
        this.theSerializers = serializers;
        this.hints = h == null ? null : (RenderingHints)h.clone();
    }

    @Override
    public Object getObject() {
        return this.theObject;
    }

    @Override
    public Class getObjectClass() {
        return this.theObject.getClass();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int numSerializers = this.theSerializers.length;
        out.writeInt(numSerializers);
        for (int i = 0; i < numSerializers; ++i) {
            Serializer s = this.theSerializers[i];
            out.writeObject(s.getSupportedClass());
            out.writeObject(s.getState(this.theObject, this.hints));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int numInterfaces = in.readInt();
        Class[] interfaces = new Class[numInterfaces];
        SerializableState[] implementations = new SerializableState[numInterfaces];
        for (int i = 0; i < numInterfaces; ++i) {
            interfaces[i] = (Class)in.readObject();
            implementations[i] = (SerializableState)in.readObject();
        }
        InterfaceHandler handler = new InterfaceHandler(interfaces, implementations);
        this.theObject = Proxy.newProxyInstance(ImageN.class.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    static class InterfaceHandler
    implements InvocationHandler {
        private Hashtable interfaceMap;

        public InterfaceHandler(Class[] interfaces, SerializableState[] implementations) {
            if (interfaces == null || implementations == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            if (interfaces.length != implementations.length) {
                throw new IllegalArgumentException(JaiI18N.getString("InterfaceHandler0"));
            }
            int numInterfaces = interfaces.length;
            this.interfaceMap = new Hashtable(numInterfaces);
            for (int i = 0; i < numInterfaces; ++i) {
                Class iface = interfaces[i];
                SerializableState state = implementations[i];
                if (!iface.isAssignableFrom(state.getObjectClass())) {
                    throw new RuntimeException(JaiI18N.getString("InterfaceHandler1"));
                }
                Object impl = state.getObject();
                this.interfaceMap.put(iface, impl);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            Class<?> key = method.getDeclaringClass();
            if (!this.interfaceMap.containsKey(key)) {
                Class[] classes = this.interfaceMap.keySet().toArray(new Class[0]);
                for (int i = 0; i < classes.length; ++i) {
                    Class aClass = classes[i];
                    if (!key.isAssignableFrom(aClass)) continue;
                    this.interfaceMap.put(key, this.interfaceMap.get(aClass));
                    break;
                }
                if (!this.interfaceMap.containsKey(key)) {
                    throw new RuntimeException(key.getName() + JaiI18N.getString("InterfaceHandler2"));
                }
            }
            Object result = null;
            try {
                Object impl = this.interfaceMap.get(key);
                result = method.invoke(impl, args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(method.getName() + JaiI18N.getString("InterfaceHandler3"));
            }
            return result;
        }
    }
}

