/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.operator;

import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.operator.JaiI18N;
import org.eclipse.imagen.util.Range;

public class ConstantDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Constant"}, {"LocalName", "Constant"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("ConstantDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ConstantDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ConstantDescriptor1")}, {"arg1Desc", JaiI18N.getString("ConstantDescriptor2")}, {"arg2Desc", JaiI18N.getString("ConstantDescriptor3")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Number[].class};
    private static final String[] paramNames = new String[]{"width", "height", "bandValues"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    private static final Object[] validParamValues = new Object[]{new Range(Float.class, new Float(0.0f), false, null, false), new Range(Float.class, new Float(0.0f), false, null, false), null};

    public ConstantDescriptor() {
        super(resources, supportedModes, 0, paramNames, paramClasses, paramDefaults, validParamValues);
    }

    @Override
    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateParameters(modeName, args, message)) {
            return false;
        }
        int length = ((Number[])args.getObjectParameter(2)).length;
        if (length < 1) {
            message.append(this.getName() + " " + JaiI18N.getString("ConstantDescriptor4"));
            return false;
        }
        if (modeName.equalsIgnoreCase("rendered")) {
            int width = Math.round(args.getFloatParameter(0));
            int height = Math.round(args.getFloatParameter(1));
            if (width < 1 || height < 1) {
                message.append(this.getName() + " " + JaiI18N.getString("ConstantDescriptor5"));
                return false;
            }
        } else if (modeName.equalsIgnoreCase("renderable")) {
            float width = args.getFloatParameter(0);
            float height = args.getFloatParameter(1);
            if (width <= 0.0f || height <= 0.0f) {
                message.append(this.getName() + " " + JaiI18N.getString("ConstantDescriptor6"));
                return false;
            }
        }
        return true;
    }

    public static RenderedOp create(Float width, Float height, Number[] bandValues, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Constant", "rendered");
        pb.setParameter("width", width);
        pb.setParameter("height", height);
        pb.setParameter("bandValues", bandValues);
        return ImageN.create("Constant", pb, hints);
    }

    public static RenderableOp createRenderable(Float width, Float height, Number[] bandValues, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Constant", "renderable");
        pb.setParameter("width", width);
        pb.setParameter("height", height);
        pb.setParameter("bandValues", bandValues);
        return ImageN.createRenderable("Constant", pb, hints);
    }
}

