/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic;
import org.eclipse.imagen.InterpolationBicubic2;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.operator.JaiI18N;

public class FilteredSubsampleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "FilteredSubsample"}, {"LocalName", "FilteredSubsample"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("FilteredSubsampleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FilteredSubsampleDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "The X subsample factor."}, {"arg1Desc", "The Y subsample factor."}, {"arg2Desc", "Symmetric filter coefficients."}, {"arg3Desc", "Interpolation object."}};
    private static final Class[] paramClasses = new Class[]{Integer.class, Integer.class, float[].class, Interpolation.class};
    private static final String[] paramNames = new String[]{"scaleX", "scaleY", "qsFilterArray", "interpolation"};
    private static final Object[] paramDefaults = new Object[]{new Integer(2), new Integer(2), null, Interpolation.getInstance(0)};
    private static final String[] supportedModes = new String[]{"rendered"};

    public FilteredSubsampleDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        Interpolation interp;
        if (!super.validateParameters(modeName, args, msg)) {
            return false;
        }
        int scaleX = args.getIntParameter(0);
        int scaleY = args.getIntParameter(1);
        if (scaleX < 1 || scaleY < 1) {
            msg.append(this.getName() + " " + JaiI18N.getString("FilteredSubsampleDescriptor1"));
            return false;
        }
        float[] filter = (float[])args.getObjectParameter(2);
        if (filter == null) {
            int i;
            int m;
            int n = m = scaleX > scaleY ? scaleX : scaleY;
            if ((m & 1) == 0) {
                ++m;
            }
            double sigma = (double)(m - 1) / 6.0;
            if (m == 1) {
                sigma = 1.0;
            }
            filter = new float[m / 2 + 1];
            float sum = 0.0f;
            for (i = 0; i < filter.length; ++i) {
                filter[i] = (float)this.gaussian(i, sigma);
                if (i == 0) {
                    sum += filter[i];
                    continue;
                }
                sum += filter[i] * 2.0f;
            }
            i = 0;
            while (i < filter.length) {
                int n2 = i++;
                filter[n2] = filter[n2] / sum;
            }
            args.set(filter, 2);
        }
        if (!((interp = (Interpolation)args.getObjectParameter(3)) instanceof InterpolationNearest || interp instanceof InterpolationBilinear || interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2)) {
            msg.append(this.getName() + " " + JaiI18N.getString("FilteredSubsampleDescriptor2"));
            return false;
        }
        return true;
    }

    private double gaussian(double x, double sigma) {
        return Math.exp(-x * x / (2.0 * sigma * sigma)) / sigma / Math.sqrt(Math.PI * 2);
    }

    public static RenderedOp create(RenderedImage source0, Integer scaleX, Integer scaleY, float[] qsFilterArray, Interpolation interpolation, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("FilteredSubsample", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("scaleX", scaleX);
        pb.setParameter("scaleY", scaleY);
        pb.setParameter("qsFilterArray", qsFilterArray);
        pb.setParameter("interpolation", interpolation);
        return ImageN.create("FilteredSubsample", pb, hints);
    }
}

