/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.KernelImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.operator.JaiI18N;

public class RenderableDescriptor
extends OperationDescriptorImpl {
    private static final float[] DEFAULT_KERNEL_1D = new float[]{0.05f, 0.25f, 0.4f, 0.25f, 0.05f};
    private static final String[][] resources = new String[][]{{"GlobalName", "Renderable"}, {"LocalName", "Renderable"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("RenderableDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/RenderableDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("RenderableDescriptor1")}, {"arg1Desc", JaiI18N.getString("RenderableDescriptor2")}, {"arg2Desc", JaiI18N.getString("RenderableDescriptor3")}, {"arg3Desc", JaiI18N.getString("RenderableDescriptor4")}, {"arg4Desc", JaiI18N.getString("RenderableDescriptor5")}};
    private static final Class[] paramClasses = new Class[]{RenderedOp.class, Integer.class, Float.class, Float.class, Float.class};
    private static final String[] paramNames = new String[]{"downSampler", "maxLowResDim", "minX", "minY", "height"};
    private static final Object[] paramDefaults = new Object[]{null, new Integer(64), new Float(0.0f), new Float(0.0f), new Float(1.0f)};

    public RenderableDescriptor() {
        super(resources, null, new Class[]{RenderedImage.class}, paramClasses, paramNames, paramDefaults);
    }

    @Override
    public boolean isRenderedSupported() {
        return false;
    }

    @Override
    public boolean isRenderableSupported() {
        return true;
    }

    @Override
    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (args.getNumParameters() == 0 || args.getObjectParameter(0) == null) {
            ParameterBlock pb = new ParameterBlock();
            KernelImageN kernel = new KernelImageN(DEFAULT_KERNEL_1D.length, DEFAULT_KERNEL_1D.length, DEFAULT_KERNEL_1D.length / 2, DEFAULT_KERNEL_1D.length / 2, DEFAULT_KERNEL_1D, DEFAULT_KERNEL_1D);
            pb.add(kernel);
            BorderExtender extender = BorderExtender.createInstance(1);
            RenderingHints hints = ImageN.getDefaultInstance().getRenderingHints();
            if (hints == null) {
                hints = new RenderingHints(ImageN.KEY_BORDER_EXTENDER, extender);
            } else {
                hints.put(ImageN.KEY_BORDER_EXTENDER, extender);
            }
            RenderedOp filter = new RenderedOp("convolve", pb, hints);
            pb = new ParameterBlock();
            pb.addSource(filter);
            pb.add(new Float(0.5f)).add(new Float(0.5f));
            pb.add(new Float(0.0f)).add(new Float(0.0f));
            pb.add(Interpolation.getInstance(0));
            RenderedOp downSampler = new RenderedOp("scale", pb, null);
            args.set(downSampler, 0);
        }
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        if (args.getIntParameter(1) <= 0) {
            msg.append(this.getName() + " " + JaiI18N.getString("RenderableDescriptor6"));
            return false;
        }
        if (args.getFloatParameter(4) <= 0.0f) {
            msg.append(this.getName() + " " + JaiI18N.getString("RenderableDescriptor7"));
            return false;
        }
        return true;
    }

    public static RenderableOp createRenderable(RenderedImage source0, RenderedOp downSampler, Integer maxLowResDim, Float minX, Float minY, Float height, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Renderable", "renderable");
        pb.setSource("source0", source0);
        pb.setParameter("downSampler", downSampler);
        pb.setParameter("maxLowResDim", maxLowResDim);
        pb.setParameter("minX", minX);
        pb.setParameter("minY", minY);
        pb.setParameter("height", height);
        return ImageN.createRenderable("Renderable", pb, hints);
    }
}

