/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.operator;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.GeometricOpImage;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.operator.JaiI18N;

class SubsampleAveragePropertyGenerator
implements PropertyGenerator {
    @Override
    public String[] getPropertyNames() {
        String[] properties = new String[]{"ROI"};
        return properties;
    }

    @Override
    public Class getClass(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAveragePropertyGenerator0"));
        }
        if (propertyName.equalsIgnoreCase("roi")) {
            return ROI.class;
        }
        return null;
    }

    @Override
    public boolean canGenerateProperties(Object opNode) {
        if (opNode == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAveragePropertyGenerator1"));
        }
        return opNode instanceof RenderedOp;
    }

    @Override
    public Object getProperty(String name, Object opNode) {
        if (name == null || opNode == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAveragePropertyGenerator2"));
        }
        if (!this.canGenerateProperties(opNode)) {
            throw new IllegalArgumentException(opNode.getClass().getName() + JaiI18N.getString("SubsampleAveragePropertyGenerator3"));
        }
        return opNode instanceof RenderedOp ? this.getProperty(name, (RenderedOp)opNode) : null;
    }

    @Override
    public Object getProperty(String name, RenderedOp op) {
        if (name == null || op == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAveragePropertyGenerator4"));
        }
        if (name.equals("roi")) {
            ParameterBlock pb = op.getParameterBlock();
            PlanarImage src = (PlanarImage)pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                return null;
            }
            ROI srcROI = (ROI)property;
            Rectangle srcBounds = null;
            PlanarImage dst = op.getRendering();
            if (dst instanceof GeometricOpImage && ((GeometricOpImage)dst).getBorderExtender() == null) {
                GeometricOpImage geomIm = (GeometricOpImage)dst;
                Interpolation interp = geomIm.getInterpolation();
                srcBounds = new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1);
            } else {
                srcBounds = src.getBounds();
            }
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect(new ROIShape(srcBounds));
            }
            double sx = pb.getDoubleParameter(0);
            double sy = pb.getDoubleParameter(1);
            AffineTransform transform = new AffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0);
            ROI dstROI = srcROI.transform(transform);
            Rectangle dstBounds = op.getBounds();
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect(new ROIShape(dstBounds));
            }
            return dstROI;
        }
        return null;
    }

    @Override
    public Object getProperty(String name, RenderableOp op) {
        if (name == null || op == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAveragePropertyGenerator2"));
        }
        return null;
    }
}

