/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.registry;

import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.CollectionImage;
import org.eclipse.imagen.CollectionOp;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.PropertySource;
import org.eclipse.imagen.RenderableCollectionImageFactory;
import org.eclipse.imagen.registry.JaiI18N;

public final class RCIFRegistry {
    private static final String MODE_NAME = "renderableCollection";

    public static void register(OperationRegistry registry, String operationName, RenderableCollectionImageFactory rcif) {
        registry = registry != null ? registry : ImageN.getDefaultInstance().getOperationRegistry();
        registry.registerFactory(MODE_NAME, operationName, null, rcif);
    }

    public static void unregister(OperationRegistry registry, String operationName, RenderableCollectionImageFactory rcif) {
        registry = registry != null ? registry : ImageN.getDefaultInstance().getOperationRegistry();
        registry.unregisterFactory(MODE_NAME, operationName, null, rcif);
    }

    public static RenderableCollectionImageFactory get(OperationRegistry registry, String operationName) {
        registry = registry != null ? registry : ImageN.getDefaultInstance().getOperationRegistry();
        return (RenderableCollectionImageFactory)registry.getFactory(MODE_NAME, operationName);
    }

    public static CollectionImage create(OperationRegistry registry, String operationName, ParameterBlock paramBlock) {
        registry = registry != null ? registry : ImageN.getDefaultInstance().getOperationRegistry();
        Object[] args = new Object[]{paramBlock};
        return (CollectionImage)registry.invokeFactory(MODE_NAME, operationName, args);
    }

    public static PropertySource getPropertySource(CollectionOp op) {
        if (op == null) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("Generic0"));
        }
        if (!op.isRenderable()) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("CIFRegistry1"));
        }
        return op.getRegistry().getPropertySource(op);
    }
}

