/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.DataColumn;
import org.geotools.geopkg.DataColumnConstraint;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.GeoPkgFilterToSQL;
import org.geotools.geopkg.GeoPkgSchemaExtension;
import org.geotools.geopkg.JSONArrayIO;
import org.geotools.geopkg.geom.GeoPkgGeomReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.EnumMapping;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoPkgDialect
extends PreparedStatementSQLDialect {
    static final String HAS_SPATIAL_INDEX = "hasGeopkgSpatialIndex";
    static final String DATA_COLUMN = "gpkg.dataColumn";
    static final String ENUM = "gpkg.enumeration";
    private static final Object GPKG_ARRAY_ENUM_MAP = "gpkg.arrayEnumMapping";
    protected GeoPkgGeomWriter.Configuration geomWriterConfig;
    protected boolean contentsOnly = true;
    private JSONArrayIO jsonArrayIO = new JSONArrayIO();

    public GeoPkgDialect(JDBCDataStore dataStore, GeoPkgGeomWriter.Configuration writerConfig) {
        super(dataStore);
        this.geomWriterConfig = writerConfig;
    }

    public GeoPkgDialect(JDBCDataStore dataStore) {
        super(dataStore);
        this.geomWriterConfig = new GeoPkgGeomWriter.Configuration();
    }

    public void initializeConnection(Connection cx) throws SQLException {
        GeoPackage.init(cx);
    }

    public void setContentsOnly(boolean contentsOnly) {
        this.contentsOnly = contentsOnly;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (!this.contentsOnly) {
            return true;
        }
        Statement st = cx.createStatement();
        try {
            boolean bl;
            block10: {
                ResultSet rs = st.executeQuery(String.format("SELECT * FROM gpkg_contents WHERE table_name = '%s' AND data_type = '%s'", tableName, Entry.DataType.Feature.value()));
                try {
                    bl = rs.next();
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        super.encodePrimaryKey(column, sql);
        sql.append(" AUTOINCREMENT");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.encodeColumnName(null, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry g = this.geometry(rs.getBytes(column));
        return g != null ? g.getEnvelopeInternal() : null;
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.geometry(descriptor.getType().getBinding(), rs.getBytes(column), factory, hints);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.geometry(descriptor.getType().getBinding(), rs.getBytes(column), factory, hints);
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null || g.isEmpty()) {
            ps.setNull(column, 2004);
        } else {
            g.setSRID(srid);
            try {
                ps.setBytes(column, new GeoPkgGeomWriter(dimension, this.geomWriterConfig).write(g));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Geometry geometry(Class geometryType, byte[] bytes, GeometryFactory factory, Hints hints) throws IOException {
        GeoPkgGeomReader geoPkgGeomReader = new GeoPkgGeomReader(bytes);
        geoPkgGeomReader.setFactory(factory);
        geoPkgGeomReader.setHints(hints);
        geoPkgGeomReader.setGeometryType(geometryType);
        return bytes != null ? geoPkgGeomReader.get() : null;
    }

    Geometry geometry(byte[] b) throws IOException {
        return this.geometry(null, b, null, null);
    }

    public String getGeometryTypeName(Integer type) {
        return Geometries.getForSQLType((int)type).getName();
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("FLOAT", Double.class);
        mappings.put("DOUBLE", Double.class);
        mappings.put("REAL", Double.class);
        mappings.put("BOOLEAN", Boolean.class);
        mappings.put("DATE", Date.class);
        mappings.put("TIMESTAMP", Timestamp.class);
        mappings.put("TIME", Time.class);
        mappings.put("DATETIME", Timestamp.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        for (Geometries g : Geometries.values()) {
            mappings.put(g.getBinding(), g.getSQLType());
        }
        mappings.put(Byte.class, -6);
        mappings.put(Short.class, 5);
        mappings.put(Long.class, -5);
        mappings.put(Integer.class, 4);
        mappings.put(Float.class, 6);
        mappings.put(Double.class, 8);
        mappings.put(UUID.class, 12);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(2005, "TEXT");
        overrides.put(16, "BOOLEAN");
        overrides.put(-6, "TINYINT");
        overrides.put(5, "SMALLINT");
        overrides.put(4, "MEDIUMINT");
        overrides.put(-5, "INTEGER");
        overrides.put(6, "FLOAT");
        overrides.put(8, "DOUBLE");
        overrides.put(2, "NUMERIC");
        overrides.put(91, "DATE");
        overrides.put(92, "DATETIME");
        overrides.put(93, "DATETIME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columns, Connection cx) throws SQLException {
        String tbl = columns.getString("TABLE_NAME");
        String col = columns.getString("COLUMN_NAME");
        String typeName = columns.getString("TYPE_NAME");
        String sql = String.format("SELECT b.geometry_type_name FROM %s a, %s b WHERE a.table_name = b.table_name AND b.table_name = ? AND b.column_name = ?", "gpkg_contents", "gpkg_geometry_columns");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("%s; 1=%s, 2=%s".formatted(sql, tbl, col));
        }
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, tbl);
            ps.setString(2, col);
            ResultSet rs = ps.executeQuery();
            try {
                String t;
                Geometries g;
                if (rs.next() && (g = Geometries.getForName((String)(t = rs.getString(1)))) != null) {
                    Class clazz = g.getBinding();
                    return clazz;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        GeoPackage geoPackage = this.geopkg();
        try {
            GeoPkgSchemaExtension extension = geoPackage.getExtension(GeoPkgSchemaExtension.class);
            List<DataColumn> dataColumns = extension.getDataColumns(tbl, cx);
            for (DataColumn dataColumn : dataColumns) {
                if (!col.equals(dataColumn.getColumnName())) continue;
                DataColumnConstraint constraint = dataColumn.getConstraint();
                if ("application/json".equals(dataColumn.getMimeType())) {
                    return String[].class;
                }
                if (!(constraint instanceof DataColumnConstraint.Enum)) continue;
                return String.class;
            }
        }
        catch (IOException e) {
            this.throwSQLException(e);
        }
        if ("TINYINT".equals(typeName)) {
            return Byte.class;
        }
        if ("SMALLINT".equals(typeName)) {
            return Short.class;
        }
        if ("MEDIUMINT".equals(typeName)) {
            return Integer.class;
        }
        if ("INT".equals(typeName) || "INTEGER".equals(typeName)) {
            return Long.class;
        }
        if ("POINT".equalsIgnoreCase(typeName)) {
            return Point.class;
        }
        if ("MULTIPOINT".equalsIgnoreCase(typeName)) {
            return MultiPoint.class;
        }
        if ("LINESTRING".equalsIgnoreCase(typeName)) {
            return LineString.class;
        }
        if ("MULTILINESTRING".equalsIgnoreCase(typeName)) {
            return MultiLineString.class;
        }
        if ("POLYGON".equalsIgnoreCase(typeName)) {
            return Polygon.class;
        }
        if ("MULTIPOLYGON".equalsIgnoreCase(typeName)) {
            return MultiPolygon.class;
        }
        if ("GEOMETRY".equalsIgnoreCase(typeName)) {
            return Geometry.class;
        }
        if ("GEOMETRYCOLLECTION".equalsIgnoreCase(typeName)) {
            return GeometryCollection.class;
        }
        return null;
    }

    public Filter getRestrictions(ResultSet columns, Connection cx) throws SQLException {
        String tbl = columns.getString("TABLE_NAME");
        String col = columns.getString("COLUMN_NAME");
        GeoPackage geoPackage = this.geopkg();
        try {
            GeoPkgSchemaExtension schemas = geoPackage.getExtension(GeoPkgSchemaExtension.class);
            List<DataColumn> dataColumns = schemas.getDataColumns(tbl, cx);
            for (DataColumn dataColumn : dataColumns) {
                DataColumnConstraint constraint;
                if (!col.equals(dataColumn.getColumnName()) || !((constraint = dataColumn.getConstraint()) instanceof DataColumnConstraint.Enum)) continue;
                DataColumnConstraint.Enum ec = (DataColumnConstraint.Enum)constraint;
                return FeatureTypes.createFieldOptions(ec.getValues().values());
            }
        }
        catch (IOException e) {
            this.throwSQLException(e);
        }
        return null;
    }

    private void throwSQLException(IOException e) throws SQLException {
        if (e.getCause() instanceof SQLException) {
            throw (SQLException)e.getCause();
        }
        throw new SQLException(e);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        CoordinateReferenceSystem crs;
        GeometryDescriptor gd;
        Object skipRegistration = featureType.getUserData().get("skip_registration");
        if (Boolean.TRUE.equals(skipRegistration)) {
            return;
        }
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
            fe.setLastChange(new java.util.Date());
        }
        if ((gd = featureType.getGeometryDescriptor()) != null) {
            fe.setGeometryColumn(gd.getLocalName());
            Class binding = gd.getType().getBinding();
            fe.setGeometryType(Geometries.getForBinding((Class)binding));
        }
        if ((crs = featureType.getCoordinateReferenceSystem()) != null) {
            if (DefaultEngineeringCRS.GENERIC_2D == crs) {
                fe.setSrid(-1);
            } else {
                int srid = GeoPkgDialect.getSRIDFromDescriptor(cx, featureType.getGeometryDescriptor());
                if (srid > 0) {
                    fe.setSrid(srid);
                }
            }
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.addGeoPackageContentsEntry(fe, cx);
            geopkg.addGeometryColumnsEntry(fe, cx);
            for (PropertyDescriptor descr : featureType.getDescriptors()) {
                GeometryDescriptor gd1;
                if (!(descr instanceof GeometryDescriptor) || (gd1 = (GeometryDescriptor)descr).getLocalName().equals(fe.getGeometryColumn())) continue;
                FeatureEntry fe1 = new FeatureEntry();
                fe1.init(fe);
                fe1.setGeometryColumn(gd1.getLocalName());
                Class binding = gd1.getType().getBinding();
                fe1.setGeometryType(Geometries.getForBinding((Class)binding));
                geopkg.addGeometryColumnsEntry(fe1, cx);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            DataColumn dc = (DataColumn)ad.getUserData().get("gpgk_constraint");
            if (dc != null) {
                if (!ad.getLocalName().equals(dc.getColumnName())) {
                    throw new IllegalArgumentException("Expected column name " + ad.getLocalName() + " but got" + dc.getColumnName());
                }
                geopkg.getExtension(GeoPkgSchemaExtension.class).addDataColumn(featureType.getTypeName(), dc, cx);
                continue;
            }
            List options = FeatureTypes.getFieldOptions((PropertyDescriptor)ad);
            if (options != null && !options.isEmpty()) {
                dc = new DataColumn();
                dc.setColumnName(ad.getLocalName());
                dc.setName(featureType.getTypeName() + ":" + ad.getLocalName());
                if (ad.getType().getBinding().isArray()) {
                    dc.setMimeType("application/json");
                }
                LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
                for (int i = 0; i < options.size(); ++i) {
                    optionsMap.put(String.valueOf(i), String.valueOf(options.get(i)));
                }
                String constraintName = featureType.getTypeName() + "_" + ad.getLocalName() + "_enum";
                DataColumnConstraint.Enum dcc = new DataColumnConstraint.Enum(constraintName, optionsMap);
                dc.setConstraint(dcc);
                geopkg.getExtension(GeoPkgSchemaExtension.class).addDataColumn(featureType.getTypeName(), dc, cx);
                continue;
            }
            if (!ad.getType().getBinding().isArray()) continue;
            dc = new DataColumn();
            dc.setColumnName(ad.getLocalName());
            dc.setName(featureType.getTypeName() + "_" + ad.getLocalName());
            dc.setMimeType("application/json");
            geopkg.getExtension(GeoPkgSchemaExtension.class).addDataColumn(featureType.getTypeName(), dc, cx);
        }
    }

    private static int getSRIDFromDescriptor(Connection cx, GeometryDescriptor gd) {
        CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
        if (gd.getUserData().get("nativeSRID") != null) {
            return (Integer)gd.getUserData().get("nativeSRID");
        }
        if (crs != null) {
            return GeoPackage.findSRID(cx, crs);
        }
        return -1;
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        super.postDropTable(schemaName, featureType, cx);
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.deleteGeoPackageContentsEntry(fe);
            geopkg.deleteGeometryColumnsEntry(fe);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName, cx);
            return fe != null ? fe.getSrid() : null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName, cx);
            if (fe != null) {
                return 2 + (fe.isZ() ? 1 : 0) + (fe.isM() ? 1 : 0);
            }
            return super.getGeometryDimension(schemaName, tableName, columnName, cx);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return GeoPackage.decodeCRS(cx, srid);
        }
        catch (Exception e) {
            block8: {
                LOGGER.log(Level.FINE, "Unable to create CRS from epsg code " + srid, e);
                String sql = "SELECT definition FROM %s WHERE organization_coordsys_id = %d".formatted("gpkg_spatial_ref_sys", srid);
                LOGGER.fine(sql);
                Statement st = cx.createStatement();
                ResultSet rs = st.executeQuery(sql);
                try {
                    if (!rs.next()) break block8;
                    String wkt = rs.getString(1);
                    try {
                        CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)wkt);
                        return coordinateReferenceSystem;
                    }
                    catch (Exception e2) {
                        LOGGER.log(Level.FINE, "Unable to create CRS from wkt: " + wkt, e2);
                    }
                }
                finally {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe(st);
                }
            }
            return super.createCRS(srid, cx);
        }
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.dataStore.getBatchInsertSize() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery("SELECT last_insert_rowid()");
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    GeoPackage geopkg() {
        return new GeoPackage(this.dataStore);
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT -1");
            sql.append(" OFFSET " + offset);
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        GeoPkgFilterToSQL fts = new GeoPkgFilterToSQL(this);
        return fts;
    }

    public void setValue(Object value, Class<?> binding, AttributeDescriptor att, PreparedStatement ps, int column, Connection cx) throws SQLException {
        Integer sqlType = this.dataStore.getMapping(binding, null);
        if (value == null) {
            ps.setNull(column, sqlType);
            return;
        }
        switch (sqlType) {
            case 91: {
                ps.setString(column, value.toString());
                break;
            }
            case 92: {
                String time = value.toString();
                ps.setString(column, time);
                break;
            }
            case 93: {
                String v = ((Timestamp)value).toInstant().toString();
                ps.setString(column, v);
                break;
            }
            default: {
                super.setValue(value, binding, null, ps, column, cx);
            }
        }
    }

    public void setArrayValue(Object value, AttributeDescriptor att, PreparedStatement ps, int columnIdx, Connection cx) throws SQLException {
        Class binding = att.getType().getBinding();
        if (value == null) {
            Integer sqlType = this.dataStore.getMapping(binding);
            ps.setNull(columnIdx, sqlType);
            return;
        }
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Cannot handle this array value: " + String.valueOf(value));
        }
        this.writeArray(value, ps, columnIdx, (EnumMapping)att.getUserData().get(GPKG_ARRAY_ENUM_MAP));
    }

    private void writeArray(Object value, PreparedStatement ps, int columnIdx, EnumMapping mapping) throws SQLException {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(value, i);
            if (mapping != null && item instanceof String) {
                String string = (String)item;
                sb.append(mapping.fromValue(string));
            } else if (item instanceof Number) {
                sb.append(item);
            } else {
                sb.append("\"").append(item).append("\"");
            }
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        ps.setString(columnIdx, sb.toString());
    }

    public boolean isArray(AttributeDescriptor att) {
        Object dataColumnMaybe = att.getUserData().get(DATA_COLUMN);
        if (dataColumnMaybe instanceof DataColumn) {
            DataColumn dc = (DataColumn)dataColumnMaybe;
            String mime = dc.getMimeType();
            return "application/json".equals(mime) || "text/json".equals(mime);
        }
        return false;
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        sql.append(sqlTypeName.toUpperCase());
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
        super.postCreateAttribute(att, tableName, schemaName, cx);
        String attributeName = att.getLocalName();
        if (att instanceof GeometryDescriptor) {
            String sql = "SELECT * FROM gpkg_extensions WHERE (lower(table_name)=lower('" + tableName + "') AND lower(column_name)=lower('" + attributeName + "') AND extension_name='gpkg_rtree_index')";
            try (Statement st = cx.createStatement();
                 ResultSet rs = st.executeQuery(sql);){
                boolean hasSpatialIndex = rs.next();
                att.getUserData().put(HAS_SPATIAL_INDEX, hasSpatialIndex);
            }
        }
        try {
            List<DataColumn> dataColumns = this.geopkg().getExtension(GeoPkgSchemaExtension.class).getDataColumns(tableName, cx);
            for (DataColumn dataColumn : dataColumns) {
                if (!attributeName.equals(dataColumn.getColumnName())) continue;
                if (dataColumn.getConstraint() instanceof DataColumnConstraint.Enum) {
                    DataColumnConstraint.Enum dcc = (DataColumnConstraint.Enum)dataColumn.getConstraint();
                    EnumMapping mapping = new EnumMapping();
                    for (Map.Entry<String, String> entry : dcc.getValues().entrySet()) {
                        mapping.addMapping(entry.getKey(), entry.getValue());
                    }
                    if (dataColumn.getMimeType() == null) {
                        att.getUserData().put("org.geotools.jdbc.enumMap", mapping);
                    } else {
                        att.getUserData().put(GPKG_ARRAY_ENUM_MAP, mapping);
                    }
                }
                att.getUserData().put(DATA_COLUMN, dataColumn);
            }
        }
        catch (IOException e) {
            this.throwSQLException(e);
        }
    }

    public Filter[] splitFilter(Filter filter, SimpleFeatureType schema) {
        Envelope envelope;
        GeometryDescriptor searchAttribute = this.simpleSpatialSearch(filter, schema);
        if (!(searchAttribute == null || (envelope = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null)) == null || envelope.isNull() || Double.isInfinite(envelope.getWidth()) || Double.isInfinite(envelope.getHeight()))) {
            Filter[] split = super.splitFilter(filter, schema);
            FilterFactory ff = this.dataStore.getFilterFactory();
            BBOX bbox = ff.bbox(searchAttribute.getLocalName(), envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), null);
            split[0] = Filter.INCLUDE.equals(split[0]) ? bbox : ff.and(split[0], (Filter)bbox);
            return split;
        }
        return super.splitFilter(filter, schema);
    }

    private GeometryDescriptor simpleSpatialSearch(Filter filter, SimpleFeatureType schema) {
        FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)attributeExtractor, null);
        Set attributes = attributeExtractor.getAttributeNameSet();
        GeometryDescriptor geometryAttribute = null;
        for (String name : attributes) {
            Object ad = "".equals(name) ? schema.getGeometryDescriptor() : schema.getDescriptor(name);
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor descriptor = ad;
            if (geometryAttribute != null && !geometryAttribute.equals(ad)) {
                return null;
            }
            geometryAttribute = descriptor;
        }
        return geometryAttribute;
    }

    protected PrimaryKey getPrimaryKey(String typeName) throws IOException {
        return super.getPrimaryKey(typeName);
    }

    protected <T> T convert(Object value, Class<T> binding) {
        if (Integer.class.equals(binding) && value instanceof Boolean) {
            return binding.cast(Boolean.TRUE.equals(value) ? 1 : 0);
        }
        return (T)super.convert(value, binding);
    }

    public String getPkColumnValue(ResultSet rs, PrimaryKeyColumn pkey, int columnIdx) throws SQLException {
        if (Integer.class.equals((Object)pkey.getType())) {
            return String.valueOf(rs.getInt(columnIdx));
        }
        return rs.getString(columnIdx);
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        hints.add(Hints.GEOMETRY_DISTANCE);
        hints.add(Hints.SCREENMAP);
    }

    public Function<Object, Object> getAggregateConverter(FeatureVisitor visitor, SimpleFeatureType featureType) {
        Class targetType;
        List resultTypes;
        Optional maybeResultTypes = this.getResultTypes(visitor, featureType);
        if (maybeResultTypes.isPresent() && (resultTypes = (List)maybeResultTypes.get()).size() == 1 && java.util.Date.class.isAssignableFrom(targetType = (Class)resultTypes.get(0))) {
            return v -> {
                Object converted = Converters.convert((Object)v, (Class)targetType);
                if (converted == null) {
                    LOGGER.log(Level.WARNING, "Could not convert " + String.valueOf(v) + " to the desired return type " + String.valueOf(targetType));
                    return v;
                }
                return converted;
            };
        }
        return Function.identity();
    }

    public Integer getSQLType(AttributeDescriptor ad) {
        if (FeatureTypes.getFieldOptions((PropertyDescriptor)ad) != null) {
            return 4;
        }
        if (ad.getType().getBinding().isArray()) {
            return 12;
        }
        return null;
    }

    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ReferencedEnvelope bounds;
        FeatureEntry entry = this.geopkg().feature(featureType.getTypeName(), cx);
        if (!(entry == null || entry.getBounds() == null || (bounds = entry.getBounds()).isEmpty() || bounds.isNull() || bounds.getMinX() == 0.0 && bounds.getMinY() == 0.0 && bounds.getMaxX() == 0.0 && bounds.getMaxY() == 0.0)) {
            return Arrays.asList(entry.getBounds());
        }
        return null;
    }

    public Object convertValue(Object value, AttributeDescriptor ad) {
        if (this.isArray(ad)) {
            return this.jsonArrayIO.parse((String)value, ad.getType().getBinding().getComponentType(), (EnumMapping)ad.getUserData().get(GPKG_ARRAY_ENUM_MAP));
        }
        if (ad.getType().getBinding() == Timestamp.class) {
            if (value == null) {
                return null;
            }
            Object strValue = (String)value;
            if (!((String)strValue).endsWith("Z")) {
                strValue = (String)strValue + "Z";
            }
            try {
                Instant instant = Instant.parse((CharSequence)strValue);
                Timestamp timestamp = Timestamp.from(instant);
                return timestamp;
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    java.util.Date date = dateFormat.parse((String)strValue);
                    Instant dateInstant = date.toInstant();
                    Timestamp timestamp = Timestamp.from(dateInstant);
                    return timestamp;
                }
                catch (ParseException ex) {
                    return super.convertValue(value, ad);
                }
            }
        }
        return super.convertValue(value, ad);
    }

    public boolean canGroupOnGeometry() {
        return true;
    }
}

