/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geotools.geopkg.GeoPackage;

public class GeoPkgExtension {
    protected final String name;
    protected final String definition;
    protected final Scope scope;
    protected final GeoPackage geoPackage;

    protected GeoPkgExtension(String name, String definition, Scope scope, GeoPackage geoPackage) {
        this.name = name;
        this.definition = definition;
        this.scope = scope;
        this.geoPackage = geoPackage;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isRegistered() throws IOException {
        boolean bl;
        block8: {
            Connection cx = this.getConnection();
            try {
                bl = this.isRegistered(cx);
                if (cx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            cx.close();
        }
        return bl;
    }

    protected boolean isRegistered(Connection cx) throws SQLException {
        String sql = String.format("SELECT *  FROM %s WHERE extension_name = ? LIMIT 1", "gpkg_extensions");
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            boolean bl;
            block12: {
                ps.setString(1, this.name);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Association> getAssociations() throws IOException {
        try (Connection cx = this.getConnection();){
            ArrayList<Association> arrayList;
            block22: {
                String sql = String.format("SELECT table_name, column_name  FROM %s WHERE extension_name = ?", "gpkg_extensions");
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setString(1, this.name);
                    ArrayList<Association> result = new ArrayList<Association>();
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            String tableName = rs.getString(1);
                            String columnName = rs.getString(2);
                            result.add(new Association(tableName, columnName));
                        }
                    }
                    arrayList = result;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.geoPackage.getDataSource().getConnection();
    }

    protected long getGeneratedKey(PreparedStatement ps) throws SQLException {
        try (ResultSet keys = ps.getGeneratedKeys();){
            if (keys.next()) {
                long l = keys.getLong(1);
                return l;
            }
            throw new SQLException("Coult not find a generated key!");
        }
    }

    public static enum Scope {
        ReadWrite("read-write"),
        WriteOnly("write-only");

        String sqlValue;

        private Scope(String sqlValue) {
            this.sqlValue = sqlValue;
        }

        public String getSqlValue() {
            return this.sqlValue;
        }
    }

    public static class Association {
        String tableName;
        String columnName;

        public Association(String tableName) {
            this.tableName = tableName;
        }

        public Association(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Association that = (Association)o;
            return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columnName, that.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }
    }
}

