/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.geopkg.mosaic.GeoPackageReader;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class GeoPackageFormat
extends AbstractGridFormat {
    private static final Logger LOGGER = Logging.getLogger(GeoPackageFormat.class);

    public static File getFileFromSource(Object source) {
        if (source == null) {
            return null;
        }
        File sourceFile = null;
        try {
            if (source instanceof File) {
                File file;
                sourceFile = file = (File)source;
            } else if (source instanceof URL) {
                URL rL = (URL)source;
                if (rL.getProtocol().equals("file")) {
                    sourceFile = URLs.urlToFile((URL)rL);
                }
            } else if (source instanceof String) {
                String string = (String)source;
                sourceFile = new File(string);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return sourceFile;
    }

    @Override
    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    @Override
    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new GeoPackageReader(source, hints);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public GridCoverageWriter getWriter(Object destination) {
        return this.getWriter(destination, null);
    }

    @Override
    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method: Geopackage format is read-only.");
    }

    @Override
    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            return false;
        }
        File sourceFile = GeoPackageFormat.getFileFromSource(source);
        if (sourceFile == null) {
            return false;
        }
        return sourceFile.getName().endsWith(".gpkg");
    }

    @Override
    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GeoPackageFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "GeoPackage (mosaic)");
        info.put("description", "GeoPackage mosaic plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = null;
    }
}

