/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.wps;

import java.awt.Color;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.geopkg.TileMatrix;
import org.locationtech.jts.geom.Envelope;

public class GeoPackageProcessRequest {
    protected String name;
    protected List<Layer> layers = new ArrayList<Layer>();
    protected URL path = null;
    protected boolean remove = true;
    protected boolean context = true;

    public Boolean getRemove() {
        return this.remove;
    }

    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public Layer getLayer(int i) {
        return this.layers.get(i);
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URL getPath() {
        return this.path;
    }

    public void setPath(URL path) {
        this.path = path;
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }

    public static abstract class Layer {
        protected String name = null;
        protected String identifier = null;
        protected String description = null;
        protected URI srs = null;
        protected Envelope bbox = null;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public URI getSrs() {
            return this.srs;
        }

        public void setSrs(URI srs) {
            this.srs = srs;
        }

        public Envelope getBbox() {
            return this.bbox;
        }

        public void setBbox(Envelope bbox) {
            this.bbox = bbox;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public abstract LayerType getType();
    }

    public static class TilesLayer
    extends Layer {
        protected List<QName> layers = null;
        protected String format = null;
        protected Color bgColor = null;
        protected boolean transparent = false;
        protected List<String> styles = null;
        protected URI sld = null;
        protected String sldBody = null;
        protected String gridSetName = null;
        protected List<TileMatrix> grids = null;
        protected TilesCoverage coverage = null;
        protected List<Parameter> parameters;

        @Override
        public LayerType getType() {
            return LayerType.TILES;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public boolean isTransparent() {
            return this.transparent;
        }

        public void setTransparent(boolean transparent) {
            this.transparent = transparent;
        }

        public List<String> getStyles() {
            return this.styles;
        }

        public void setStyles(List<String> styles) {
            this.styles = styles;
        }

        public URI getSld() {
            return this.sld;
        }

        public void setSld(URI sld) {
            this.sld = sld;
        }

        public String getSldBody() {
            return this.sldBody;
        }

        public void setSldBody(String sldBody) {
            this.sldBody = sldBody;
        }

        public String getGridSetName() {
            return this.gridSetName;
        }

        public void setGridSetName(String gridSetName) {
            this.gridSetName = gridSetName;
        }

        public List<TileMatrix> getGrids() {
            return this.grids;
        }

        public void setGrids(List<TileMatrix> grids) {
            this.grids = grids;
        }

        public TilesCoverage getCoverage() {
            return this.coverage;
        }

        public void setCoverage(TilesCoverage coverage) {
            this.coverage = coverage;
        }

        public List<QName> getLayers() {
            return this.layers;
        }

        public void setLayers(List<QName> layers) {
            this.layers = layers;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }

        public static class TilesCoverage {
            protected Integer minZoom = null;
            protected Integer maxZoom = null;
            protected Integer minColumn = null;
            protected Integer maxColumn = null;
            protected Integer minRow = null;
            protected Integer maxRow = null;

            public Integer getMinZoom() {
                return this.minZoom;
            }

            public void setMinZoom(Integer minZoom) {
                this.minZoom = minZoom;
            }

            public Integer getMaxZoom() {
                return this.maxZoom;
            }

            public void setMaxZoom(Integer maxZoom) {
                this.maxZoom = maxZoom;
            }

            public Integer getMinColumn() {
                return this.minColumn;
            }

            public void setMinColumn(Integer minColumn) {
                this.minColumn = minColumn;
            }

            public Integer getMaxColumn() {
                return this.maxColumn;
            }

            public void setMaxColumn(Integer maxColumn) {
                this.maxColumn = maxColumn;
            }

            public Integer getMinRow() {
                return this.minRow;
            }

            public void setMinRow(Integer minRow) {
                this.minRow = minRow;
            }

            public Integer getMaxRow() {
                return this.maxRow;
            }

            public void setMaxRow(Integer maxRow) {
                this.maxRow = maxRow;
            }
        }
    }

    public static class Parameter {
        String name;
        String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class FeaturesLayer
    extends Layer {
        protected QName featureType = null;
        protected Set<QName> propertyNames = null;
        protected Filter filter = null;
        protected SortBy[] sort = null;
        protected boolean indexed = false;
        protected boolean styles = true;
        protected boolean metadata = true;
        protected List<Overview> overviews;

        @Override
        public LayerType getType() {
            return LayerType.FEATURES;
        }

        public QName getFeatureType() {
            return this.featureType;
        }

        public void setFeatureType(QName featureType) {
            this.featureType = featureType;
        }

        public Set<QName> getPropertyNames() {
            return this.propertyNames;
        }

        public void setPropertyNames(Set<QName> propertyNames) {
            this.propertyNames = propertyNames;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        public SortBy[] getSort() {
            return this.sort;
        }

        public void setSort(SortBy[] sort) {
            this.sort = sort;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean isStyles() {
            return this.styles;
        }

        public void setStyles(boolean styles) {
            this.styles = styles;
        }

        public boolean isMetadata() {
            return this.metadata;
        }

        public void setMetadata(boolean metadata) {
            this.metadata = metadata;
        }

        public List<Overview> getOverviews() {
            return this.overviews;
        }

        public void setOverviews(List<Overview> overviews) {
            this.overviews = overviews;
        }
    }

    public static class Overview
    implements Comparable<Overview> {
        String name;
        double distance;
        double scaleDenominator;
        Filter filter;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        @Override
        public int compareTo(Overview o) {
            int diff = (int)Math.signum(this.distance - o.distance);
            if (diff != 0) {
                return diff;
            }
            return (int)Math.signum(this.scaleDenominator - o.scaleDenominator);
        }

        public double getScaleDenominator() {
            return this.scaleDenominator;
        }

        public void setScaleDenominator(double scaleDenominator) {
            this.scaleDenominator = scaleDenominator;
        }
    }

    public static enum LayerType {
        FEATURES,
        TILES;

    }
}

