/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

public class Envelope {
    protected double minX = Double.POSITIVE_INFINITY;
    protected double maxX = Double.NEGATIVE_INFINITY;
    protected double minY = Double.POSITIVE_INFINITY;
    protected double maxY = Double.NEGATIVE_INFINITY;
    protected double area = 0.0;

    public Envelope() {
    }

    public Envelope(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.area = (maxX - minX) * (maxY - minY);
    }

    public final void reset() {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.area = 0.0;
    }

    public final double populate(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.area = (maxX - minX) * (maxY - minY);
        return this.area;
    }

    public final double populate(Envelope e) {
        return this.populate(e.minX, e.maxX, e.minY, e.maxY);
    }

    public final double expandToFit(double minX, double maxX, double minY, double maxY) {
        if (minX < this.minX) {
            this.minX = minX;
        }
        if (maxX > this.maxX) {
            this.maxX = maxX;
        }
        if (minY < this.minY) {
            this.minY = minY;
        }
        if (maxY > this.maxY) {
            this.maxY = maxY;
        }
        this.area = (this.maxX - this.minX) * (this.maxY - this.minY);
        return this.area;
    }

    public final double expandToFit(Envelope e) {
        return this.expandToFit(e.minX, e.maxX, e.minY, e.maxY);
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final double getArea() {
        return this.area;
    }

    public boolean isNullGeometry() {
        return this.minX == Double.POSITIVE_INFINITY && this.maxX == Double.NEGATIVE_INFINITY && this.minY == Double.POSITIVE_INFINITY && this.maxY == Double.NEGATIVE_INFINITY;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Envelope) {
            Envelope that = (Envelope)obj;
            return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.minX;
    }

    public String toString() {
        return this.minX + ":" + this.maxX + ":" + this.minY + ":" + this.maxY;
    }
}

