/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.hatbox.IndexStatus;
import net.sourceforge.hatbox.MetaNode;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeInternalException;

public class Lock {
    private MetaNode meta;
    private ResultSet resultSet;
    private boolean write = false;

    public Lock(Connection con, RTreeDml dml, PreparedStatement selectStmt) {
        this.write = false;
        try {
            selectStmt.setLong(1, 1L);
            this.resultSet = selectStmt.executeQuery();
            if (!this.resultSet.next()) {
                throw new RTreeInternalException("Index meta node not found: " + dml.getIndexName());
            }
            byte[] nodeData = this.resultSet.getBytes(1);
            this.meta = new MetaNode(nodeData);
            dml.setMetaNode(this.meta);
        }
        catch (SQLException sqle) {
            throw new RTreeInternalException("Unable to select meta node", sqle);
        }
    }

    public Lock(Connection con, RTreeDml dml) {
        this.write = true;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(dml.getSelectIndex() + " FOR UPDATE", 1004, 1008);
            ps.setLong(1, 1L);
            this.resultSet = ps.executeQuery();
            if (!this.resultSet.next()) {
                throw new RTreeInternalException("Index meta node not found: " + dml.getIndexName());
            }
            byte[] nodeData = this.resultSet.getBytes(1);
            this.meta = new MetaNode(nodeData);
            if (IndexStatus.BUILDING.equals((Object)this.meta.getIndexStatus())) {
                throw new RTreeInternalException("Writing is not allowed while index is being constructed");
            }
            dml.setMetaNode(this.meta);
            this.resultSet.updateBytes(1, nodeData);
            this.resultSet.updateRow();
        }
        catch (SQLException sqle) {
            throw new RTreeInternalException("Unable to select meta node", sqle);
        }
    }

    public long getRootId() {
        return this.meta.getRootId();
    }

    public void setRootId(long rootId) throws SQLException {
        this.meta.setRootId(rootId);
        if (!this.write || this.resultSet == null) {
            throw new SQLException("Lock closed or not writable");
        }
        this.resultSet.updateBytes(1, this.meta.getData());
        this.resultSet.updateRow();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            if (this.write) {
                this.resultSet.getStatement().close();
            } else {
                this.resultSet.close();
            }
            this.resultSet = null;
        }
    }

    public boolean isClosed() {
        return this.resultSet == null;
    }
}

