/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.hatbox.wk.GeometryHandler;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.ParserConstants;
import net.sourceforge.hatbox.wk.WKBParseState;
import net.sourceforge.hatbox.wk.WKTParseState;

public abstract class AbstractGeometryHandler
implements GeometryHandler,
ParserConstants {
    private static final int BIG_ENDIAN = 0;

    @Override
    public abstract void readWKB(InputStream var1, WKBParseState var2) throws IOException;

    @Override
    public abstract void writeWKB(OutputStream var1, WKTParseState var2) throws IOException, ParseException;

    @Override
    public abstract WKTParseState handleToken(int var1, WKTParseState var2) throws ParseException;

    public void readCoord(InputStream is, WKBParseState state) throws IOException {
        double x = this.getDouble(is, state);
        double y = this.getDouble(is, state);
        if (state.hasZ()) {
            AbstractGeometryHandler.getBytes(is, state.getBytes(), 8);
        }
        state.addCoord(x, y);
    }

    public void readLinearRing(InputStream is, WKBParseState state) throws IOException {
        if (state.isBuildingString()) {
            state.openRing();
        }
        int coords = AbstractGeometryHandler.getInt(is, state);
        for (int i = 0; i < coords; ++i) {
            this.readCoord(is, state);
        }
        if (state.isBuildingString()) {
            state.closeRing();
        }
    }

    public static void getBytes(InputStream is, byte[] b, int length) throws IOException {
        int toRead = length;
        int offset = 0;
        int returned = is.read(b, offset, toRead);
        while (returned < toRead && returned >= 0) {
            returned = is.read(b, offset += returned, toRead -= returned);
        }
        if (returned < 0) {
            throw new EOFException();
        }
    }

    public double getDouble(InputStream is, WKBParseState state) throws IOException {
        return Double.longBitsToDouble(this.getLong(is, state));
    }

    public long getLong(InputStream is, WKBParseState state) throws IOException {
        byte[] b = state.getBytes();
        AbstractGeometryHandler.getBytes(is, b, 8);
        if (state.getEndian() == 0) {
            return ((long)b[0] & 0xFFL) << 56 | ((long)b[1] & 0xFFL) << 48 | ((long)b[2] & 0xFFL) << 40 | ((long)b[3] & 0xFFL) << 32 | ((long)b[4] & 0xFFL) << 24 | ((long)b[5] & 0xFFL) << 16 | ((long)b[6] & 0xFFL) << 8 | ((long)b[7] & 0xFFL) << 0;
        }
        return ((long)b[7] & 0xFFL) << 56 | ((long)b[6] & 0xFFL) << 48 | ((long)b[5] & 0xFFL) << 40 | ((long)b[4] & 0xFFL) << 32 | ((long)b[3] & 0xFFL) << 24 | ((long)b[2] & 0xFFL) << 16 | ((long)b[1] & 0xFFL) << 8 | ((long)b[0] & 0xFFL) << 0;
    }

    public static int getInt(InputStream is, WKBParseState state) throws IOException {
        byte[] b = state.getBytes();
        AbstractGeometryHandler.getBytes(is, b, 4);
        if (state.getEndian() == 0) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
        }
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | (b[0] & 0xFF) << 0;
    }

    public static int getByte(InputStream is) throws IOException {
        int b = is.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public void writeWKBHeader(OutputStream os, WKTParseState state) throws IOException, ParseException {
        if (state.getState() != 22) {
            throw new ParseException("Type " + state.getType().name() + " not in complete state");
        }
        os.write(0);
        this.writeInt(state.getType().getId(), os, state);
    }

    public void writeCoord(OutputStream os, WKTParseState.Coord coord, WKTParseState state) throws IOException {
        this.writeDouble(coord.x, os, state);
        this.writeDouble(coord.y, os, state);
    }

    public void writeInt(int val, OutputStream os, WKTParseState state) throws IOException {
        byte[] data = state.getIntBuf();
        data[0] = (byte)(val >> 24);
        data[1] = (byte)(val >> 16);
        data[2] = (byte)(val >> 8);
        data[3] = (byte)val;
        os.write(data);
    }

    public void writeDouble(double d, OutputStream os, WKTParseState state) throws IOException {
        byte[] data = state.getLongBuf();
        long val = Double.doubleToLongBits(d);
        data[0] = (byte)(val >> 56);
        data[1] = (byte)(val >> 48);
        data[2] = (byte)(val >> 40);
        data[3] = (byte)(val >> 32);
        data[4] = (byte)(val >> 24);
        data[5] = (byte)(val >> 16);
        data[6] = (byte)(val >> 8);
        data[7] = (byte)val;
        os.write(data);
    }
}

