/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import net.sourceforge.hatbox.wk.WKBEnvelope;
import net.sourceforge.hatbox.wk.WKBGeometryType;

public class WKBParseState {
    private byte[] bytes = new byte[8];
    private int endian;
    private boolean hasZ;
    private WKBEnvelope envelope;
    private StringBuilder stringBuilder;
    private int coordCount;
    private int typeCount;
    private int ringCount;
    private WKBParseState parent;
    private WKBGeometryType type;

    public int getEndian() {
        return this.endian;
    }

    public void setEndian(int endian) {
        this.endian = endian;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public void setHasZ(boolean z) {
        this.hasZ = z;
    }

    public WKBEnvelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(WKBEnvelope envelope) {
        this.envelope = envelope;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void setStringBuilder(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public WKBParseState getParent() {
        return this.parent;
    }

    public void setParent(WKBParseState parent) {
        this.parent = parent;
        this.envelope = parent.envelope;
        this.stringBuilder = parent.stringBuilder;
    }

    public WKBGeometryType getType() {
        return this.type;
    }

    public void setType(WKBGeometryType type) {
        this.type = type;
    }

    public int getTypeCount() {
        return this.typeCount;
    }

    public void setTypeCount(int typeCount) {
        this.typeCount = typeCount;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public final void addCoord(double x, double y) {
        if (this.envelope != null) {
            this.envelope.expandToFit(x, y);
        }
        if (this.stringBuilder != null) {
            if (this.coordCount > 0) {
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append(x);
            this.stringBuilder.append(' ');
            this.stringBuilder.append(y);
        }
        ++this.coordCount;
    }

    public final boolean isBuildingString() {
        return this.stringBuilder != null;
    }

    public final void openType(String name) {
        this.coordCount = 0;
        this.ringCount = 0;
        int parentTypeCount = 0;
        if (this.parent != null) {
            parentTypeCount = this.parent.getTypeCount();
        }
        if (parentTypeCount > 0) {
            this.stringBuilder.append(", ");
        }
        if (name != null) {
            this.stringBuilder.append(name);
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append('(');
    }

    public final void closeType() {
        this.stringBuilder.append(')');
    }

    public final void openRing() {
        this.coordCount = 0;
        if (this.ringCount > 0) {
            this.stringBuilder.append(", ");
        }
        this.stringBuilder.append('(');
        ++this.ringCount;
    }

    public final void closeRing() {
        this.stringBuilder.append(')');
    }
}

