/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.translate;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.translate.JaiI18N;
import org.eclipse.imagen.media.translate.TranslatePropertyGenerator;

public class TranslateDescriptor
extends OperationDescriptorImpl {
    private static final float TOLERANCE = 0.01f;
    private static final String[][] resources = new String[][]{{"GlobalName", "Translate"}, {"LocalName", "Translate"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("TranslateDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/TranslateDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("TranslateDescriptor1")}, {"arg1Desc", JaiI18N.getString("TranslateDescriptor2")}, {"arg2Desc", JaiI18N.getString("TranslateDescriptor3")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Interpolation.class};
    private static final String[] paramNames = new String[]{"xTrans", "yTrans", "interpolation"};
    private static final Object[] paramDefaults = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Interpolation.getInstance((int)0)};

    public TranslateDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new TranslatePropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, Float xTrans, Float yTrans, Interpolation interpolation, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Translate", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)hints);
        if (Math.abs(xTrans.floatValue() - (float)xTrans.intValue()) > 0.01f || Math.abs(yTrans.floatValue() - (float)yTrans.intValue()) > 0.01f || layout != null) {
            throw new UnsupportedOperationException("Translate Operation can be used only for integral displacements. Ifa layout is present, the translate operation cannot deal with");
        }
        return ImageN.create((String)"Translate", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

