/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.piecewise;

import org.eclipse.imagen.media.piecewise.MathTransformation;
import org.eclipse.imagen.media.piecewise.Position;

public class SingleDimensionTransformation
implements MathTransformation {
    public static final SingleDimensionTransformation IDENTITY = new SingleDimensionTransformation(1.0, 0.0);
    protected double scale;
    protected double offset;
    private MathTransformation inverse;

    protected SingleDimensionTransformation(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public double transform(double value) {
        return this.offset + this.scale * value;
    }

    @Override
    public double derivative(double value) {
        return this.scale;
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransformation inverseTransform() {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else if (this.scale != 0.0) {
                SingleDimensionTransformation inverse = SingleDimensionTransformation.create(1.0 / this.scale, -this.offset / this.scale);
                inverse.inverse = this;
                this.inverse = inverse;
            } else {
                throw new UnsupportedOperationException("Unable to invert such transformation");
            }
        }
        return this.inverse;
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity(0.0);
    }

    public boolean isIdentity(double tolerance) {
        tolerance = Math.abs(tolerance);
        return Math.abs(this.offset) <= tolerance && Math.abs(this.scale - 1.0) <= tolerance;
    }

    public static SingleDimensionTransformation create(double scale, double offset) {
        if (scale == 0.0) {
            return new ConstantTransform(offset);
        }
        if (scale == 1.0 && offset == 0.0) {
            return IDENTITY;
        }
        return new SingleDimensionTransformation(scale, offset);
    }

    @Override
    public Position transform(Position ptSrc, Position ptDst) {
        if (ptDst == null) {
            ptDst = new Position();
        }
        ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
        return ptDst;
    }

    public static class ConstantTransform
    extends SingleDimensionTransformation {
        protected ConstantTransform(double offset) {
            super(0.0, offset);
        }

        @Override
        public double transform(double value) {
            return this.offset;
        }
    }
}

