/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.facets;

import java.nio.charset.StandardCharsets;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class Length {
    public static final Length CHARACTERS = new Length(){

        @Override
        public void validate(XSDTypeDefinition definition, Object value) throws IllegalArgumentException {
            String text = (String)value;
            if (text.length() > this.length(definition)) {
                throw new IllegalArgumentException(text);
            }
        }
    };
    public static final Length OCTETS = new Length(){

        @Override
        public void validate(XSDTypeDefinition definition, Object value) throws IllegalArgumentException {
            String text = (String)value;
            if (text.getBytes(StandardCharsets.UTF_8).length > this.length(definition)) {
                throw new IllegalArgumentException(text);
            }
        }
    };
    public static final Length LIST = new Length(){

        @Override
        public int length(XSDTypeDefinition definition) {
            try {
                XSDSimpleTypeDefinition simple = definition.getSimpleType();
                XSDLengthFacet facet = simple.getLengthFacet();
                if (facet == null) {
                    return Integer.MAX_VALUE;
                }
                return Integer.parseInt(facet.getLexicalValue());
            }
            catch (NumberFormatException ignore) {
                return Integer.MIN_VALUE;
            }
        }

        @Override
        public void validate(XSDTypeDefinition definition, Object value) throws IllegalArgumentException {
            String text = (String)value;
            if (text.getBytes(StandardCharsets.UTF_8).length > this.length(definition)) {
                throw new IllegalArgumentException(text);
            }
        }
    };

    private Length() {
    }

    public int length(XSDTypeDefinition definition) {
        try {
            XSDSimpleTypeDefinition simple = (XSDSimpleTypeDefinition)definition;
            XSDLengthFacet facet = simple.getLengthFacet();
            if (facet == null) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(facet.getLexicalValue());
        }
        catch (NumberFormatException ignore) {
            return Integer.MIN_VALUE;
        }
    }

    public abstract void validate(XSDTypeDefinition var1, Object var2) throws IllegalArgumentException;
}

