/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.facets;

import java.util.ArrayList;
import java.util.List;

public abstract class Whitespace
implements Comparable<Whitespace> {
    public static final Whitespace PRESERVE = new Whitespace("preserve", 0){

        @Override
        public String preparse(String text) {
            return text;
        }
    };
    public static final Whitespace REPLACE = new Whitespace("replace", 1){

        @Override
        public String preparse(String text) {
            StringBuffer replace = new StringBuffer(text);
            for (int i = 0; i < replace.length(); ++i) {
                char ch = replace.charAt(i);
                if ('\t' != ch && '\n' != ch && '\r' != ch) continue;
                replace.setCharAt(i, ' ');
            }
            return replace.toString();
        }
    };
    public static final Whitespace COLLAPSE = new Whitespace("collapse", 2){

        @Override
        public String preparse(String text) {
            text = REPLACE.preparse(text);
            text = text.trim();
            StringBuffer collapse = new StringBuffer(text);
            for (int i = 0; i < collapse.length(); ++i) {
                if (' ' != collapse.charAt(i)) continue;
                ++i;
                while (i < collapse.length() && ' ' == collapse.charAt(i)) {
                    collapse.deleteCharAt(i);
                }
            }
            return collapse.toString();
        }
    };
    private static List<Whitespace> values = new ArrayList<Whitespace>();
    private int ordinal;
    private String name;

    private Whitespace(String name, int number) {
        this.ordinal = number;
        this.name = name;
    }

    public abstract String preparse(String var1);

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return this.ordinal;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Ha Ha");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) return false;
        if (!(other instanceof Whitespace)) return false;
        Whitespace w = (Whitespace)other;
        if (w.ordinal != this.ordinal) return false;
        return true;
    }

    @Override
    public int compareTo(Whitespace other) {
        int ord = other.ordinal;
        if (this.ordinal == ord) {
            return 0;
        }
        if (this.ordinal < ord) {
            return -1;
        }
        return 1;
    }

    public static Whitespace valueOf(String whitespace) {
        for (Whitespace item : values) {
            if (!whitespace.equals(item.name)) continue;
            return item;
        }
        return null;
    }

    public Class getDeclaringClass() {
        return Whitespace.class;
    }

    public static List values() {
        return values;
    }

    static {
        values.add(PRESERVE);
        values.add(REPLACE);
        values.add(COLLAPSE);
    }
}

