/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.geotools.util.Utilities;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.geotools.xsd.SchemaLocationResolver;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.XSD;
import org.geotools.xsd.impl.PicoMap;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public abstract class Configuration {
    private final XSD xsd;
    private final List<Configuration> dependencies;
    private final Set<QName> properties;
    private final MutablePicoContainer context;

    public Configuration(XSD xsd) {
        this.xsd = xsd;
        this.dependencies = Collections.synchronizedList(new ArrayList());
        if (!(this instanceof XSConfiguration)) {
            this.dependencies.add(new XSConfiguration());
        }
        this.properties = Collections.synchronizedSet(new HashSet());
        this.context = new DefaultPicoContainer();
    }

    public XSD getXSD() {
        return this.xsd;
    }

    public final List<Configuration> getDependencies() {
        return this.dependencies;
    }

    public final Set<QName> getProperties() {
        return this.properties;
    }

    public final boolean hasProperty(QName property) {
        for (Configuration configuration : this.allDependencies()) {
            if (!configuration.getProperties().contains(property)) continue;
            return true;
        }
        return false;
    }

    public final List<Configuration> allDependencies() {
        LinkedList<Configuration> unpacked = new LinkedList<Configuration>();
        Stack<Configuration> stack = new Stack<Configuration>();
        stack.push(this);
        while (!stack.isEmpty()) {
            Configuration c = (Configuration)stack.pop();
            if (unpacked.contains(c)) continue;
            unpacked.addFirst(c);
            stack.addAll(c.getDependencies());
        }
        if (unpacked.size() < 2) {
            return unpacked;
        }
        DepGraph g = new DepGraph();
        for (Configuration configuration : unpacked) {
            for (Configuration d : configuration.getDependencies()) {
                g.addEdge(configuration, d);
            }
        }
        PriorityQueue<DepNode> q = new PriorityQueue<DepNode>(g.nodes.size(), (o1, o2) -> Integer.valueOf(o1.outgoing().size()).compareTo(o2.outgoing().size()));
        for (DepNode n : g.nodes.values()) {
            q.add(n);
        }
        unpacked = new LinkedList();
        while (!q.isEmpty()) {
            DepNode depNode = (DepNode)q.remove();
            if (!depNode.outgoing().isEmpty()) {
                throw new IllegalStateException();
            }
            unpacked.add(depNode.config);
            for (DepNode i : depNode.incoming()) {
                g.removeEdge(i.config, depNode.config);
                q.removeAll(Collections.singletonList(i));
                q.add(i);
            }
        }
        return unpacked;
    }

    public <C extends Configuration> C getDependency(Class<C> clazz) {
        List<Configuration> dependencies = this.allDependencies();
        Configuration cast = dependencies.stream().filter(dep -> clazz.isInstance(dep)).findFirst().orElse(null);
        return (C)cast;
    }

    protected void addDependency(Configuration dependency) {
        if (this.dependencies.contains(dependency)) {
            return;
        }
        this.dependencies.add(dependency);
    }

    public final String getNamespaceURI() {
        return this.getXSD().getNamespaceURI();
    }

    public final MutablePicoContainer getContext() {
        return this.context;
    }

    public final Map<QName, Object> setupBindings() {
        HashMap<QName, Object> bindings = new HashMap<QName, Object>();
        PicoMap container = new PicoMap(bindings);
        for (Configuration dependency : this.allDependencies()) {
            dependency.registerBindings(bindings);
            dependency.registerBindings(container);
        }
        for (Configuration dependency : this.allDependencies()) {
            dependency.configureBindings(bindings);
            dependency.configureBindings(container);
        }
        return bindings;
    }

    public final void setupParser(Parser parser) {
        for (Configuration dep : this.allDependencies()) {
            dep.configureParser(parser);
        }
    }

    public final void setupEncoder(Encoder encoder) {
        for (Configuration dep : this.allDependencies()) {
            dep.configureEncoder(encoder);
        }
    }

    protected void registerBindings(MutablePicoContainer container) {
    }

    protected void registerBindings(Map<QName, Object> bindings) {
    }

    protected void configureBindings(MutablePicoContainer container) {
    }

    protected void configureBindings(Map<QName, Object> bindings) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MutablePicoContainer setupContext(MutablePicoContainer container) {
        List<Configuration> dependencies = this.allDependencies();
        for (Configuration value : dependencies) {
            SchemaLocator locator;
            Configuration dependency = value;
            SchemaLocationResolver resolver = new SchemaLocationResolver(dependency.getXSD());
            if (resolver != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocationResolver");
                container.registerComponentInstance((Object)key, (Object)resolver);
            }
            if ((locator = new SchemaLocator(dependency.getXSD())) != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocator");
                container.registerComponentInstance((Object)key, (Object)locator);
            }
            Set<QName> set = dependency.getProperties();
            synchronized (set) {
                for (QName property : dependency.getProperties()) {
                    try {
                        container.registerComponentInstance((Object)property, (Object)property);
                    }
                    catch (DuplicateComponentKeyRegistrationException duplicateComponentKeyRegistrationException) {}
                }
            }
            container = container.makeChildContainer();
            dependency.configureContext(container);
        }
        if (!this.context.getComponentAdapters().isEmpty()) {
            container = container.makeChildContainer();
            for (Configuration o : this.context.getComponentAdapters()) {
                ComponentAdapter adapter = (ComponentAdapter)o;
                container.registerComponent(adapter);
            }
        }
        return container;
    }

    protected void configureContext(MutablePicoContainer container) {
    }

    protected void configureParser(Parser parser) {
    }

    protected void configureEncoder(Encoder encoder) {
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration other = (Configuration)obj;
            return Utilities.equals((Object)this.getNamespaceURI(), (Object)other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        if (this.getNamespaceURI() != null) {
            return this.getNamespaceURI().hashCode();
        }
        return 0;
    }

    static class DepGraph {
        Map<Configuration, DepNode> nodes = new HashMap<Configuration, DepNode>();

        DepGraph() {
        }

        public void addEdge(Configuration from, Configuration to) {
            DepNode dst;
            DepNode src = this.addNode(from);
            DepEdge dep = src.getEdge(dst = this.addNode(to));
            if (dep != null) {
                return;
            }
            if (dst.getEdge(src) != null) {
                throw new IllegalArgumentException("Cycle between " + String.valueOf(from) + ", " + String.valueOf(to));
            }
            dep = new DepEdge(src, dst);
            src.edges.add(dep);
            dst.edges.add(dep);
        }

        public void removeEdge(Configuration from, Configuration to) {
            DepNode dst;
            DepNode src = this.addNode(from);
            DepEdge dep = src.getEdge(dst = this.addNode(to));
            if (dep == null) {
                throw new IllegalStateException("No such edge: " + String.valueOf(from) + "," + String.valueOf(to));
            }
            src.edges.remove(dep);
            dst.edges.remove(dep);
        }

        DepNode addNode(Configuration config) {
            DepNode node = this.nodes.get(config);
            if (node == null) {
                node = new DepNode(config);
                this.nodes.put(config, node);
            }
            return node;
        }
    }

    static class DepNode {
        Configuration config;
        List<DepEdge> edges = new ArrayList<DepEdge>();

        DepNode(Configuration config) {
            this.config = config;
        }

        DepEdge getEdge(DepNode node) {
            for (DepEdge edge : this.edges) {
                if (edge.src != this || edge.dst != node) continue;
                return edge;
            }
            return null;
        }

        public List<DepNode> incoming() {
            ArrayList<DepNode> incoming = new ArrayList<DepNode>();
            for (DepEdge edge : this.edges) {
                if (edge.dst != this) continue;
                incoming.add(edge.src);
            }
            return incoming;
        }

        public List<DepNode> outgoing() {
            ArrayList<DepNode> outgoing = new ArrayList<DepNode>();
            for (DepEdge edge : this.edges) {
                if (edge.src != this) continue;
                outgoing.add(edge.dst);
            }
            return outgoing;
        }

        public String toString() {
            return this.config.toString();
        }
    }

    static class DepEdge {
        DepNode src;
        DepNode dst;

        DepEdge(DepNode src, DepNode dst) {
            this.src = src;
            this.dst = dst;
        }

        public String toString() {
            return "[" + this.src.toString() + ", " + this.dst.toString() + "]";
        }
    }
}

