/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XS;
import org.geotools.xsd.BindingFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.ParserDelegate;
import org.geotools.xsd.ParserNamespaceSupport;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.BindingWalker;
import org.geotools.xsd.impl.BindingWalkerFactoryImpl;
import org.geotools.xsd.impl.DelegatingHandler;
import org.geotools.xsd.impl.DocumentHandler;
import org.geotools.xsd.impl.ElementHandler;
import org.geotools.xsd.impl.HTTPURIHandler;
import org.geotools.xsd.impl.Handler;
import org.geotools.xsd.impl.HandlerFactory;
import org.geotools.xsd.impl.HandlerFactoryImpl;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.geotools.xsd.impl.ValidatorHandler;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;

public class ParserHandler
extends DefaultHandler2 {
    protected Stack<Handler> handlers;
    ParserNamespaceSupport namespaces;
    XSDSchema[] schemas;
    SchemaIndex index;
    HandlerFactory handlerFactory;
    BindingLoader bindingLoader;
    BindingWalker bindingWalker;
    BindingFactory bindingFactory;
    DocumentHandler documentHandler;
    Configuration config;
    MutablePicoContainer context;
    Logger logger;
    boolean validating;
    ValidatorHandler validator;
    boolean strict = false;
    boolean handleMixedContent = false;
    boolean forceParserDelegate = false;
    QName rootElementType = null;
    List<URIHandler> uriHandlers = new ArrayList<URIHandler>();
    EntityResolver2 entityResolver;
    ContextCustomizer contextCustomizer;
    private boolean inCDATA = false;
    private boolean CDATAEnding = false;

    public ParserHandler(Configuration config) {
        this.config = config;
        this.namespaces = new ParserNamespaceSupport();
        this.validating = false;
        this.validator = new ValidatorHandler();
        this.uriHandlers.add((URIHandler)new HTTPURIHandler());
    }

    public void setContextCustomizer(ContextCustomizer contextCustomizer) {
        this.contextCustomizer = contextCustomizer;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.validator.setFailOnValidationError(failOnValidationError);
    }

    public boolean isFailOnValidationError() {
        return this.validator.isFailOnValidationError();
    }

    public void setHandleMixedContent(boolean handleMixedContent) {
        this.handleMixedContent = handleMixedContent;
    }

    public boolean isHandleMixedContent() {
        return this.handleMixedContent;
    }

    public void setForceParserDelegate(boolean forceParserDelegate) {
        this.forceParserDelegate = forceParserDelegate;
    }

    public boolean isForceParserDelegate() {
        return this.forceParserDelegate;
    }

    public void setRootElementType(QName rootElementType) {
        this.rootElementType = rootElementType;
    }

    public QName getRootElementType() {
        return this.rootElementType;
    }

    public List<Exception> getValidationErrors() {
        return this.validator.getErrors();
    }

    public ValidatorHandler getValidator() {
        return this.validator;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public BindingLoader getBindingLoader() {
        return this.bindingLoader;
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ParserNamespaceSupport getNamespaceSupport() {
        return this.namespaces;
    }

    public List<URIHandler> getURIHandlers() {
        return this.uriHandlers;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = (EntityResolver2)entityResolver;
        this.validator.setEntityResolver(entityResolver);
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (this.entityResolver != null) {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        return super.resolveEntity(publicId, systemId);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (this.entityResolver != null) {
            return this.entityResolver.resolveEntity(name, publicId, baseURI, systemId);
        }
        return super.resolveEntity(name, publicId, baseURI, systemId);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.declarePrefix(prefix, uri);
        if (!this.handlers.isEmpty()) {
            Handler h = this.handlers.peek();
            h.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.configure(this.config);
        DocumentHandler docHandler = this.handlerFactory.createDocumentHandler(this);
        this.context = new DefaultPicoContainer();
        this.context = this.config.setupContext(this.context);
        if (this.contextCustomizer != null) {
            this.contextCustomizer.customizeContext(this.context);
        }
        docHandler.setContext(this.context);
        this.handlers = new Stack();
        this.handlers.push(docHandler);
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger(ParserHandler.class);
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.context.registerComponentInstance((Object)this.namespaces);
        this.context.registerComponentInstance((Object)new NamespaceSupportWrapper(this.namespaces));
        this.bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance((Object)this.bindingFactory);
        this.context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
        this.context.registerComponentInstance((Object)this.config);
        this.validator.startDocument();
        docHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String prefix;
        QName qualifiedName;
        ElementHandler handler;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("startElement(" + uri + "," + localName + "," + qName);
        }
        boolean root = this.loadSchemas(uri, attributes);
        this.namespaces.pushContext();
        if (uri == null || uri.equals("")) {
            uri = this.namespaces.getURI("");
        }
        if ((handler = this.getHandler(attributes, root, qualifiedName = (prefix = this.namespaces.getPrefix(uri)) != null ? new QName(uri, localName, prefix) : new QName(uri, localName))) != null) {
            if (handler.getElementDeclaration().getTargetNamespace() != null && !handler.getElementDeclaration().getTargetNamespace().equals(uri) && !handler.getElementDeclaration().isAbstract()) {
                this.namespaces.declarePrefix("", handler.getElementDeclaration().getTargetNamespace());
                qualifiedName = new QName(handler.getElementDeclaration().getTargetNamespace(), qualifiedName.getLocalPart());
            }
        } else {
            String msg = "Handler for " + qName + " could not be found.";
            throw new SAXException(msg);
        }
        handler.startElement(qualifiedName, attributes);
        this.handlers.push(handler);
    }

    /*
     * WARNING - void declaration
     */
    private ElementHandler getHandler(Attributes attributes, boolean root, QName qualifiedName) throws SAXException {
        String msg;
        XSDElementDeclaration element;
        Handler parent = this.handlers.peek();
        ElementHandler handler = (ElementHandler)parent.createChildHandler(qualifiedName);
        if (handler == null && (element = this.index.getElementDeclaration(qualifiedName)) != null) {
            handler = this.handlerFactory.createElementHandler(element, parent, this);
        }
        if (handler == null) {
            List handlerFactories = this.context.getComponentInstancesOfType(HandlerFactory.class);
            Iterator<Object> hf = handlerFactories.iterator();
            while (handler == null && hf.hasNext()) {
                HandlerFactory handlerFactory = (HandlerFactory)hf.next();
                handler = handlerFactory.createElementHandler(qualifiedName, parent, this);
            }
        }
        if (handler == null || this.forceParserDelegate) {
            List<ComponentAdapter> adapters = Schemas.getComponentAdaptersOfType((PicoContainer)this.context, ParserDelegate.class);
            for (Object object : adapters) {
                ComponentAdapter adapter = (ComponentAdapter)object;
                ParserDelegate delegate = (ParserDelegate)adapter.getComponentInstance((PicoContainer)this.context);
                boolean canHandle = delegate.canHandle(qualifiedName, attributes, handler, parent);
                if (!canHandle) continue;
                handler = new DelegatingHandler(delegate, qualifiedName, parent);
                DelegatingHandler dh = (DelegatingHandler)handler;
                dh.startDocument();
                Enumeration e = this.namespaces.getPrefixes();
                while (e.hasMoreElements()) {
                    String pre = (String)e.nextElement();
                    dh.startPrefixMapping(pre, this.namespaces.getURI(pre));
                }
            }
        }
        if (handler == null && !this.isStrict()) {
            ElementInstance parentElement;
            List<XSDParticle> childParticles;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not find declaration for: " + String.valueOf(qualifiedName) + ". Checking if containing type declares a single particle.");
            }
            if (parent.getComponent() instanceof ElementInstance && (childParticles = this.index.getChildElementParticles((parentElement = (ElementInstance)parent.getComponent()).getElementDeclaration())).size() == 1) {
                XSDParticle xSDParticle = childParticles.iterator().next();
                XSDElementDeclaration child = (XSDElementDeclaration)xSDParticle.getContent();
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                handler = this.handlerFactory.createElementHandler(new QName(child.getTargetNamespace(), child.getName()), parent, this);
            }
        }
        if (handler == null && !this.isStrict()) {
            msg = "Could not find declaration for: " + String.valueOf(qualifiedName) + ". Performing lookup by ignoring namespace";
            this.logger.fine(msg);
            handler = (ElementHandler)parent.createChildHandler(new QName("*", qualifiedName.getLocalPart()));
        }
        if (handler == null && !this.isStrict()) {
            void var8_17;
            QName qName;
            void var8_15;
            msg = "Could not find declaration for: " + String.valueOf(qualifiedName) + ". Creating a mock element declaration and parsing anyways...";
            this.logger.fine(msg);
            XSDElementDeclaration decl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            decl.setName(qualifiedName.getLocalPart());
            decl.setTargetNamespace(qualifiedName.getNamespaceURI());
            Object var8_13 = null;
            if (root && this.rootElementType != null) {
                QName qName2 = this.rootElementType;
            }
            if (var8_15 == null && (qName = (QName)this.context.getComponentInstance((Object)"http://geotools.org/typeDefinition")) != null) {
                this.context.unregisterComponent((Object)"http://geotools.org/typeDefinition");
            }
            if (var8_17 != null) {
                type = this.index.getTypeDefinition((QName)var8_17);
                if (type == null) {
                    throw new NullPointerException();
                }
                decl.setTypeDefinition(type);
            } else {
                type = this.index.getTypeDefinition(XS.ANYTYPE);
                decl.setTypeDefinition(type);
            }
            handler = this.handlerFactory.createElementHandler(decl, parent, this);
        }
        return handler;
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadSchemas(String uri, Attributes attributes) throws SAXException {
        boolean root;
        boolean bl = root = this.schemas == null;
        if (root) {
            void var8_20;
            String[] locations = this.getSchemaLocations(attributes);
            List<XSDSchemaLocator> locators = Arrays.asList(this.findSchemaLocators());
            List<XSDSchemaLocationResolver> resolvers = Arrays.asList(this.findSchemaLocationResolvers());
            if (locations != null && locations.length > 0) {
                this.schemas = new XSDSchema[locations.length / 2];
                for (int i = 0; i < locations.length; i += 2) {
                    String string = locations[i];
                    String location = null;
                    if (i + 1 >= locations.length) {
                        this.logger.warning("Schema location not specified as namespace/location pair. Ignoring " + string);
                        continue;
                    }
                    location = locations[i + 1];
                    for (XSDSchemaLocationResolver resolver : resolvers) {
                        String override = resolver.resolveSchemaLocation(null, string, location);
                        if (override == null) continue;
                        override = override.replaceAll(" ", "%20");
                        this.logger.finer("Found override for " + string + ": " + location + " ==> " + override);
                        location = override;
                        break;
                    }
                    for (XSDSchemaLocator locator : locators) {
                        XSDSchema schema = locator.locateSchema(null, string, location, null);
                        if (schema == null) continue;
                        this.schemas[i / 2] = schema;
                        break;
                    }
                    if (this.schemas[i / 2] != null) continue;
                    if (this.isValidating()) {
                        try {
                            Schemas.validateImportsIncludes(location, locators, resolvers, this.entityResolver);
                        }
                        catch (IOException e) {
                            throw (SAXException)new SAXException("error validating").initCause(e);
                        }
                    }
                    try {
                        this.schemas[i / 2] = Schemas.parse(location, locators, resolvers, this.uriHandlers, this.entityResolver);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Error loading schema for namespace: " + string + " at location: " + location;
                        this.logger.warning(msg);
                        if (!this.isStrict()) continue;
                        throw new SAXException(msg, e);
                    }
                }
            } else {
                for (XSDSchemaLocator xSDSchemaLocator : locators) {
                    XSDSchema schema = xSDSchemaLocator.locateSchema(null, uri, null, null);
                    if (schema == null) continue;
                    this.schemas = new XSDSchema[]{schema};
                    break;
                }
            }
            int n = 0;
            for (XSDSchema xsdSchema : this.schemas) {
                if (xsdSchema == null) continue;
                ++n;
            }
            if (n != this.schemas.length) {
                XSDSchema[] xSDSchemaArray = new XSDSchema[n];
                int j = 0;
                for (XSDSchema schema : this.schemas) {
                    if (schema == null) continue;
                    xSDSchemaArray[j++] = schema;
                }
                this.schemas = xSDSchemaArray;
            }
            if (this.schemas == null || this.schemas.length == 0) {
                this.logger.warning("Could not find a schema");
                if (this.isStrict()) {
                    String string = "Could not find a schemaLocation attribute or appropriate locator";
                    throw new SAXException(string);
                }
                try {
                    this.schemas = new XSDSchema[]{this.config.getXSD().getSchema()};
                }
                catch (IOException iOException) {
                    throw (SAXException)new SAXException().initCause(iOException);
                }
            }
            boolean bl2 = false;
            block14: for (XSDSchema schema : this.schemas) {
                if (this.config.getNamespaceURI().equals(schema.getTargetNamespace())) {
                    boolean bl3 = true;
                    break;
                }
                List imports = Schemas.getImports(schema);
                for (Object anImport : imports) {
                    XSDImport imprt = (XSDImport)anImport;
                    if (!this.config.getNamespaceURI().equals(imprt.getNamespace())) continue;
                    boolean bl4 = true;
                    break block14;
                }
            }
            if (var8_20 == false) {
                if (!this.isStrict()) {
                    XSDSchema result;
                    this.logger.fine("schema specified by parser configuration not found, supplementing...");
                    XSDSchema[] copy = new XSDSchema[this.schemas.length + 1];
                    System.arraycopy(this.schemas, 0, copy, 0, this.schemas.length);
                    try {
                        result = this.config.getXSD().getSchema();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    copy[this.schemas.length] = result;
                    this.schemas = copy;
                } else {
                    String msg = "parser configuration specified schema: '" + this.config.getNamespaceURI() + "', but instance document does not reference this schema.";
                    this.logger.info(msg);
                }
            }
            this.index = new SchemaIndexImpl(this.schemas);
            this.context.registerComponentInstance((Object)this.index);
            if (this.namespaces.getURI("") == null) {
                this.namespaces.declarePrefix("", this.config.getNamespaceURI());
            }
        }
        return root;
    }

    private String[] getSchemaLocations(Attributes attributes) {
        String[] locations = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getQName(i);
            if (!name.endsWith("schemaLocation")) continue;
            this.logger.finer("schemaLocation found: " + attributes.getValue(i));
            locations = attributes.getValue(i).split(" +");
            break;
        }
        if (!this.isStrict() && locations == null) {
            this.logger.finer("No schemaLocation found, using '" + this.config.getNamespaceURI() + " " + this.config.getXSD().getSchemaLocation());
            locations = new String[]{this.config.getNamespaceURI(), this.config.getXSD().getSchemaLocation()};
        }
        return locations;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.peek();
        handler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.pop();
        String prefix = this.namespaces.getPrefix(uri);
        QName qualifiedName = prefix != null ? new QName(uri, localName, prefix) : new QName(uri, localName);
        handler.endElement(qualifiedName);
        this.endElementInternal(handler);
        if (handler instanceof DelegatingHandler) {
            DelegatingHandler dh = (DelegatingHandler)handler;
            if (!this.handlers.isEmpty() && !(this.handlers.peek() instanceof DelegatingHandler)) {
                dh.endDocument();
                dh.getParseNode().setValue(dh.delegate.getParsedObject());
            }
        }
        this.namespaces.popContext();
        if (this.isCDATAEnding()) {
            this.setCDATA(false);
        }
    }

    protected void endElementInternal(ElementHandler handler) {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.handlers.isEmpty()) {
            Handler h = this.handlers.peek();
            h.endPrefixMapping(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void endDocument() throws SAXException {
        this.validator.endDocument();
        this.documentHandler = (DocumentHandler)this.handlers.pop();
        this.documentHandler.endDocument();
        if (this.index != null) {
            this.index.destroy();
        }
        this.index = null;
        this.schemas = null;
        ParserHandler parserHandler = this;
        synchronized (parserHandler) {
            this.notifyAll();
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.isValidating()) {
            this.validator.warning(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.logger.log(Level.WARNING, e.getMessage());
        if (this.isValidating()) {
            this.validator.error(e);
        }
    }

    public Object getValue() {
        if (this.documentHandler != null) {
            return this.documentHandler.getParseNode().getValue();
        }
        if (!this.handlers.isEmpty()) {
            Handler h = this.handlers.peek();
            return h.getParseNode().getValue();
        }
        return null;
    }

    protected void configure(Configuration config) {
        Map<QName, Object> bindings = config.setupBindings();
        this.handlerFactory = new HandlerFactoryImpl();
        this.bindingLoader = new BindingLoader(bindings);
        this.bindingWalker = new BindingWalker(this.bindingLoader);
    }

    protected XSDSchemaLocator[] findSchemaLocators() {
        List<XSDSchemaLocator> l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocator.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocator[0];
        }
        return l.toArray(new XSDSchemaLocator[l.size()]);
    }

    protected XSDSchemaLocationResolver[] findSchemaLocationResolvers() {
        List<XSDSchemaLocationResolver> l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocationResolver.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocationResolver[0];
        }
        return l.toArray(new XSDSchemaLocationResolver[l.size()]);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.setCDATA(true);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.setCDATAEnding(true);
    }

    private void setCDATAEnding(boolean b) {
        this.CDATAEnding = b;
    }

    public boolean isCDATAEnding() {
        return this.CDATAEnding;
    }

    public void setCDATA(boolean b) {
        this.inCDATA = b;
    }

    public boolean isCDATA() {
        return this.inCDATA;
    }

    public static interface ContextCustomizer {
        public void customizeContext(MutablePicoContainer var1);
    }
}

