/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.factory.GeoTools;

public abstract class JDBCJNDIDataStoreFactory
extends JDBCDataStoreFactory {
    public static final String J2EERootContext = "java:comp/env/";
    public static final DataAccessFactory.Param JNDI_REFNAME = new DataAccessFactory.Param("jndiReferenceName", String.class, "JNDI data source", true, (Object)"java:comp/env/jdbc/mydatabase");
    protected JDBCDataStoreFactory delegate;

    protected JDBCJNDIDataStoreFactory(JDBCDataStoreFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    protected String getDriverClassName() {
        return null;
    }

    @Override
    protected String getValidationQuery() {
        return null;
    }

    @Override
    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        return null;
    }

    @Override
    protected DataSource createDataSource(Map<String, ?> params, SQLDialect dialect) throws IOException {
        String jndiName = (String)JNDI_REFNAME.lookUp(params);
        if (jndiName == null) {
            throw new IOException("Missing " + String.valueOf(JDBCJNDIDataStoreFactory.JNDI_REFNAME.description));
        }
        DataSource ds = null;
        try {
            ds = (DataSource)GeoTools.jndiLookup((String)jndiName);
        }
        catch (NamingException e1) {
            try {
                if (!jndiName.startsWith(J2EERootContext)) {
                    ds = (DataSource)GeoTools.jndiLookup((String)(J2EERootContext + jndiName));
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Using java:comp/env/" + jndiName + " instead of " + jndiName + " would avoid an unnecessary JNDI lookup");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (ds == null) {
            throw new IOException("Cannot find JNDI data source: " + jndiName);
        }
        return ds;
    }

    @Override
    public boolean isAvailable() {
        return GeoTools.isJNDIAvailable();
    }

    @Override
    protected void setupParameters(Map<String, Object> parameters) {
        parameters.put(JDBCJNDIDataStoreFactory.DBTYPE.key, new DataAccessFactory.Param(JDBCJNDIDataStoreFactory.DBTYPE.key, JDBCJNDIDataStoreFactory.DBTYPE.type, JDBCJNDIDataStoreFactory.DBTYPE.description, JDBCJNDIDataStoreFactory.DBTYPE.required, (Object)this.getDatabaseID()));
        parameters.put(JDBCJNDIDataStoreFactory.JNDI_REFNAME.key, JNDI_REFNAME);
        parameters.put(JDBCJNDIDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(JDBCJNDIDataStoreFactory.NAMESPACE.key, NAMESPACE);
        parameters.put(JDBCJNDIDataStoreFactory.FETCHSIZE.key, FETCHSIZE);
        parameters.put(JDBCJNDIDataStoreFactory.BATCH_INSERT_SIZE.key, BATCH_INSERT_SIZE);
        parameters.put(JDBCJNDIDataStoreFactory.EXPOSE_PK.key, EXPOSE_PK);
        parameters.put(JDBCJNDIDataStoreFactory.PK_METADATA_TABLE.key, PK_METADATA_TABLE);
        parameters.put(JDBCJNDIDataStoreFactory.SQL_ON_BORROW.key, SQL_ON_BORROW);
        parameters.put(JDBCJNDIDataStoreFactory.SQL_ON_RELEASE.key, SQL_ON_RELEASE);
        parameters.put(JDBCJNDIDataStoreFactory.CALLBACK_FACTORY.key, CALLBACK_FACTORY);
    }

    @Override
    protected String getDatabaseID() {
        return this.delegate.getDatabaseID();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName() + " (JNDI)";
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription() + " (JNDI)";
    }

    @Override
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        return this.delegate.createDataStoreInternal(dataStore, params);
    }

    @Override
    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.delegate.createNewDataStore(params);
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.delegate.getImplementationHints();
    }

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return this.delegate.createSQLDialect(dataStore);
    }

    @Override
    protected boolean checkDBType(Map<String, ?> params) {
        return this.delegate.checkDBType(params);
    }
}

