/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.template.ObjectWrapper;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/settings"})
public class SettingsController
extends AbstractGeoServerController {
    @Autowired
    public SettingsController(@Qualifier(value="geoServer") GeoServer geoServer) {
        super(geoServer);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<GeoServerInfo> settingsGet() {
        return this.wrapObject(this.geoServer.getGlobal(), GeoServerInfo.class);
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void settingsPut(@RequestBody GeoServerInfo geoServerInfo) {
        GeoServerInfo original = this.geoServer.getGlobal();
        OwsUtils.copy((Object)geoServerInfo, (Object)original, GeoServerInfo.class);
        this.geoServer.save(original);
    }

    @GetMapping(value={"/contact"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<ContactInfo> contactGet() {
        if (this.geoServer.getSettings().getContact() == null) {
            throw new ResourceNotFoundException("No contact information available");
        }
        return this.wrapObject(this.geoServer.getGlobal().getSettings().getContact(), ContactInfo.class);
    }

    @PutMapping(value={"/contact"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void contactSet(@RequestBody ContactInfo contactInfo) {
        GeoServerInfo geoServerInfo = this.geoServer.getGlobal();
        ContactInfo original = geoServerInfo.getSettings().getContact();
        OwsUtils.copy((Object)contactInfo, (Object)original, ContactInfo.class);
        this.geoServer.save(geoServerInfo);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return ContactInfo.class.isAssignableFrom(methodParameter.getParameterType()) || GeoServerInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper(clazz, Arrays.asList(ImageProcessingInfo.class, CoverageAccessInfo.class));
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.getXStream().alias("contact", ContactInfo.class);
    }
}

