/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.CatalogReloadController;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.SequentialExecutionController;
import org.springframework.stereotype.Controller;

@Controller
public class RestConfigurationLockCallback
implements DispatcherCallback {
    GeoServerConfigurationLock locker;

    public RestConfigurationLockCallback(GeoServerConfigurationLock locker) {
        this.locker = locker;
    }

    public void init(HttpServletRequest request, HttpServletResponse response) {
        GeoServerConfigurationLock.LockType type = this.locker.getCurrentLock();
        if (type != null) {
            throw new RuntimeException("The previous lock was not released: " + String.valueOf(type));
        }
    }

    public void dispatched(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Object controller = DispatcherCallback.getControllerBean((Object)handler);
        if (controller instanceof AbstractCatalogController || controller instanceof AbstractGeoServerController || controller instanceof SequentialExecutionController) {
            if (controller instanceof CatalogReloadController || this.isWriteMethod(request.getMethod())) {
                this.locker.lock(GeoServerConfigurationLock.LockType.WRITE);
            } else {
                this.locker.lock(GeoServerConfigurationLock.LockType.READ);
            }
        }
    }

    private boolean isWriteMethod(String method) {
        return "PUT".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method);
    }

    public void exception(HttpServletRequest request, HttpServletResponse response, Exception error) {
    }

    public void finished(HttpServletRequest request, HttpServletResponse response) {
        GeoServerConfigurationLock.LockType type = this.locker.getCurrentLock();
        if (type != null) {
            this.locker.unlock();
        }
    }
}

