/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import org.geoserver.rest.catalog.FeatureCollectionConverter;
import org.geoserver.rest.util.MediaTypeExtensions;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class SimpleFeatureCollectionConverter
extends FeatureCollectionConverter<SimpleFeatureCollection> {
    public SimpleFeatureCollectionConverter() {
        super(MediaType.APPLICATION_JSON, MediaTypeExtensions.TEXT_JSON, MediaType.APPLICATION_XML);
    }

    protected SimpleFeatureCollection getFeatures(SimpleFeatureCollection content) {
        return content;
    }

    protected void writeInternal(SimpleFeatureCollection content, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType mediaType = outputMessage.getHeaders().getContentType();
        if (MediaType.APPLICATION_JSON.includes(mediaType) || MediaTypeExtensions.TEXT_JSON.includes(mediaType)) {
            this.writeGeoJson(content, outputMessage);
        } else if (MediaType.APPLICATION_XML.includes(mediaType)) {
            this.writeGML(content, outputMessage);
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return SimpleFeatureCollection.class.isAssignableFrom(clazz);
    }
}

