/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.SLDNamedLayerValidator;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.PutIgnoringExtensionContentNegotiationStrategy;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.util.IOUtils;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.xml.sax.EntityResolver;

@RestController
@RequestMapping(path={"/rest"}, produces={"application/json", "application/xml", "text/html"})
public class StyleController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(StyleController.class);
    static final String SLD_TEMP_PREFIX = "_sld";
    static Path TEMP_DIR_ROOT = null;

    @Autowired
    public StyleController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(value={"/styles", "/layers/{layerName}/styles", "/workspaces/{workspaceName}/styles"})
    public RestWrapper<?> stylesGet(@PathVariable(required=false) String layerName, @PathVariable(required=false) String workspaceName) {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        if (layerName != null) {
            return this.wrapList(this.catalog.getLayerByName(layerName).getStyles(), StyleInfo.class);
        }
        if (workspaceName != null) {
            return this.wrapList(this.catalog.getStylesByWorkspace(workspaceName), StyleInfo.class);
        }
        List styles = this.catalog.getStylesByWorkspace(CatalogFacade.NO_WORKSPACE);
        return this.wrapList(styles, StyleInfo.class);
    }

    @PostMapping(value={"/styles", "/layers/{layerName}/styles", "/workspaces/{workspaceName}/styles"}, consumes={"text/xml", "application/xml", "application/json", "text/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public String stylePost(@RequestBody StyleInfo style, @PathVariable(required=false) String layerName, @PathVariable(required=false) String workspaceName, @RequestParam(defaultValue="false", name="default") boolean makeDefault) {
        this.checkWorkspaceName(workspaceName);
        this.checkFullAdminRequired(workspaceName);
        if (layerName != null) {
            StyleInfo existing = this.catalog.getStyleByName(style.getName());
            if (existing == null) {
                throw new ResourceNotFoundException();
            }
            LayerInfo l = this.catalog.getLayerByName(layerName);
            l.getStyles().add(existing);
            if (makeDefault) {
                l.setDefaultStyle(existing);
            }
            this.catalog.save(l);
            LOGGER.info("POST style " + style.getName() + " to layer " + layerName);
        } else {
            if (workspaceName != null) {
                style.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
            }
            this.catalog.add(style);
            LOGGER.info("POST style " + style.getName());
        }
        return style.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/styles", "/workspaces/{workspaceName}/styles"}, consumes={"application/zip"})
    public ResponseEntity<String> stylePost(InputStream stream, @RequestParam(required=false) String name, @PathVariable(required=false) String workspaceName, UriComponentsBuilder builder) throws IOException {
        ResponseEntity responseEntity;
        File directory = null;
        try {
            this.checkWorkspaceName(workspaceName);
            this.checkFullAdminRequired(workspaceName);
            directory = this.unzipSldPackage(stream);
            stream.close();
            File uploadedFile = this.getSldFileFromDirectory(directory);
            Style styleSld = this.parseSld(uploadedFile);
            if (name == null) {
                name = this.getNameFromStyle(styleSld);
            }
            this.checkStyleNotExists(workspaceName, name);
            this.saveImageResources(directory, workspaceName);
            StyleHandler handler = Styles.handler((String)"sld");
            Version version = handler.version((Object)uploadedFile);
            StyleInfo styleInfo = this.createStyleInfo(workspaceName, name, handler, handler.mimeType(version));
            this.checkStyleResourceNotExists(styleInfo);
            this.writeStyleRaw(styleInfo, uploadedFile);
            this.catalog.add(styleInfo);
            LOGGER.info("POST Style Package: " + name + ", workspace: " + workspaceName);
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(this.getUri(name, workspaceName, builder));
            headers.setContentType(MediaType.TEXT_PLAIN);
            responseEntity = new ResponseEntity((Object)name, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(directory);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)directory);
        return responseEntity;
    }

    @PostMapping(value={"/styles", "/workspaces/{workspaceName}/styles"}, consumes={"*/*"})
    public ResponseEntity<String> styleSLDPost(InputStream inputStream, @PathVariable(required=false) String workspaceName, @RequestParam(required=false) String name, @RequestHeader(value="Content-Type") String contentType, @RequestParam(name="raw", required=false, defaultValue="false") boolean raw, UriComponentsBuilder builder) throws IOException {
        this.checkWorkspaceName(workspaceName);
        this.checkFullAdminRequired(workspaceName);
        String mimeType = this.getMimeTypeFromContentType(contentType);
        String charset = this.getCharsetFromContentType(contentType);
        byte[] rawData = org.geoserver.rest.util.IOUtils.toByteArray((InputStream)inputStream);
        String content = new String(rawData, charset);
        EntityResolver entityResolver = this.catalog.getResourcePool().getEntityResolver();
        StyleHandler handler = Styles.handler((String)mimeType);
        Version version = handler.versionForMimeType(mimeType);
        StyledLayerDescriptor sld = handler.parse((Object)content, version, null, entityResolver);
        Style style = Styles.style((StyledLayerDescriptor)sld);
        if (name == null) {
            name = this.getNameFromStyle(style);
        }
        this.checkStyleNotExists(workspaceName, name);
        StyleInfo sinfo = this.createStyleInfo(workspaceName, name, handler, mimeType);
        this.checkStyleResourceNotExists(sinfo);
        try {
            this.writeStyle(raw, sinfo, sld, rawData, handler, version);
        }
        catch (Exception e) {
            throw new RestException("Error writing style", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        this.catalog.add(sinfo);
        LOGGER.info("POST Style " + name);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUri(name, workspaceName, builder));
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)name, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @GetMapping(path={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"}, produces={"*/*"})
    protected RestWrapper<StyleInfo> styleGet(@PathVariable String styleName, @PathVariable(required=false) String workspaceName) {
        return this.wrapObject(this.getStyleInternal(styleName, workspaceName), StyleInfo.class);
    }

    @GetMapping(path={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"}, produces={"application/vnd.ogc.sld+xml", "application/vnd.ogc.se+xml"})
    protected StyleInfo styleSLDGet(@PathVariable String styleName, @PathVariable(required=false) String workspaceName) {
        return this.getStyleInternal(styleName, workspaceName);
    }

    protected StyleInfo getStyleInternal(String styleName, String workspace) {
        StyleInfo sinfo = this.catalog.getStyleByName(workspace, styleName);
        if (sinfo == null) {
            String message = "No such style: " + styleName;
            if (workspace != null) {
                message = "No such style " + styleName + " in workspace " + workspace;
            }
            throw new ResourceNotFoundException(message);
        }
        LOGGER.fine("GET style " + styleName);
        return sinfo;
    }

    @DeleteMapping(path={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"})
    protected void styleDelete(@PathVariable String styleName, @PathVariable(required=false) String workspaceName, @RequestParam(required=false, defaultValue="false") boolean recurse, @RequestParam(required=false, defaultValue="false") boolean purge) throws IOException {
        StyleInfo style;
        this.checkWorkspaceName(workspaceName);
        StyleInfo styleInfo = style = workspaceName != null ? this.catalog.getStyleByName(workspaceName, styleName) : this.catalog.getStyleByName(styleName);
        if (style == null) {
            throw new ResourceNotFoundException("Style " + styleName + " not found");
        }
        if (recurse) {
            new CascadeDeleteVisitor(this.catalog).visit(style);
        } else {
            List layers = this.catalog.getLayers(style);
            if (!layers.isEmpty()) {
                throw new RestException("Can't delete style referenced by existing layers.", HttpStatus.FORBIDDEN);
            }
            this.catalog.remove(style);
        }
        this.catalog.getResourcePool().deleteStyle(style, purge);
        LOGGER.info("DELETE style " + styleName);
    }

    @PutMapping(value={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"}, consumes={"application/zip"})
    public void styleZipPut(InputStream is, @PathVariable String styleName, @PathVariable(required=false) String workspaceName) {
        this.checkWorkspaceName(workspaceName);
        this.checkFullAdminRequired(workspaceName);
        File directory = null;
        try {
            directory = this.unzipSldPackage(is);
            File uploadedFile = this.getSldFileFromDirectory(directory);
            Style styleSld = this.parseSld(uploadedFile);
            if (styleName == null) {
                styleName = this.getNameFromStyle(styleSld);
            }
            if (styleName == null) {
                throw new RestException("Style must have a name.", HttpStatus.BAD_REQUEST);
            }
            if (!this.existsStyleInCatalog(workspaceName, styleName)) {
                throw new RestException("Style " + styleName + " doesn't exist.", HttpStatus.FORBIDDEN);
            }
            this.saveImageResources(directory, workspaceName);
            StyleInfo styleInfo = this.catalog.getStyleByName(workspaceName, styleName);
            this.writeStyleRaw(styleInfo, uploadedFile);
            this.catalog.save(styleInfo);
            LOGGER.info("PUT Style Package: " + styleName + ", workspace: " + workspaceName);
        }
        catch (Exception e) {
            LOGGER.severe("Error processing the style package (PUT): " + e.getMessage());
            throw new RestException("Error processing the style", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)directory);
        }
    }

    @PutMapping(value={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"}, consumes={"*/*"})
    public void stylePut(InputStream inputStream, @PathVariable String styleName, @PathVariable(required=false) String workspaceName, @RequestParam(name="raw", required=false, defaultValue="false") boolean raw, @RequestHeader(value="Content-Type") String contentType) throws IOException {
        this.checkWorkspaceName(workspaceName);
        this.checkFullAdminRequired(workspaceName);
        StyleInfo info = this.catalog.getStyleByName(workspaceName, styleName);
        String mimeType = this.getMimeTypeFromContentType(contentType);
        String charset = this.getCharsetFromContentType(contentType);
        byte[] rawData = org.geoserver.rest.util.IOUtils.toByteArray((InputStream)inputStream);
        String content = new String(rawData, charset);
        EntityResolver entityResolver = this.catalog.getResourcePool().getEntityResolver();
        if (raw) {
            this.writeStyleRaw(info, rawData);
            try {
                for (StyleHandler handler : Styles.handlers()) {
                    Version version;
                    if (!Objects.equals(info.getFormat(), handler.getFormat()) || (version = Styles.handler((String)info.getFormat()).version((Object)content)) == null) continue;
                    info.setFormatVersion(version);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not determine the version of the raw style, the previous one was retained", e);
            }
            this.catalog.save(info);
        } else {
            try {
                StyleHandler handler = Styles.handler((String)mimeType);
                Version version = handler.versionForMimeType(mimeType);
                StyledLayerDescriptor sld = handler.parse((Object)content, version, null, entityResolver);
                this.writeStyle(false, info, sld, rawData, handler, version);
                this.catalog.save(info);
            }
            catch (Exception invalid) {
                throw new RestException("Invalid style:" + invalid.getMessage(), HttpStatus.BAD_REQUEST, (Throwable)invalid);
            }
        }
    }

    @PutMapping(value={"/styles/{styleName}", "/workspaces/{workspaceName}/styles/{styleName}"}, consumes={"text/xml", "application/xml", "application/json", "text/json"})
    public void stylePut(@RequestBody StyleInfo info, @PathVariable String styleName, @PathVariable(required=false) String workspaceName) {
        this.checkWorkspaceName(workspaceName);
        this.checkFullAdminRequired(workspaceName);
        StyleInfo original = this.catalog.getStyleByName(workspaceName, styleName);
        new CatalogBuilder(this.catalog).updateStyle(original, info);
        this.catalog.save(original);
    }

    private void writeStyle(boolean raw, StyleInfo info, StyledLayerDescriptor sld, byte[] rawData, StyleHandler handler, Version version) throws Exception {
        List validationErrors;
        ResourcePool resourcePool = this.catalog.getResourcePool();
        if (sld.getStyledLayers().length > 1 && !(validationErrors = SLDNamedLayerValidator.validate((Catalog)this.catalog, (StyledLayerDescriptor)sld)).isEmpty()) {
            throw (Exception)validationErrors.get(0);
        }
        Style style = Styles.style((StyledLayerDescriptor)sld);
        if (!raw && handler instanceof SLDHandler && sld.getStyledLayers().length <= 1 && SLDHandler.VERSION_10.equals((Object)version)) {
            info.setFormat(handler.getFormat());
            info.setFormatVersion(version);
            resourcePool.writeStyle(info, style, true);
        } else {
            info.setFormat(handler.getFormat());
            info.setFormatVersion(version);
            this.writeStyleRaw(info, rawData);
        }
    }

    private void writeStyleRaw(StyleInfo info, File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            this.catalog.getResourcePool().writeStyle(info, (InputStream)input);
        }
    }

    private void writeStyleRaw(StyleInfo info, byte[] bytes) throws IOException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
            this.catalog.getResourcePool().writeStyle(info, (InputStream)input);
        }
    }

    private Style parseSld(File sldFile) throws RestException {
        Style style;
        Style style2 = null;
        FileInputStream is = new FileInputStream(sldFile);
        try {
            Style[] styles;
            SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null), (InputStream)is);
            EntityResolver resolver = this.catalog.getResourcePool().getEntityResolver();
            if (resolver != null) {
                parser.setEntityResolver(resolver);
            }
            if ((styles = parser.readXML()).length > 0) {
                style2 = styles[0];
            }
            if (style2 == null) {
                throw new RestException("Style error.", HttpStatus.BAD_REQUEST);
            }
            style = style2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOGGER.severe(ex.getMessage());
                throw new RestException("Style error. " + ex.getMessage(), HttpStatus.BAD_REQUEST);
            }
        }
        ((InputStream)is).close();
        return style;
    }

    private File unzipSldPackage(InputStream object) throws IOException {
        File tempDir = TEMP_DIR_ROOT == null ? Files.createTempDirectory(SLD_TEMP_PREFIX, new FileAttribute[0]).toFile() : Files.createTempDirectory(TEMP_DIR_ROOT, SLD_TEMP_PREFIX, new FileAttribute[0]).toFile();
        IOUtils.decompress((InputStream)object, (File)tempDir);
        return tempDir;
    }

    private File getSldFileFromDirectory(File directory) throws RestException {
        File[] matchingFiles = directory.listFiles((dir, name) -> name.endsWith("sld"));
        if (matchingFiles == null || matchingFiles.length == 0) {
            throw new RestException("No sld file provided:", HttpStatus.FORBIDDEN);
        }
        LOGGER.fine("getSldFileFromDirectory (sldFile): " + matchingFiles[0].getAbsolutePath());
        return matchingFiles[0];
    }

    private File[] listImageFiles(File directory) {
        return directory.listFiles((dir, name) -> this.validImageFileExtensions.contains(FilenameUtils.getExtension((String)name).toLowerCase()));
    }

    private void saveImageResources(File directory, String workspaceName) throws IOException {
        File[] imageFiles;
        Resource stylesDir = workspaceName == null ? this.dataDir.getStyles(new String[0]) : this.dataDir.getStyles(this.catalog.getWorkspaceByName(workspaceName), new String[0]);
        for (File imageFile : imageFiles = this.listImageFiles(directory)) {
            org.geoserver.rest.util.IOUtils.copyStream((InputStream)new FileInputStream(imageFile), (OutputStream)stylesDir.get(imageFile.getName()).out(), (boolean)true, (boolean)true);
        }
    }

    private String getNameFromStyle(Style style) throws RestException {
        Object name = null;
        if (style != null) {
            name = style.getName();
        }
        if (name == null) {
            for (int i = 0; name == null && i < 100; ++i) {
                String candidate = "style-" + UUID.randomUUID().toString().substring(0, 7);
                if (this.catalog.getStyleByName(candidate) != null) continue;
                name = candidate;
            }
        }
        if (name == null) {
            throw new RestException("Unable to generate style name, specify one with 'name' parameter", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return name;
    }

    private StyleInfo createStyleInfo(String workspaceName, String name, StyleHandler handler, String mimeType) throws RestException {
        if (this.catalog.getStyleByName(workspaceName, name) != null) {
            throw new RestException("Style " + name + " already exists.", HttpStatus.FORBIDDEN);
        }
        StyleInfo sinfo = this.catalog.getFactory().createStyle();
        sinfo.setName(name);
        sinfo.setFilename(name + "." + handler.getFileExtension());
        sinfo.setFormat(handler.getFormat());
        sinfo.setFormatVersion(handler.versionForMimeType(mimeType));
        if (workspaceName != null) {
            sinfo.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
        }
        return sinfo;
    }

    private URI getUri(String name, String workspace, UriComponentsBuilder builder) {
        UriComponents uriComponents = workspace != null ? builder.path("/workspaces/{workspaceName}/styles/{styleName}").buildAndExpand(new Object[]{workspace, name}) : builder.path("/styles/{id}").buildAndExpand(new Object[]{name});
        return uriComponents.toUri();
    }

    private String getMimeTypeFromContentType(String contentType) {
        if (contentType != null) {
            return contentType.split(";")[0];
        }
        return null;
    }

    private String getCharsetFromContentType(String contentType) {
        String charsetRaw;
        if (contentType != null && contentType.split(";").length > 1 && (charsetRaw = contentType.split(";")[1]).contains("=") && charsetRaw.split("=").length > 1) {
            return charsetRaw.split("=")[1];
        }
        return Charset.defaultCharset().name();
    }

    private boolean existsStyleInCatalog(String workspaceName, String styleName) {
        return this.catalog.getStyleByName(workspaceName, styleName) != null;
    }

    private void checkWorkspaceName(String workspaceName) throws RestException {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
    }

    private void checkStyleNotExists(String workspaceName, String styleName) throws RestException {
        if (this.existsStyleInCatalog(workspaceName, styleName)) {
            throw new RestException("Style " + styleName + " already exists.", HttpStatus.FORBIDDEN);
        }
    }

    private void checkStyleResourceNotExists(StyleInfo info) throws RestException {
        GeoServerDataDirectory dataDir = new GeoServerDataDirectory(this.catalog.getResourceLoader());
        if (dataDir.style(info).getType() != Resource.Type.UNDEFINED) {
            throw new RestException("Style resource " + info.getFilename() + " already exists.", HttpStatus.FORBIDDEN);
        }
    }

    @Configuration
    static class StyleControllerConfiguration {
        StyleControllerConfiguration() {
        }

        @Bean
        PutIgnoringExtensionContentNegotiationStrategy stylePutContentNegotiationStrategy() {
            return new PutIgnoringExtensionContentNegotiationStrategy(new PatternsRequestCondition(new String[]{"/rest/styles/{styleName}", "/rest/workspaces/{workspaceName}/styles/{styleName}"}), Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.TEXT_HTML));
        }
    }
}

