/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.security.xml.AuthFilterChainCollection;
import org.geoserver.rest.security.xml.AuthFilterChainFilters;
import org.geoserver.rest.security.xml.AuthFilterChainOrder;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/rest/security/filterchain"})
public class AuthenticationFilterChainRestController
extends RestBaseController {
    private static final Set<String> RESERVED = Set.of("order");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CHAIN_PATH = "/{chainName:^(?!order(?:\\.(?:json|xml))?$).+}";
    private final GeoServerSecurityManager securityManager;

    public AuthenticationFilterChainRestController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void configurePersister(XStreamPersister xp, XStreamMessageConverter converter) {
        super.configurePersister(xp, converter);
        AuthenticationFilterChainRestController.configureAliases(xp);
    }

    private static void configureAliases(XStreamPersister persister) {
        XStream xs = persister.getXStream();
        xs.allowTypesByWildcard(new String[]{"org.geoserver.rest.security.xml.*"});
        xs.alias("filterchain", AuthFilterChainCollection.class);
        xs.addImplicitCollection(AuthFilterChainCollection.class, "chains", "filters", AuthFilterChainFilters.class);
        xs.alias("filters", AuthFilterChainFilters.class);
        xs.aliasField("class", AuthFilterChainFilters.class, "clazz");
        xs.aliasAttribute(AuthFilterChainFilters.class, "requireSSL", "ssl");
        xs.aliasSystemAttribute(null, "class");
        xs.aliasSystemAttribute(null, "resolves-to");
        xs.useAttributeFor(AuthFilterChainFilters.class, "name");
        xs.useAttributeFor(AuthFilterChainFilters.class, "clazz");
        xs.useAttributeFor(AuthFilterChainFilters.class, "path");
        xs.useAttributeFor(AuthFilterChainFilters.class, "disabled");
        xs.useAttributeFor(AuthFilterChainFilters.class, "allowSessionCreation");
        xs.useAttributeFor(AuthFilterChainFilters.class, "requireSSL");
        xs.useAttributeFor(AuthFilterChainFilters.class, "matchHTTPMethod");
        xs.useAttributeFor(AuthFilterChainFilters.class, "interceptorName");
        xs.useAttributeFor(AuthFilterChainFilters.class, "exceptionTranslationName");
        xs.useAttributeFor(AuthFilterChainFilters.class, "roleFilterName");
        xs.addImplicitCollection(AuthFilterChainFilters.class, "filters", "filter", String.class);
        xs.alias("order", AuthFilterChainOrder.class);
        xs.addImplicitCollection(AuthFilterChainOrder.class, "order", "order", String.class);
    }

    @GetMapping(produces={"application/xml", "application/json"})
    public RestWrapper<AuthFilterChainCollection> list() {
        this.checkAuthorised();
        try {
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            List chains = cfg.getFilterChain().getRequestChains();
            AuthFilterChainCollection col = new AuthFilterChainCollection();
            col.setChains(chains.stream().map(this::toDTO).collect(Collectors.toList()));
            return this.wrapObject(col, AuthFilterChainCollection.class);
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
    }

    @PutMapping(consumes={"application/xml", "text/xml", "application/json"}, produces={"application/xml", "application/json"})
    public RestWrapper<AuthFilterChainCollection> replaceAll(HttpServletRequest request) {
        this.checkAuthorised();
        try {
            AuthFilterChainCollection incoming = this.parseCollection(request);
            List dtos = Optional.ofNullable(incoming.getChains()).orElse(Collections.emptyList());
            Preconditions.checkArgument((!dtos.isEmpty() ? 1 : 0) != 0, (Object)"At least one chain must be provided");
            HashSet<String> names = new HashSet<String>();
            for (AuthFilterChainFilters dto : dtos) {
                Preconditions.checkArgument((dto.getName() != null && !dto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Each chain needs a name");
                Preconditions.checkArgument((dto.getClazz() != null && !dto.getClazz().isEmpty() ? 1 : 0) != 0, (Object)"Each chain needs a class");
                Preconditions.checkArgument((boolean)names.add(dto.getName()), (String)"Duplicate chain name: %s", (Object)dto.getName());
            }
            List rewritten = dtos.stream().map(this::toModel).collect(Collectors.toList());
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            cfg.setFilterChain(new GeoServerSecurityFilterChain(rewritten));
            this.securityManager.saveSecurityConfig(cfg);
            this.securityManager.reload();
            AuthFilterChainCollection out = new AuthFilterChainCollection();
            out.setChains(rewritten.stream().map(this::toDTO).collect(Collectors.toList()));
            return this.wrapObject(out, AuthFilterChainCollection.class);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequest(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CannotReadConfig(ex);
        }
        catch (Exception ex) {
            throw new CannotSaveConfig(ex);
        }
    }

    @PutMapping(path={"/order", "/order.{ext}"}, consumes={"application/json", "application/xml"})
    public ResponseEntity<Void> reorder(HttpServletRequest request) {
        this.checkAuthorised();
        try {
            List<String> wanted = this.parseOrderFromRequest(request);
            Preconditions.checkArgument((!wanted.isEmpty() ? 1 : 0) != 0, (Object)"`order` list required");
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            ArrayList current = new ArrayList(cfg.getFilterChain().getRequestChains());
            Set currentNames = current.stream().map(RequestFilterChain::getName).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)currentNames.equals(new HashSet<String>(wanted)), (Object)"Order must include exactly the current set of chains");
            Map<String, RequestFilterChain> byName = current.stream().collect(Collectors.toMap(RequestFilterChain::getName, c -> c));
            List<RequestFilterChain> reordered = wanted.stream().map(byName::get).toList();
            ArrayList<RequestFilterChain> engineOrder = new ArrayList<RequestFilterChain>(reordered);
            cfg.setFilterChain(new GeoServerSecurityFilterChain(engineOrder));
            this.securityManager.saveSecurityConfig(cfg);
            this.securityManager.reload();
            return ResponseEntity.ok().build();
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequest(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CannotReadConfig(ex);
        }
        catch (Exception ex) {
            throw new CannotSaveConfig(ex);
        }
    }

    @GetMapping(path={"/order", "/order.{ext}"})
    public ResponseEntity<Void> orderGetNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @PostMapping(path={"/order", "/order.{ext}"})
    public ResponseEntity<Void> orderPostNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @DeleteMapping(path={"/order", "/order.{ext}"})
    public ResponseEntity<Void> orderDeleteNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @GetMapping(path={"/{chainName:^(?!order$).+}"}, produces={"application/xml", "application/json"})
    public RestWrapper<AuthFilterChainFilters> getOneXml(@PathVariable String chainName) {
        String finalChainName = AuthenticationFilterChainRestController.normalizeChainName(chainName);
        this.checkAuthorised();
        try {
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            RequestFilterChain chain = Optional.ofNullable(cfg.getFilterChain().getRequestChainByName(finalChainName)).orElseThrow(() -> new FilterChainNotFound(finalChainName));
            AuthFilterChainFilters dto = this.toDTO(chain);
            return this.wrapObject(dto, AuthFilterChainFilters.class);
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    @PostMapping(consumes={"application/xml", "application/json"}, produces={"application/xml", "application/json"})
    public ResponseEntity<RestWrapper<AuthFilterChainFilters>> create(HttpServletRequest request, @RequestParam(name="position", required=false) Integer position, UriComponentsBuilder builder) {
        this.checkAuthorised();
        try {
            AuthFilterChainFilters dto = this.parseFiltersFromRequest(request);
            AuthenticationFilterChainRestController.ensureNotReserved(dto.getName());
            RequestFilterChain model = this.toModel(dto);
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            ArrayList<RequestFilterChain> chains = new ArrayList<RequestFilterChain>(cfg.getFilterChain().getRequestChains());
            if (chains.stream().anyMatch(c -> Objects.equals(c.getName(), model.getName()))) {
                throw new DuplicateChainName(model.getName());
            }
            int pos = position != null ? position.intValue() : chains.size();
            Preconditions.checkArgument((pos >= 0 && pos <= chains.size() ? 1 : 0) != 0, (Object)"position out of range");
            chains.add(pos, model);
            cfg.setFilterChain(new GeoServerSecurityFilterChain(chains));
            this.securityManager.saveSecurityConfig(cfg);
            this.securityManager.reload();
            HttpHeaders headers = new HttpHeaders();
            UriComponentsBuilder ub = builder != null ? builder : UriComponentsBuilder.newInstance();
            headers.setLocation(ub.path("/security/filterchain/{name}").buildAndExpand(new Object[]{model.getName()}).toUri());
            return new ResponseEntity((Object)this.wrapObject(dto, AuthFilterChainFilters.class), (MultiValueMap)headers, HttpStatus.CREATED);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequest(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CannotReadConfig(ex);
        }
        catch (ReflectiveOperationException ex) {
            throw new CannotMakeChain("dto.getClazz()", ex);
        }
        catch (Exception e) {
            this.rethrowIfDomain(e);
            if (e instanceof IOException || AuthenticationFilterChainRestController.causedBy(e, IOException.class)) {
                throw new CannotSaveConfig(e);
            }
            throw new CannotSaveConfig(e);
        }
    }

    @PutMapping(path={"/{chainName:^(?!order(?:\\.(?:json|xml))?$).+}"}, consumes={"application/xml", "application/json"}, produces={"application/xml", "application/json"})
    public RestWrapper<AuthFilterChainFilters> update(@PathVariable String chainName, HttpServletRequest request, @RequestParam(name="position", required=false) Integer position) {
        chainName = AuthenticationFilterChainRestController.normalizeChainName(chainName);
        this.checkAuthorised();
        try {
            AuthFilterChainFilters dto = this.parseFiltersFromRequest(request);
            AuthenticationFilterChainRestController.ensureNotReserved(dto.getName());
            RequestFilterChain incoming = this.toModel(dto);
            if (!Objects.equals(chainName, incoming.getName())) {
                throw new BadRequest("chainName must match payload name");
            }
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            ArrayList<RequestFilterChain> chains = new ArrayList<RequestFilterChain>(cfg.getFilterChain().getRequestChains());
            int existingIdx = AuthenticationFilterChainRestController.indexOf(chains, chainName);
            if (existingIdx < 0) {
                throw new FilterChainNotFound(chainName);
            }
            chains.set(existingIdx, incoming);
            if (position != null && position >= 0 && position < chains.size() && position != existingIdx) {
                chains.remove(existingIdx);
                chains.add(position, incoming);
            }
            cfg.setFilterChain(new GeoServerSecurityFilterChain(chains));
            this.securityManager.saveSecurityConfig(cfg);
            this.securityManager.reload();
            return this.wrapObject(dto, AuthFilterChainFilters.class);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequest(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CannotReadConfig(ex);
        }
        catch (ReflectiveOperationException ex) {
            throw new CannotMakeChain("dto.getClazz()", ex);
        }
        catch (Exception e) {
            this.rethrowIfDomain(e);
            if (e instanceof IOException || AuthenticationFilterChainRestController.causedBy(e, IOException.class)) {
                throw new CannotSaveConfig(e);
            }
            throw new CannotSaveConfig(e);
        }
    }

    @DeleteMapping(path={"/{chainName:^(?!order$).+}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteOne(@PathVariable String chainName) {
        chainName = AuthenticationFilterChainRestController.normalizeChainName(chainName);
        this.checkAuthorised();
        try {
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            GeoServerSecurityFilterChain chainCfg = cfg.getFilterChain();
            ArrayList<RequestFilterChain> chains = new ArrayList<RequestFilterChain>(chainCfg.getRequestChains());
            int idx = AuthenticationFilterChainRestController.indexOf(chains, chainName);
            if (idx < 0) {
                throw new NothingToDelete(chainName);
            }
            RequestFilterChain toRemove = (RequestFilterChain)chains.get(idx);
            Preconditions.checkArgument((boolean)toRemove.canBeRemoved(), (String)"Filter chain %s cannot be removed.", (Object)chainName);
            chains.remove(idx);
            cfg.setFilterChain(new GeoServerSecurityFilterChain(chains));
            this.securityManager.saveSecurityConfig(cfg);
            this.securityManager.reload();
        }
        catch (Exception e) {
            this.rethrowIfDomain(e);
            if (e instanceof IOException || AuthenticationFilterChainRestController.causedBy(e, IOException.class)) {
                throw new CannotSaveConfig(e);
            }
            throw new CannotSaveConfig(e);
        }
    }

    private static int indexOf(List<RequestFilterChain> chains, String name) {
        for (int i = 0; i < chains.size(); ++i) {
            if (!Objects.equals(chains.get(i).getName(), name)) continue;
            return i;
        }
        return -1;
    }

    private static String normalizeChainName(String n) {
        return n == null ? null : n.replaceFirst("\\.(xml|json)$", "");
    }

    private static void ensureNotReserved(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"name is required");
        Preconditions.checkArgument((!RESERVED.contains(name.toLowerCase()) ? 1 : 0) != 0, (String)"'%s' is reserved", (Object)name);
    }

    private AuthFilterChainFilters toDTO(RequestFilterChain c) {
        AuthFilterChainFilters dto = new AuthFilterChainFilters();
        dto.setName(c.getName());
        dto.setClazz(c.getClass().getName());
        List patterns = Optional.ofNullable(c.getPatterns()).orElse(Collections.emptyList());
        dto.setPath(String.join((CharSequence)",", patterns));
        dto.setDisabled(c.isDisabled());
        dto.setAllowSessionCreation(c.isAllowSessionCreation());
        dto.setRequireSSL(c.isRequireSSL());
        dto.setMatchHTTPMethod(c.isMatchHTTPMethod());
        dto.setRoleFilterName(c.getRoleFilterName());
        dto.setFilters(new ArrayList<String>(Optional.ofNullable(c.getFilterNames()).orElse(Collections.emptyList())));
        dto.setInterceptorName(AuthenticationFilterChainRestController.invokeStringGetter(c, "getInterceptorName"));
        dto.setExceptionTranslationName(AuthenticationFilterChainRestController.invokeStringGetter(c, "getExceptionTranslationName"));
        return dto;
    }

    private RequestFilterChain toModel(AuthFilterChainFilters dto) {
        try {
            Class<?> raw = Class.forName(dto.getClazz());
            Preconditions.checkArgument((boolean)RequestFilterChain.class.isAssignableFrom(raw), (String)"Class %s is not a RequestFilterChain", (Object)dto.getClazz());
            Class<?> chainClass = raw;
            RequestFilterChain chain = this.instantiateChain(chainClass, dto);
            chain.setName(dto.getName());
            chain.setPatterns(AuthenticationFilterChainRestController.splitCSV(dto.getPath()));
            if (dto.getDisabled() != null) {
                chain.setDisabled(dto.getDisabled().booleanValue());
            }
            if (dto.getAllowSessionCreation() != null) {
                chain.setAllowSessionCreation(dto.getAllowSessionCreation().booleanValue());
            }
            if (dto.getRequireSSL() != null) {
                chain.setRequireSSL(dto.getRequireSSL().booleanValue());
            }
            if (dto.getMatchHTTPMethod() != null) {
                chain.setMatchHTTPMethod(dto.getMatchHTTPMethod().booleanValue());
            }
            if (dto.getRoleFilterName() != null) {
                chain.setRoleFilterName(dto.getRoleFilterName());
            }
            chain.setFilterNames(Optional.ofNullable(dto.getFilters()).orElse(Collections.emptyList()));
            AuthenticationFilterChainRestController.invokeStringSetter(chain, "setInterceptorName", dto.getInterceptorName());
            AuthenticationFilterChainRestController.invokeStringSetter(chain, "setExceptionTranslationName", dto.getExceptionTranslationName());
            return chain;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotMakeChain(dto.getClazz(), e);
        }
    }

    private RequestFilterChain instantiateChain(Class<? extends RequestFilterChain> type, AuthFilterChainFilters dto) throws Exception {
        try {
            Constructor<? extends RequestFilterChain> c0 = type.getDeclaredConstructor(new Class[0]);
            c0.setAccessible(true);
            return c0.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException c0) {
            for (Constructor<?> ctor : type.getDeclaredConstructors()) {
                Class<?>[] p = ctor.getParameterTypes();
                if (p.length != 1 || !p[0].isArray() || p[0].getComponentType() != String.class) continue;
                ctor.setAccessible(true);
                String[] patterns = AuthenticationFilterChainRestController.splitCSVToArray(dto.getPath());
                return (RequestFilterChain)ctor.newInstance(new Object[]{patterns});
            }
            Object last = null;
            for (Constructor<?> ctor : type.getDeclaredConstructors()) {
                try {
                    ctor.setAccessible(true);
                    Class<?>[] p = ctor.getParameterTypes();
                    Object[] args = new Object[p.length];
                    for (int i = 0; i < p.length; ++i) {
                        args[i] = this.defaultArgFor(p[i], dto);
                    }
                    return (RequestFilterChain)ctor.newInstance(args);
                }
                catch (Exception e) {
                    last = e;
                }
            }
            throw new NoSuchMethodException("No suitable constructor for " + type.getName() + (String)(last != null ? " (last: " + last.getClass().getSimpleName() + ": " + ((Throwable)last).getMessage() + ")" : ""));
        }
    }

    private Object defaultArgFor(Class<?> t, AuthFilterChainFilters dto) {
        if (t.isArray() && t.getComponentType() == String.class) {
            return AuthenticationFilterChainRestController.splitCSVToArray(dto.getPath());
        }
        if (!t.isPrimitive()) {
            if (t == String.class) {
                return null;
            }
            if (List.class.isAssignableFrom(t) || Collection.class.isAssignableFrom(t)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(t)) {
                return new HashSet();
            }
            if (Map.class.isAssignableFrom(t)) {
                return new HashMap();
            }
            return null;
        }
        if (t == Boolean.TYPE) {
            return false;
        }
        if (t == Integer.TYPE) {
            return 0;
        }
        if (t == Long.TYPE) {
            return 0L;
        }
        if (t == Double.TYPE) {
            return 0.0;
        }
        if (t == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (t == Short.TYPE) {
            return (short)0;
        }
        if (t == Byte.TYPE) {
            return (byte)0;
        }
        if (t == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private static String[] splitCSVToArray(String csv) {
        if (csv == null || csv.trim().isEmpty()) {
            return new String[0];
        }
        return (String[])Arrays.stream(csv.split("\\s*,\\s*")).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }

    private static List<String> splitCSV(String csv) {
        if (csv == null || csv.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = csv.split("\\s*,\\s*");
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String p : parts) {
            if (p.isEmpty()) continue;
            list.add(p);
        }
        return list;
    }

    private static String invokeStringGetter(Object target, String method) {
        try {
            Method m = target.getClass().getMethod(method, new Class[0]);
            Object val = m.invoke(target, new Object[0]);
            return val instanceof String ? (String)val : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void invokeStringSetter(Object target, String method, String value) {
        if (value == null) {
            return;
        }
        try {
            Method m = target.getClass().getMethod(method, String.class);
            m.invoke(target, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthFilterChainFilters parseFiltersFromRequest(HttpServletRequest request) {
        String ct = Optional.ofNullable(request.getContentType()).orElse("");
        try (ServletInputStream in = request.getInputStream();){
            if (ct.contains("json")) {
                JsonNode fc;
                JsonNode root = MAPPER.readTree((InputStream)in);
                JsonNode node = root;
                if (node.has("filters") && node.get("filters").isObject()) {
                    node = node.get("filters");
                } else if (node.has("filterchain") && (fc = node.get("filterchain")) != null && fc.has("filters") && fc.get("filters").isArray() && fc.get("filters").size() == 1) {
                    node = fc.get("filters").get(0);
                }
                if (!node.isObject()) {
                    throw new BadRequest("Malformed payload: expected a single filter chain object");
                }
                AuthFilterChainFilters dto = new AuthFilterChainFilters();
                dto.setName(AuthenticationFilterChainRestController.getText(node, "@name", "name"));
                dto.setClazz(AuthenticationFilterChainRestController.getText(node, "@class", "class", "clazz"));
                dto.setPath(AuthenticationFilterChainRestController.getText(node, "@path", "path"));
                if (node.has("@disabled")) {
                    dto.setDisabled(node.get("@disabled").asBoolean());
                }
                if (node.has("@allowSessionCreation")) {
                    dto.setAllowSessionCreation(node.get("@allowSessionCreation").asBoolean());
                }
                if (node.has("@ssl")) {
                    dto.setRequireSSL(node.get("@ssl").asBoolean());
                }
                if (node.has("@matchHTTPMethod")) {
                    dto.setMatchHTTPMethod(node.get("@matchHTTPMethod").asBoolean());
                }
                dto.setRoleFilterName(AuthenticationFilterChainRestController.getText(node, "@roleFilterName", "roleFilterName"));
                dto.setInterceptorName(AuthenticationFilterChainRestController.getText(node, "@interceptorName", "interceptorName"));
                dto.setExceptionTranslationName(AuthenticationFilterChainRestController.getText(node, "@exceptionTranslationName", "exceptionTranslationName"));
                ArrayList<String> filters = new ArrayList<String>();
                JsonNode f = node.get("filter");
                if (f != null) {
                    if (f.isArray()) {
                        f.forEach(n -> filters.add(n.asText()));
                    } else {
                        filters.add(f.asText());
                    }
                }
                dto.setFilters(filters);
                AuthFilterChainFilters authFilterChainFilters = dto;
                return authFilterChainFilters;
            }
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            AuthenticationFilterChainRestController.configureAliases(xp);
            Object o = xp.load((InputStream)in, Object.class);
            if (o instanceof AuthFilterChainFilters) {
                AuthFilterChainFilters dto = (AuthFilterChainFilters)o;
                return dto;
            }
            if (!(o instanceof AuthFilterChainCollection)) throw new BadRequest("Malformed payload: expected a single <filters> element");
            AuthFilterChainCollection col = (AuthFilterChainCollection)o;
            List list = Optional.ofNullable(col.getChains()).orElse(List.of());
            if (list.size() != 1) throw new BadRequest("Malformed payload: expected a single <filters> element");
            AuthFilterChainFilters authFilterChainFilters = (AuthFilterChainFilters)list.get(0);
            return authFilterChainFilters;
        }
        catch (BadRequest e) {
            throw e;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new BadRequest("Malformed payload: " + e.getOriginalMessage());
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parseOrderFromRequest(HttpServletRequest request) {
        String ct = Optional.ofNullable(request.getContentType()).orElse("");
        try (ServletInputStream in = request.getInputStream();){
            if (ct.contains("json")) {
                JsonNode root = MAPPER.readTree((InputStream)in);
                JsonNode n = root.has("order") ? root.get("order") : (root.has("filterchain") ? root.get("filterchain").get("order") : null);
                if (n == null) throw new BadRequest("`order` array required");
                if (!n.isArray()) {
                    throw new BadRequest("`order` array required");
                }
                ArrayList<String> out = new ArrayList<String>();
                n.forEach(x -> out.add(x.asText()));
                ArrayList<String> arrayList = out;
                return arrayList;
            }
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            AuthenticationFilterChainRestController.configureAliases(xp);
            Object o = xp.load((InputStream)in, Object.class);
            if (!(o instanceof AuthFilterChainOrder)) throw new BadRequest("`order` array required");
            List<String> list = ((AuthFilterChainOrder)o).getOrder();
            if (list == null) throw new BadRequest("`order` array required");
            if (list.isEmpty()) {
                throw new BadRequest("`order` array required");
            }
            List<String> list2 = list;
            return list2;
        }
        catch (BadRequest e) {
            throw e;
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    private static String getText(JsonNode node, String ... keys) {
        for (String k : keys) {
            JsonNode v = node.get(k);
            if (v == null || v.isNull()) continue;
            return v.asText();
        }
        return null;
    }

    private static byte[] readBody(HttpServletRequest req) throws IOException {
        try (ServletInputStream in = req.getInputStream();){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    private static boolean isXmlContent(HttpServletRequest req) {
        String ct = Optional.ofNullable(req.getContentType()).orElse("");
        return ct.contains("application/xml") || ct.contains("text/xml");
    }

    private AuthFilterChainCollection parseCollection(HttpServletRequest req) throws IOException {
        byte[] body = AuthenticationFilterChainRestController.readBody(req);
        if (AuthenticationFilterChainRestController.isXmlContent(req)) {
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            AuthenticationFilterChainRestController.configureAliases(xp);
            return (AuthFilterChainCollection)xp.load((InputStream)new ByteArrayInputStream(body), AuthFilterChainCollection.class);
        }
        ObjectMapper om = new ObjectMapper();
        JsonNode root = om.readTree(body);
        if (root.has("filterchain")) {
            root = root.get("filterchain");
        }
        JsonNode array = null;
        if (root.isArray()) {
            array = root;
        } else if (root.has("filters") && root.get("filters").isArray()) {
            array = root.get("filters");
        } else if (root.has("chains") && root.get("chains").isArray()) {
            array = root.get("chains");
        } else if (root.has("filters") && root.get("filters").isObject()) {
            array = om.createArrayNode().add(root.get("filters"));
        } else if (root.isObject()) {
            array = om.createArrayNode().add(root);
        }
        if (array == null || !array.isArray() || array.isEmpty()) {
            throw new BadRequest("Malformed payload: expected a non-empty array of filter chains");
        }
        ArrayList<AuthFilterChainFilters> chains = new ArrayList<AuthFilterChainFilters>();
        for (JsonNode n : array) {
            chains.add((AuthFilterChainFilters)om.treeToValue((TreeNode)n, AuthFilterChainFilters.class));
        }
        AuthFilterChainCollection col = new AuthFilterChainCollection();
        col.setChains(chains);
        return col;
    }

    private void checkAuthorised() {
        if (!this.securityManager.checkAuthenticationForAdminRole()) {
            throw new NotAuthorised();
        }
    }

    @ExceptionHandler(value={CannotMakeChain.class})
    public ResponseEntity<ErrorResponse> handle(CannotMakeChain ex) {
        return new ResponseEntity((Object)new ErrorResponse(500, ex.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotSaveConfig.class})
    public ResponseEntity<ErrorResponse> handle(CannotSaveConfig ex) {
        return new ResponseEntity((Object)new ErrorResponse(500, ex.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotUpdateConfig.class})
    public ResponseEntity<ErrorResponse> handle(CannotUpdateConfig ex) {
        return new ResponseEntity((Object)new ErrorResponse(500, ex.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotReadConfig.class})
    public ResponseEntity<ErrorResponse> handle(CannotReadConfig ex) {
        return new ResponseEntity((Object)new ErrorResponse(500, ex.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BadRequest.class})
    public ResponseEntity<ErrorResponse> handle(BadRequest ex) {
        return new ResponseEntity((Object)new ErrorResponse(400, ex.getMessage()), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NothingToDelete.class})
    public ResponseEntity<ErrorResponse> handle(NothingToDelete ex) {
        return new ResponseEntity((Object)new ErrorResponse(410, ex.getMessage()), HttpStatus.GONE);
    }

    @ExceptionHandler(value={DuplicateChainName.class})
    public ResponseEntity<ErrorResponse> handle(DuplicateChainName ex) {
        return new ResponseEntity((Object)new ErrorResponse(400, ex.getMessage()), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FilterChainNotFound.class})
    public ResponseEntity<ErrorResponse> handle(FilterChainNotFound ex) {
        return new ResponseEntity((Object)new ErrorResponse(404, ex.getMessage()), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={NotAuthorised.class})
    public ResponseEntity<ErrorResponse> handle(NotAuthorised ex) {
        return new ResponseEntity((Object)new ErrorResponse(403, ex.getMessage()), HttpStatus.FORBIDDEN);
    }

    private static boolean causedBy(Throwable t, Class<? extends Throwable> type) {
        while (t != null) {
            if (type.isInstance(t)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    private void rethrowIfDomain(Exception e) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (t instanceof DuplicateChainName) {
                throw (DuplicateChainName)t;
            }
            if (t instanceof NothingToDelete) {
                throw (NothingToDelete)t;
            }
            if (t instanceof BadRequest) {
                throw (BadRequest)t;
            }
            if (t instanceof CannotMakeChain) {
                throw (CannotMakeChain)t;
            }
            if (!(t instanceof IllegalArgumentException)) continue;
            throw new BadRequest(t.getMessage());
        }
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class CannotReadConfig
    extends RuntimeException {
        public CannotReadConfig(Exception e) {
            super("Cannot read the Security configuration", e);
        }
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class CannotSaveConfig
    extends RuntimeException {
        public CannotSaveConfig(Exception e) {
            super("Cannot save the Security configuration", e);
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public static class BadRequest
    extends RuntimeException {
        public BadRequest(String m) {
            super(m);
        }
    }

    public static class DuplicateChainName
    extends RuntimeException {
        public DuplicateChainName(String filterName) {
            super("Cannot create the filter chain " + filterName + " because one with that name already exists.");
        }
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class CannotMakeChain
    extends RuntimeException {
        public CannotMakeChain(String cn, Exception e) {
            super("Cannot make class " + cn, e);
        }
    }

    public static class FilterChainNotFound
    extends RuntimeException {
        public FilterChainNotFound(String filterName) {
            super("Cannot find the filter chain " + filterName + " in the Security configuration.");
        }
    }

    public static class NothingToDelete
    extends RuntimeException {
        public NothingToDelete(String filterName) {
            super("Cannot delete " + filterName + " as no filter exists");
        }
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public static class NotAuthorised
    extends RuntimeException {
        public NotAuthorised() {
            super("Admin role required to access this resource");
        }
    }

    public static class ErrorResponse {
        private int status;
        private String message;

        public ErrorResponse(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class CannotUpdateConfig
    extends RuntimeException {
        public CannotUpdateConfig(Exception ex) {
            super("Cannot update the Security configuration ", ex);
        }
    }
}

