/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.security.xml.AuthFilter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.validation.FilterConfigValidator;
import org.geoserver.security.validation.SecurityConfigException;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/rest/security/authfilters"}, produces={"application/xml", "application/json"})
public class AuthenticationFilterController
extends RestBaseController {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationFilterController.class.getName());
    private final GeoServerSecurityManager securityManager;
    private final FilterConfigValidator filterConfigValidator;
    private static final Set<String> DELETE_BLACK_LIST = Set.of("anonymous", "basic", "form", "rememberme");

    public AuthenticationFilterController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.filterConfigValidator = new FilterConfigValidator(securityManager);
    }

    @GetMapping
    public RestWrapper<AuthFilter> list() {
        this.checkAuthorisation();
        List<AuthFilter> result = this.loadAuthFilters();
        return this.wrapList(result, AuthFilter.class);
    }

    @GetMapping(value={"/{filterName}"})
    public RestWrapper<SecurityFilterConfig> view(@PathVariable(value="filterName") String filterName) {
        this.checkAuthorisation();
        SecurityFilterConfig authfilter = null;
        try {
            authfilter = this.securityManager.loadFilterConfig(filterName, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.wrapObject(authfilter, SecurityFilterConfig.class);
    }

    @PostMapping(consumes={"application/xml", "application/json"})
    public RestWrapper<SecurityFilterConfig> post(@RequestBody SecurityFilterConfig authfilterRequest, UriComponentsBuilder uriComponentsBuilder) {
        this.checkAuthorisation();
        SecurityFilterConfig authfilterResponse = this.saveAuthFilter(authfilterRequest);
        return this.wrapObject(authfilterResponse, SecurityFilterConfig.class);
    }

    @PutMapping(value={"/{filterName}"}, consumes={"application/xml", "application/json"})
    @ResponseStatus(code=HttpStatus.OK)
    public void put(@PathVariable(value="filterName") String filterName, @RequestBody SecurityFilterConfig authfilterRequest) {
        this.checkAuthorisation();
        this.updateAuthFilter(filterName, authfilterRequest);
    }

    @DeleteMapping(value={"/{filterName}"})
    @ResponseStatus(code=HttpStatus.OK)
    public void delete(@PathVariable(value="filterName") String filterName) {
        this.checkAuthorisation();
        this.removeAuthFilter(filterName);
    }

    private void checkAuthorisation() {
        if (!this.securityManager.checkAuthenticationForAdminRole()) {
            throw new NotAuthorised();
        }
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.getXStream().allowTypesByWildcard(new String[]{"org.geoserver.security.**", "org.geoserver.security.config.**", "org.geoserver.rest.security.xml.**"});
        persister.getXStream().processAnnotations(new Class[]{AuthFilter.class});
        super.configurePersister(persister, converter);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return AuthFilter.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected List<AuthFilter> loadAuthFilters() {
        try {
            SortedSet authfilterNames = this.securityManager.listFilters(GeoServerAuthenticationFilter.class);
            ArrayList<AuthFilter> authfilters = new ArrayList<AuthFilter>();
            for (String filterName : authfilterNames) {
                SecurityFilterConfig securityFilterConfig = this.securityManager.loadFilterConfig(filterName, false);
                if (securityFilterConfig == null) continue;
                AuthFilter filter = new AuthFilter(securityFilterConfig);
                authfilters.add(filter);
            }
            return authfilters;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load provider filters", ex);
        }
    }

    protected SecurityFilterConfig saveAuthFilter(SecurityFilterConfig newFilter) {
        if (Strings.isNullOrEmpty((String)newFilter.getName())) {
            LOGGER.warning(String.format("Cannot create the filter %s because client has not provided a name", newFilter.getName()));
            throw new MissingNameException();
        }
        try {
            if (this.securityManager.loadFilterConfig(newFilter.getName(), false) != null) {
                LOGGER.warning(String.format("Cannot create the filter %s because a filter with the name already exists", newFilter.getName()));
                throw new DuplicateNameException(newFilter.getName());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot access filter provider config", ex);
        }
        try {
            this.filterConfigValidator.validateFilterConfig((SecurityNamedServiceConfig)newFilter);
            newFilter.setName(newFilter.getName());
            this.securityManager.saveFilter((SecurityNamedServiceConfig)newFilter);
            this.securityManager.reload();
        }
        catch (IOException | SecurityConfigException ex) {
            throw new IllegalStateException("Cannot save filter provider config" + newFilter.getName(), ex);
        }
        try {
            return this.securityManager.loadFilterConfig(newFilter.getName(), false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot access filter provider  " + newFilter.getName() + " it has been saved", ex);
        }
    }

    protected void updateAuthFilter(String filterName, SecurityFilterConfig authfilterRequest) {
        if (!filterName.equals(authfilterRequest.getName())) {
            LOGGER.warning(String.format("Cannot modify the config %s because the name %s in the body does not match", filterName, authfilterRequest.getName()));
            throw new NameMismatchException(filterName, authfilterRequest.getName());
        }
        try {
            SecurityFilterConfig filter = this.securityManager.loadFilterConfig(filterName, false);
            if (filter == null) {
                LOGGER.warning(String.format("Cannot update %s because it does not exist", filterName));
                throw new IllegalArgumentException(String.format("Cannot update %s because it does not exist", filterName));
            }
            this.filterConfigValidator.validateFilterConfig((SecurityNamedServiceConfig)authfilterRequest);
            authfilterRequest.setId(filter.getId());
            authfilterRequest.setName(authfilterRequest.getName());
            this.securityManager.saveFilter((SecurityNamedServiceConfig)authfilterRequest);
            this.securityManager.reload();
        }
        catch (IOException | SecurityConfigException ex) {
            throw new IllegalStateException("Cannot access filter provider configs", ex);
        }
    }

    protected void removeAuthFilter(String filterName) {
        if (DELETE_BLACK_LIST.contains(filterName)) {
            LOGGER.warning(String.format("Cannot delete %s because it is a required authentication filter", filterName));
            throw new DeleteBlackListException(filterName);
        }
        try {
            SecurityFilterConfig filter = this.securityManager.loadFilterConfig(filterName, false);
            if (filter == null) {
                LOGGER.warning(String.format("Cannot delete %s because it does not exist", filterName));
                throw new IllegalArgumentException("Cannot find filter " + filterName);
            }
            this.securityManager.removeFilter((SecurityNamedServiceConfig)filter);
            this.securityManager.reload();
        }
        catch (IOException | SecurityConfigException ex) {
            throw new IllegalStateException("Cannot access filter provider config " + filterName, ex);
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ErrorResponse> somethingNotFound(IllegalArgumentException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.NOT_FOUND.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DeleteBlackListException.class})
    public ResponseEntity<ErrorResponse> blackListed(DeleteBlackListException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NameMismatchException.class})
    public ResponseEntity<ErrorResponse> nameMismatched(NameMismatchException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MissingNameException.class})
    public ResponseEntity<ErrorResponse> missingName(MissingNameException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IdNotSet.class})
    public ResponseEntity<ErrorResponse> idNotSet(IdNotSet exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SecurityConfigException.class})
    public ResponseEntity<ErrorResponse> securityIssue(SecurityConfigException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<ErrorResponse> ioIssue(IOException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FilterConfigException.class})
    public ResponseEntity<ErrorResponse> validationError(FilterConfigException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DuplicateNameException.class})
    public ResponseEntity<ErrorResponse> duplicatedName(DuplicateNameException exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotAuthorised.class})
    public ResponseEntity<ErrorResponse> notAuthorised(NotAuthorised exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.FORBIDDEN.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.FORBIDDEN);
    }

    public static class NotAuthorised
    extends RuntimeException {
        public NotAuthorised() {
            super("Admin role required to access this resource");
        }
    }

    public static class MissingNameException
    extends RuntimeException {
        public MissingNameException() {
            super("Cannot create the config has no name parameter");
        }
    }

    public static class DuplicateNameException
    extends RuntimeException {
        public DuplicateNameException(String configName) {
            super(String.format("Cannot create the config %s because the name is already in use", configName));
        }
    }

    public static class NameMismatchException
    extends RuntimeException {
        public NameMismatchException(String pathName, String configName) {
            super(String.format("Cannot modify the config %s because the name %s in the body does not match", pathName, configName));
        }
    }

    public static class DeleteBlackListException
    extends RuntimeException {
        public DeleteBlackListException(String name) {
            super(String.format("Cannot delete %s because it is a required authentication filter", name));
        }
    }

    public static class ErrorResponse {
        private int status;
        private String message;

        public ErrorResponse(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class IdNotSet
    extends RuntimeException {
        public IdNotSet(String requestBodyId, String id) {
            super(String.format("Cannot modify the config with %s because the id %s in the body does not match", requestBodyId, id));
        }
    }
}

