/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.security.xml.AuthProviderCollection;
import org.geoserver.rest.security.xml.AuthProviderOrder;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/security/authproviders"})
public class AuthenticationProviderRestController
extends RestBaseController {
    private static final String PROVIDER_PATH = "/{providerName:^(?!order(?:\\.(?:json|xml))?$).+}";
    private static final Set<String> RESERVED = Set.of("order");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final GeoServerSecurityManager securityManager;
    private static final ConcurrentMap<String, Class<? extends SecurityAuthProviderConfig>> CONFIG_CACHE = new ConcurrentHashMap<String, Class<? extends SecurityAuthProviderConfig>>();

    public AuthenticationProviderRestController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void configurePersister(XStreamPersister xp, XStreamMessageConverter conv) {
        super.configurePersister(xp, conv);
        XStream xs = xp.getXStream();
        xs.allowTypesByWildcard(new String[]{"org.geoserver.rest.security.xml.*"});
        xs.alias("authproviders", AuthProviderCollection.class);
        xs.addImplicitCollection(AuthProviderCollection.class, "providers", null, SecurityAuthProviderConfig.class);
        xs.alias("order", AuthProviderOrder.class);
        xs.addImplicitCollection(AuthProviderOrder.class, "order", "order", String.class);
    }

    @GetMapping(path={"", ".{ext:xml|json}"}, produces={"application/xml", "application/json"})
    public RestWrapper<AuthProviderCollection> list() {
        this.checkAuthorised();
        try {
            List<SecurityAuthProviderConfig> cfgs = this.getConfigOrder().stream().map(this::loadConfigOrError).collect(Collectors.toList());
            return this.wrapObject(new AuthProviderCollection(cfgs), AuthProviderCollection.class);
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    @GetMapping(path={"/{providerName:^(?!order(?:\\.(?:json|xml))?$).+}"}, produces={"application/xml", "application/json"})
    public RestWrapper<SecurityAuthProviderConfig> one(@PathVariable String providerName) {
        providerName = AuthenticationProviderRestController.normalizeName(providerName);
        this.checkAuthorised();
        return this.wrapObject(this.loadConfigOrError(providerName), SecurityAuthProviderConfig.class);
    }

    @PostMapping(consumes={"application/xml", "application/json"}, produces={"application/xml", "application/json"})
    public ResponseEntity<RestWrapper<SecurityAuthProviderConfig>> create(HttpServletRequest request, @RequestParam(name="position", required=false) Integer position, UriComponentsBuilder builder) {
        SecurityAuthProviderConfig cfg;
        this.checkAuthorised();
        try {
            cfg = this.parseConfig(request);
        }
        catch (BadRequest e) {
            throw e;
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
        try {
            this.ensureNotReserved(cfg.getName());
            List<String> order = this.getConfigOrder();
            if (order.contains(cfg.getName())) {
                throw new DuplicateProviderName(cfg.getName());
            }
            int pos = position != null ? position.intValue() : order.size();
            AuthenticationProviderRestController.validatePosition(pos, order.size());
            this.securityManager.saveAuthenticationProvider(cfg);
            order.add(pos, cfg.getName());
            this.saveConfigOrder(order);
            this.securityManager.reload();
            HttpHeaders h = new HttpHeaders();
            h.setLocation(builder.path("/security/authproviders/{name}").buildAndExpand(new Object[]{cfg.getName()}).toUri());
            return new ResponseEntity((Object)this.wrapObject(cfg, SecurityAuthProviderConfig.class), (MultiValueMap)h, HttpStatus.CREATED);
        }
        catch (DuplicateProviderName e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
    }

    @PutMapping(path={"/{providerName:^(?!order(?:\\.(?:json|xml))?$).+}"}, consumes={"application/xml", "application/json"}, produces={"application/xml", "application/json"})
    public RestWrapper<SecurityAuthProviderConfig> update(@PathVariable String providerName, HttpServletRequest request, @RequestParam(name="position", required=false) Integer position) {
        SecurityAuthProviderConfig incoming;
        this.checkAuthorised();
        providerName = AuthenticationProviderRestController.normalizeName(providerName);
        try {
            incoming = this.parseConfig(request);
        }
        catch (BadRequest e) {
            throw e;
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
        this.ensureNotReserved(incoming.getName());
        if (!Objects.equals(providerName, incoming.getName())) {
            throw new BadRequest("path name and payload name differ");
        }
        SecurityAuthProviderConfig existing = this.loadConfigOrError(providerName);
        if (incoming.getClassName() == null) {
            incoming.setClassName(existing.getClassName());
        } else if (!incoming.getClassName().equals(existing.getClassName())) {
            throw new BadRequest("className cannot change");
        }
        if (incoming.getId() == null) {
            incoming.setId(existing.getId());
        }
        try {
            List<String> order = this.getConfigOrder();
            int currentIdx = order.indexOf(providerName);
            if (currentIdx < 0) {
                throw new ProviderNotFound(providerName);
            }
            this.securityManager.saveAuthenticationProvider(incoming);
            if (position != null) {
                AuthenticationProviderRestController.validatePosition(position, order.size());
                if (currentIdx != position) {
                    order.remove(currentIdx);
                    order.add(position, providerName);
                    this.saveConfigOrder(order);
                }
            }
            this.securityManager.reload();
            return this.wrapObject(incoming, SecurityAuthProviderConfig.class);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
    }

    @DeleteMapping(path={"/{providerName:^(?!order(?:\\.(?:json|xml))?$).+}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable String providerName) {
        this.checkAuthorised();
        providerName = AuthenticationProviderRestController.normalizeName(providerName);
        try {
            SecurityManagerConfig smc = this.securityManager.loadSecurityConfig();
            List order = smc.getAuthProviderNames();
            if (!order.remove(providerName)) {
                throw new NothingToDelete("No provider '" + providerName + "' to delete");
            }
            this.securityManager.saveSecurityConfig(smc);
            SecurityAuthProviderConfig cfg = this.securityManager.loadAuthenticationProviderConfig(providerName);
            this.securityManager.removeAuthenticationProvider(cfg);
            this.securityManager.reload();
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
    }

    @PutMapping(path={"/order", "/order.{ext:xml|json}"}, consumes={"application/xml", "application/json"})
    public ResponseEntity<Void> reorder(HttpServletRequest request) {
        this.checkAuthorised();
        try {
            List<String> wanted = AuthenticationProviderRestController.normalizeNames(this.parseOrder(request));
            Preconditions.checkArgument((!wanted.isEmpty() ? 1 : 0) != 0, (Object)"`order` array required");
            LinkedHashSet<String> dedup = new LinkedHashSet<String>(wanted);
            if (dedup.size() != wanted.size()) {
                throw new BadRequest("Duplicate entries in order");
            }
            SortedSet known = this.securityManager.listAuthenticationProviders();
            for (String n : wanted) {
                if (known.contains(n)) continue;
                throw new BadRequest("Unknown provider: " + n);
            }
            this.saveConfigOrder(wanted);
            this.securityManager.reload();
            return ResponseEntity.ok().build();
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
        catch (Exception e) {
            throw new BadRequest(e.getMessage());
        }
    }

    @GetMapping(path={"/order", "/order.{ext:xml|json}"})
    public ResponseEntity<Void> orderGetNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @PostMapping(path={"/order", "/order.{ext}"})
    public ResponseEntity<Void> orderPostNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    @DeleteMapping(path={"/order", "/order.{ext}"})
    public ResponseEntity<Void> orderDeleteNotAllowed() {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    private static String normalizeName(String n) {
        return n == null ? null : n.replaceFirst("\\.(?i)(xml|json)$", "");
    }

    private static List<String> normalizeNames(List<String> names) {
        ArrayList<String> out = new ArrayList<String>(names.size());
        for (String n : names) {
            out.add(AuthenticationProviderRestController.normalizeName(n));
        }
        return out;
    }

    private Class<? extends SecurityAuthProviderConfig> resolveConfigClass(String className) {
        return CONFIG_CACHE.computeIfAbsent(className, cn -> {
            try {
                Class<?> c = Class.forName(cn);
                if (SecurityAuthProviderConfig.class.isAssignableFrom(c)) {
                    return c;
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
            try {
                String[] candidates;
                Class<?> provider = Class.forName(cn);
                String simple = provider.getSimpleName() + "Config";
                String pkg = provider.getPackage().getName();
                for (String fqn : candidates = new String[]{pkg.replace(".auth", ".config") + "." + simple, "org.geoserver.security.config." + simple, pkg + "." + simple}) {
                    try {
                        Class<?> cfg = Class.forName(fqn);
                        if (!SecurityAuthProviderConfig.class.isAssignableFrom(cfg)) continue;
                        return cfg;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        });
    }

    private SecurityAuthProviderConfig parseConfig(HttpServletRequest req) throws IOException {
        byte[] body = AuthenticationProviderRestController.read(req);
        if (AuthenticationProviderRestController.isXml(req)) {
            AuthProviderCollection c;
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            this.configurePersister(xp, null);
            Object o = xp.load((InputStream)new ByteArrayInputStream(body), Object.class);
            if (o instanceof SecurityAuthProviderConfig) {
                SecurityAuthProviderConfig cfg = (SecurityAuthProviderConfig)o;
                return cfg;
            }
            if (o instanceof AuthProviderCollection && (c = (AuthProviderCollection)o).first() != null) {
                return c.first();
            }
            throw new BadRequest("Malformed XML payload");
        }
        JsonNode n = MAPPER.readTree(body);
        if (n == null || n.isNull()) {
            throw new BadRequest("Empty JSON payload");
        }
        if (n.has("authprovider")) {
            n = n.get("authprovider");
        }
        if (n.has("authproviders") && n.get("authproviders").isArray() && n.get("authproviders").size() == 1) {
            n = n.get("authproviders").get(0);
        }
        if (!n.isObject()) {
            throw new BadRequest("Malformed JSON payload");
        }
        String className = n.path("className").asText(null);
        if (className == null || className.isBlank()) {
            throw new BadRequest("Missing 'className' in JSON payload");
        }
        Class<? extends SecurityAuthProviderConfig> type = this.resolveConfigClass(className);
        if (type == null) {
            throw new BadRequest("Unsupported className: " + className);
        }
        SecurityAuthProviderConfig cfg = (SecurityAuthProviderConfig)MAPPER.treeToValue((TreeNode)n, type);
        this.ensureNotReserved(cfg.getName());
        return cfg;
    }

    private List<String> parseOrder(HttpServletRequest req) throws IOException {
        byte[] body = AuthenticationProviderRestController.read(req);
        if (AuthenticationProviderRestController.isXml(req)) {
            AuthProviderOrder ord;
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            this.configurePersister(xp, null);
            Object o = xp.load((InputStream)new ByteArrayInputStream(body), Object.class);
            if (o instanceof AuthProviderOrder && (ord = (AuthProviderOrder)o).getOrder() != null && !ord.getOrder().isEmpty()) {
                return ord.getOrder();
            }
            throw new BadRequest("`order` array required");
        }
        JsonNode root = MAPPER.readTree(body);
        if (root.has("order")) {
            root = root.get("order");
        }
        if (!root.isArray() || root.isEmpty()) {
            throw new BadRequest("`order` array required");
        }
        ArrayList<String> out = new ArrayList<String>();
        root.forEach(x -> out.add(x.asText()));
        return out;
    }

    private static byte[] read(HttpServletRequest r) throws IOException {
        try (ServletInputStream in = r.getInputStream();){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    private static boolean isXml(HttpServletRequest r) {
        String ct = Optional.ofNullable(r.getContentType()).orElse("");
        return ct.contains("application/xml") || ct.contains("text/xml");
    }

    private List<String> getConfigOrder() throws IOException {
        return new ArrayList<String>(this.securityManager.loadSecurityConfig().getAuthProviderNames());
    }

    private void saveConfigOrder(List<String> order) {
        try {
            SecurityManagerConfig cfg = this.securityManager.loadSecurityConfig();
            cfg.getAuthProviderNames().clear();
            cfg.getAuthProviderNames().addAll(order);
            this.securityManager.saveSecurityConfig(cfg);
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
    }

    private SecurityAuthProviderConfig loadConfigOrError(String n) {
        try {
            SecurityAuthProviderConfig c = this.securityManager.loadAuthenticationProviderConfig(n);
            if (c == null) {
                throw new ProviderNotFound(n);
            }
            return c;
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    private static void validatePosition(int position, int size) {
        Preconditions.checkArgument((position >= 0 && position <= size - (size == 0 ? 0 : 1) + (position == size ? 1 : 0) ? 1 : 0) != 0, (Object)"position out of range");
    }

    private void ensureNotReserved(String n) {
        Preconditions.checkArgument((n != null && !n.isBlank() ? 1 : 0) != 0, (Object)"name required");
        Preconditions.checkArgument((!RESERVED.contains(n.toLowerCase()) ? 1 : 0) != 0, (String)"'%s' is reserved", (Object)n);
    }

    private void checkAuthorised() {
        if (!this.securityManager.checkAuthenticationForAdminRole()) {
            throw new NotAuthorised();
        }
    }

    @ExceptionHandler(value={CannotSaveConfig.class, CannotReadConfig.class, BadRequest.class, ProviderNotFound.class, DuplicateProviderName.class, NothingToDelete.class, NotAuthorised.class, IllegalArgumentException.class})
    public ResponseEntity<ErrorResponse> handle(RuntimeException ex) {
        HttpStatus st = ex instanceof BadRequest || ex instanceof IllegalArgumentException ? HttpStatus.BAD_REQUEST : (ex instanceof ProviderNotFound ? HttpStatus.NOT_FOUND : (ex instanceof DuplicateProviderName ? HttpStatus.BAD_REQUEST : (ex instanceof NothingToDelete ? HttpStatus.GONE : (ex instanceof NotAuthorised ? HttpStatus.FORBIDDEN : HttpStatus.INTERNAL_SERVER_ERROR))));
        return new ResponseEntity((Object)new ErrorResponse(st.value(), ex.getMessage()), st);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    static class CannotReadConfig
    extends RuntimeException {
        CannotReadConfig(Exception e) {
            super("Cannot read security configuration", e);
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    static class BadRequest
    extends RuntimeException {
        BadRequest(String m) {
            super(m);
        }
    }

    static class DuplicateProviderName
    extends RuntimeException {
        DuplicateProviderName(String n) {
            super("Provider '" + n + "' already exists");
        }
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    static class CannotSaveConfig
    extends RuntimeException {
        CannotSaveConfig(Exception e) {
            super("Cannot save security configuration", e);
        }
    }

    static class ProviderNotFound
    extends RuntimeException {
        ProviderNotFound(String n) {
            super("Provider '" + n + "' not found");
        }
    }

    static class NothingToDelete
    extends RuntimeException {
        NothingToDelete(String n) {
            super("No provider '" + n + "' to delete");
        }
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    static class NotAuthorised
    extends RuntimeException {
        NotAuthorised() {
            super("Admin role required");
        }
    }

    static class ErrorResponse {
        private final int status;
        private final String message;

        ErrorResponse(int s, String m) {
            this.status = s;
            this.message = m;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

