/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import java.util.regex.Pattern;
import org.geoserver.rest.security.AbstractAclController;
import org.geoserver.security.impl.RESTAccessRuleDAO;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/rest"})
public class RestAccessController
extends AbstractAclController<String, RESTAccessRuleDAO> {
    static final Pattern KEYPATTERN = Pattern.compile("\\S+:(GET|POST|PUT|DELETE|HEAD|OPTIONS)(,(GET|POST|PUT|DELETE|HEAD|OPTIONS))*");

    public RestAccessController() {
        super(RESTAccessRuleDAO.get());
    }

    @Override
    protected void addRuleToMap(String rule, Map<String, String> map) {
        String[] parts = rule.split("=");
        map.put(parts[0], parts[1]);
    }

    @Override
    protected String keyFor(String rule) {
        return rule.split("=")[0];
    }

    @Override
    protected String convertEntryToRule(Map.Entry<String, String> entry) {
        return entry.getKey() + "=" + entry.getValue();
    }

    @Override
    protected String validateRuleKey(String ruleKey) {
        if (!KEYPATTERN.matcher(ruleKey).matches()) {
            return "Invalid '" + ruleKey + "' not matching " + String.valueOf(KEYPATTERN);
        }
        return null;
    }

    @Override
    protected String getBasePath() {
        return "/security/acl/rest";
    }
}

