/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.security.xml.UserGroupServiceSummary;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/rest/security/usergroupservices"}, produces={"application/xml", "application/json"})
public class UserGroupServiceController
extends RestBaseController {
    private static final Logger LOGGER = Logger.getLogger(UserGroupServiceController.class.getName());
    private final GeoServerSecurityManager securityManager;
    private static final Set<String> DELETE_BLACK_LIST = Set.of("default");

    public UserGroupServiceController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @GetMapping
    public RestWrapper<UserGroupServiceSummary> list() {
        this.checkAuthorisation();
        List<UserGroupServiceSummary> result = this.loadUserGroupServices();
        return this.wrapList(result, UserGroupServiceSummary.class);
    }

    @GetMapping(value={"/{serviceName}"})
    public RestWrapper<SecurityUserGroupServiceConfig> view(@PathVariable(value="serviceName") String serviceName) {
        this.checkAuthorisation();
        try {
            SecurityUserGroupServiceConfig cfg = this.securityManager.loadUserGroupServiceConfig(serviceName);
            if (cfg == null) {
                throw new HttpClientErrorException(HttpStatus.NOT_FOUND, String.format("Cannot find user/group service %s", serviceName));
            }
            return this.wrapObject(cfg, SecurityUserGroupServiceConfig.class);
        }
        catch (IOException e) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot load user/group service config");
        }
    }

    @PostMapping(consumes={"application/xml", "application/json"})
    public RestWrapper<SecurityUserGroupServiceConfig> post(@RequestBody SecurityUserGroupServiceConfig request, UriComponentsBuilder uriComponentsBuilder) {
        this.checkAuthorisation();
        SecurityUserGroupServiceConfig saved = this.saveUserGroupService(request);
        return this.wrapObject(saved, SecurityUserGroupServiceConfig.class);
    }

    @PutMapping(value={"/{serviceName}"}, consumes={"application/xml", "application/json"})
    @ResponseStatus(code=HttpStatus.OK)
    public void put(@PathVariable(value="serviceName") String serviceName, @RequestBody SecurityUserGroupServiceConfig request) {
        this.checkAuthorisation();
        this.updateUserGroupService(serviceName, request);
    }

    @DeleteMapping(value={"/{serviceName}"})
    @ResponseStatus(code=HttpStatus.OK)
    public void delete(@PathVariable(value="serviceName") String serviceName) {
        this.checkAuthorisation();
        this.removeUserGroupService(serviceName);
    }

    private void checkAuthorisation() {
        if (!this.securityManager.checkAuthenticationForAdminRole()) {
            throw new HttpClientErrorException(HttpStatus.FORBIDDEN, "Admin role required to access this resource");
        }
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.getXStream().allowTypesByWildcard(new String[]{"org.geoserver.security.**", "org.geoserver.security.config.**", "org.geoserver.rest.security.xml.**", ((Object)((Object)this)).getClass().getPackage().getName() + ".**"});
        persister.getXStream().processAnnotations(new Class[]{UserGroupServiceSummary.class});
        super.configurePersister(persister, converter);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return UserGroupServiceSummary.class.isAssignableFrom(methodParameter.getParameterType()) || SecurityUserGroupServiceConfig.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected List<UserGroupServiceSummary> loadUserGroupServices() {
        try {
            SortedSet names = this.securityManager.listUserGroupServices();
            ArrayList<UserGroupServiceSummary> out = new ArrayList<UserGroupServiceSummary>();
            for (String name : names) {
                SecurityUserGroupServiceConfig cfg = this.securityManager.loadUserGroupServiceConfig(name);
                if (cfg == null) continue;
                out.add(UserGroupServiceSummary.from(cfg));
            }
            return out;
        }
        catch (IOException ex) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot list user/group services");
        }
    }

    protected SecurityUserGroupServiceConfig saveUserGroupService(SecurityUserGroupServiceConfig newCfg) {
        if (newCfg == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Request body is empty");
        }
        if (Strings.isNullOrEmpty((String)newCfg.getName())) {
            LOGGER.warning("Cannot create user/group service: missing name");
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Cannot create the config: no name parameter provided");
        }
        try {
            if (this.securityManager.loadUserGroupServiceConfig(newCfg.getName()) != null) {
                LOGGER.warning(String.format("Cannot create user/group service %s: name already exists", newCfg.getName()));
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, String.format("Cannot create the config %s because the name is already in use", newCfg.getName()));
            }
        }
        catch (IOException ex) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot access user/group service configs");
        }
        try {
            this.securityManager.saveUserGroupService(newCfg);
            this.securityManager.reload();
        }
        catch (SecurityConfigException sce) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, sce.getMessage());
        }
        catch (IOException ioe) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot save user/group service " + newCfg.getName());
        }
        try {
            return this.securityManager.loadUserGroupServiceConfig(newCfg.getName());
        }
        catch (IOException ex) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot reload user/group service " + newCfg.getName() + " after save");
        }
    }

    protected void updateUserGroupService(String serviceName, SecurityUserGroupServiceConfig request) {
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Request body is empty");
        }
        if (!serviceName.equals(request.getName())) {
            LOGGER.warning(String.format("Cannot modify service %s because the name %s in the body does not match", serviceName, request.getName()));
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, String.format("Cannot modify the config %s because the name %s in the body does not match", serviceName, request.getName()));
        }
        try {
            SecurityUserGroupServiceConfig existing = this.securityManager.loadUserGroupServiceConfig(serviceName);
            if (existing == null) {
                LOGGER.warning(String.format("Cannot update %s because it does not exist", serviceName));
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, String.format("Cannot update %s because it does not exist", serviceName));
            }
            request.setId(existing.getId());
            this.securityManager.saveUserGroupService(request);
            this.securityManager.reload();
        }
        catch (SecurityConfigException sce) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, sce.getMessage());
        }
        catch (IOException ioe) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot update user/group service " + serviceName);
        }
    }

    protected void removeUserGroupService(String serviceName) {
        if (DELETE_BLACK_LIST.contains(serviceName)) {
            LOGGER.warning(String.format("Cannot delete %s because it is a required user/group service", serviceName));
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, String.format("Cannot delete %s because it is a required user/group service", serviceName));
        }
        try {
            SecurityUserGroupServiceConfig cfg = this.securityManager.loadUserGroupServiceConfig(serviceName);
            if (cfg == null) {
                LOGGER.warning(String.format("Cannot delete %s because it does not exist", serviceName));
                throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Cannot find user/group service " + serviceName);
            }
            this.securityManager.removeUserGroupService(cfg);
            this.securityManager.reload();
        }
        catch (SecurityConfigException sce) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, sce.getMessage());
        }
        catch (IOException ioe) {
            throw new HttpClientErrorException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot remove user/group service " + serviceName);
        }
    }

    @ExceptionHandler(value={HttpClientErrorException.class})
    public ResponseEntity<ErrorResponse> handleHttpClientError(HttpClientErrorException ex) {
        HttpStatus status = ex.getStatusCode();
        String message = ex.getStatusText();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).header("Content-Type", new String[]{"application/json"})).body((Object)new ErrorResponse(status.value(), message));
    }

    public static class ErrorResponse {
        private int status;
        private String message;

        public ErrorResponse() {
        }

        public ErrorResponse(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

