/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geoserver.security.config.SecurityAuthProviderConfig;

@XStreamAlias(value="authproviders")
public class AuthProviderCollection {
    private List<SecurityAuthProviderConfig> providers = new ArrayList<SecurityAuthProviderConfig>();

    public AuthProviderCollection() {
    }

    public AuthProviderCollection(List<SecurityAuthProviderConfig> providers) {
        this.setProviders(providers);
    }

    public List<SecurityAuthProviderConfig> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setProviders(List<SecurityAuthProviderConfig> providers) {
        this.providers = providers == null ? new ArrayList<SecurityAuthProviderConfig>() : new ArrayList<SecurityAuthProviderConfig>(providers);
    }

    public SecurityAuthProviderConfig first() {
        return this.providers.isEmpty() ? null : this.providers.get(0);
    }

    public int size() {
        return this.providers.size();
    }

    public boolean isEmpty() {
        return this.providers.isEmpty();
    }

    public void add(SecurityAuthProviderConfig cfg) {
        if (cfg != null) {
            this.providers.add(cfg);
        }
    }

    public String toString() {
        return "AuthProviderCollection{providers=" + String.valueOf(this.providers) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthProviderCollection)) {
            return false;
        }
        AuthProviderCollection that = (AuthProviderCollection)o;
        return Objects.equals(this.providers, that.providers);
    }

    public int hashCode() {
        return Objects.hash(this.providers);
    }
}

